/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json;

import io.kotest.assertions.json.ArrayOrder;
import io.kotest.assertions.json.CompareJsonOptions;
import io.kotest.assertions.json.CompareKt;
import io.kotest.assertions.json.CompareMode;
import io.kotest.assertions.json.CompareOrder;
import io.kotest.assertions.json.FieldComparison;
import io.kotest.assertions.json.JsonError;
import io.kotest.assertions.json.JsonNode;
import io.kotest.assertions.json.NumberFormat;
import io.kotest.assertions.json.PropertyOrder;
import io.kotest.assertions.json.TypeCoercion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a0\u0010\r\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a0\u0010\u000f\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a(\u0010\u0011\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012H\u0000\u001a\u001f\u0010\u0013\u001a\u00020\u00012\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017\u001a \u0010\u0018\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\nH\u0000\u001a(\u0010\u001a\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u001bH\u0002\u001a0\u0010\u001c\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a0\u0010\u001d\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a0\u0010\u001f\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a(\u0010!\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0000\u001a\u0018\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006'"}, d2={"defaultCompareJsonOptions", "Lio/kotest/assertions/json/CompareJsonOptions;", "getDefaultCompareJsonOptions", "()Lio/kotest/assertions/json/CompareJsonOptions;", "compare", "Lio/kotest/assertions/json/JsonError;", "path", "", "", "expected", "Lio/kotest/assertions/json/JsonNode;", "actual", "options", "compareArrays", "Lio/kotest/assertions/json/JsonNode$ArrayNode;", "compareBoolean", "Lio/kotest/assertions/json/JsonNode$BooleanNode;", "compareBooleans", "", "compareJsonOptions", "builder", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "compareNull", "b", "compareNumberNodes", "Lio/kotest/assertions/json/JsonNode$NumberNode;", "compareNumbers", "compareObjects", "Lio/kotest/assertions/json/JsonNode$ObjectNode;", "compareString", "Lio/kotest/assertions/json/JsonNode$StringNode;", "compareStrings", "legacyOptions", "mode", "Lio/kotest/assertions/json/CompareMode;", "order", "Lio/kotest/assertions/json/CompareOrder;", "kotest-assertions-json"})
public final class CompareKt {
    @NotNull
    private static final CompareJsonOptions defaultCompareJsonOptions = new CompareJsonOptions(null, null, null, null, null, 31, null);

    @NotNull
    public static final CompareJsonOptions legacyOptions(@NotNull CompareMode mode, @NotNull CompareOrder order) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
        return CompareKt.compareJsonOptions((Function1<? super CompareJsonOptions, Unit>)((Function1)new Function1<CompareJsonOptions, Unit>(mode, order){
            final /* synthetic */ CompareMode $mode;
            final /* synthetic */ CompareOrder $order;
            {
                this.$mode = $mode;
                this.$order = $order;
                super(1);
            }

            public final void invoke(@NotNull CompareJsonOptions $this$compareJsonOptions) {
                PropertyOrder propertyOrder;
                TypeCoercion typeCoercion;
                Intrinsics.checkNotNullParameter((Object)$this$compareJsonOptions, (String)"$this$compareJsonOptions");
                switch (legacyOptions.WhenMappings.$EnumSwitchMapping$0[this.$mode.ordinal()]) {
                    case 1: {
                        typeCoercion = TypeCoercion.Disabled;
                        break;
                    }
                    case 2: {
                        typeCoercion = TypeCoercion.Enabled;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $this$compareJsonOptions.setTypeCoercion(typeCoercion);
                switch (legacyOptions.WhenMappings.$EnumSwitchMapping$1[this.$order.ordinal()]) {
                    case 1: {
                        propertyOrder = PropertyOrder.Strict;
                        break;
                    }
                    case 2: {
                        propertyOrder = PropertyOrder.Lenient;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $this$compareJsonOptions.setPropertyOrder(propertyOrder);
            }
        }));
    }

    @NotNull
    public static final CompareJsonOptions getDefaultCompareJsonOptions() {
        return defaultCompareJsonOptions;
    }

    @NotNull
    public static final CompareJsonOptions compareJsonOptions(@NotNull Function1<? super CompareJsonOptions, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        CompareJsonOptions compareJsonOptions = new CompareJsonOptions(null, null, null, null, null, 31, null);
        builder.invoke((Object)compareJsonOptions);
        return compareJsonOptions;
    }

    @Nullable
    public static final JsonError compare(@NotNull List<String> path, @NotNull JsonNode expected, @NotNull JsonNode actual, @NotNull CompareJsonOptions options) {
        JsonError jsonError;
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JsonNode jsonNode = expected;
        if (jsonNode instanceof JsonNode.ObjectNode) {
            jsonError = actual instanceof JsonNode.ObjectNode ? CompareKt.compareObjects(path, (JsonNode.ObjectNode)expected, (JsonNode.ObjectNode)actual, options) : (JsonError)new JsonError.ExpectedObject(path, actual);
        } else if (jsonNode instanceof JsonNode.ArrayNode) {
            jsonError = actual instanceof JsonNode.ArrayNode ? CompareKt.compareArrays(path, (JsonNode.ArrayNode)expected, (JsonNode.ArrayNode)actual, options) : (JsonError)new JsonError.ExpectedArray(path, actual);
        } else if (jsonNode instanceof JsonNode.BooleanNode) {
            jsonError = CompareKt.compareBoolean(path, (JsonNode.BooleanNode)expected, actual, options);
        } else if (jsonNode instanceof JsonNode.StringNode) {
            jsonError = CompareKt.compareString(path, (JsonNode.StringNode)expected, actual, options);
        } else if (jsonNode instanceof JsonNode.NumberNode) {
            jsonError = CompareKt.compareNumbers(path, (JsonNode.NumberNode)expected, actual, options);
        } else if (Intrinsics.areEqual((Object)jsonNode, (Object)JsonNode.NullNode.INSTANCE)) {
            jsonError = CompareKt.compareNull(path, actual);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonError;
    }

    @Nullable
    public static final JsonError compareObjects(@NotNull List<String> path, @NotNull JsonNode.ObjectNode expected, @NotNull JsonNode.ObjectNode actual, @NotNull CompareJsonOptions options) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (FieldComparison.Strict == options.getFieldComparison()) {
            Set<String> expectedKeys = expected.getElements().keySet();
            Set<String> actualKeys = actual.getElements().keySet();
            if (actualKeys.size() > expectedKeys.size()) {
                Set extra = SetsKt.minus(actualKeys, (Iterable)expectedKeys);
                return new JsonError.ObjectExtraKeys(path, extra);
            }
            if (actualKeys.size() < expectedKeys.size()) {
                Set missing = SetsKt.minus(expectedKeys, (Iterable)actualKeys);
                return new JsonError.ObjectMissingKeys(path, missing);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[options.getPropertyOrder().ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)CollectionsKt.withIndex((Iterable)expected.getElements().entrySet()), (Iterable)actual.getElements().entrySet());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonError error;
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    IndexedValue e = (IndexedValue)pair.component1();
                    Map.Entry a = (Map.Entry)pair.component2();
                    if (!Intrinsics.areEqual(a.getKey(), ((Map.Entry)e.getValue()).getKey())) {
                        return new JsonError.NameOrderDiff(path, e.getIndex(), (String)((Map.Entry)e.getValue()).getKey(), (String)a.getKey());
                    }
                    JsonError jsonError = error = CompareKt.compare(CollectionsKt.plus((Collection)path, a.getKey()), (JsonNode)((Map.Entry)e.getValue()).getValue(), (JsonNode)a.getValue(), options);
                    if (jsonError == null) continue;
                    return jsonError;
                }
                break;
            }
            case 2: {
                Iterable $this$forEach$iv = expected.getElements().entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonNode a;
                    JsonError error;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String name = (String)entry.getKey();
                    JsonNode e = (JsonNode)entry.getValue();
                    if (actual.getElements().get(name) == null) {
                        return new JsonError.ObjectMissingKeys(path, SetsKt.setOf((Object)name));
                    }
                    JsonError jsonError = error = CompareKt.compare(CollectionsKt.plus((Collection)path, (Object)name), e, a, options);
                    if (jsonError == null) continue;
                    return jsonError;
                }
                break;
            }
        }
        return null;
    }

    @Nullable
    public static final JsonError compareArrays(@NotNull List<String> path, @NotNull JsonNode.ArrayNode expected, @NotNull JsonNode.ArrayNode actual, @NotNull CompareJsonOptions options) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (expected.getElements().size() != actual.getElements().size()) {
            return new JsonError.UnequalArrayLength(path, expected.getElements().size(), actual.getElements().size());
        }
        switch (WhenMappings.$EnumSwitchMapping$1[options.getArrayOrder().ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)CollectionsKt.withIndex((Iterable)expected.getElements()), (Iterable)CollectionsKt.withIndex((Iterable)actual.getElements()));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonError error;
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    IndexedValue a = (IndexedValue)pair.component1();
                    IndexedValue b = (IndexedValue)pair.component2();
                    JsonError jsonError = error = CompareKt.compare(CollectionsKt.plus((Collection)path, (Object)("" + '[' + a.getIndex() + ']')), (JsonNode)a.getValue(), (JsonNode)b.getValue(), options);
                    if (jsonError == null) continue;
                    return jsonError;
                }
                break;
            }
            case 2: {
                int n = 0;
                int n2 = expected.getElements().size();
                boolean[] element$iv = new boolean[n2];
                while (n < n2) {
                    int n3 = n++;
                    element$iv[n3] = false;
                }
                boolean[] consumedIndexes = element$iv;
                Iterator<JsonNode> iterator = actual.getElements().iterator();
                n2 = 0;
                while (iterator.hasNext()) {
                    int i = n2++;
                    JsonNode element2 = iterator.next();
                    Integer n4 = CompareKt.compareArrays$findMatchingIndex(path, expected, options, consumedIndexes, element2);
                    if (n4 == null) {
                        return new JsonError.UnequalArrayContent(CollectionsKt.plus((Collection)path, (Object)("" + '[' + i + ']')), expected, element2);
                    }
                    int match = n4;
                    consumedIndexes[match] = true;
                }
                break;
            }
        }
        return null;
    }

    @Nullable
    public static final JsonError compareString(@NotNull List<String> path, @NotNull JsonNode.StringNode expected, @NotNull JsonNode actual, @NotNull CompareJsonOptions options) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return actual instanceof JsonNode.StringNode ? CompareKt.compareStrings(path, expected.getValue(), ((JsonNode.StringNode)actual).getValue()) : (options.getTypeCoercion().isEnabled$kotest_assertions_json() ? (actual instanceof JsonNode.BooleanNode ? CompareKt.compareStrings(path, expected.getValue(), String.valueOf(((JsonNode.BooleanNode)actual).getValue())) : (actual instanceof JsonNode.NumberNode && expected.contentIsNumber$kotest_assertions_json() ? CompareKt.compareNumberNodes(path, expected.toNumberNode$kotest_assertions_json(), (JsonNode.NumberNode)actual) : (JsonError)new JsonError.IncompatibleTypes(path, expected, actual))) : (JsonError)new JsonError.IncompatibleTypes(path, expected, actual));
    }

    @Nullable
    public static final JsonError compareStrings(@NotNull List<String> path, @NotNull String expected, @NotNull String actual) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        return Intrinsics.areEqual((Object)expected, (Object)actual) ? null : (JsonError)new JsonError.UnequalStrings(path, expected, actual);
    }

    @Nullable
    public static final JsonError compareBoolean(@NotNull List<String> path, @NotNull JsonNode.BooleanNode expected, @NotNull JsonNode actual, @NotNull CompareJsonOptions options) {
        String string2;
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JsonError jsonError = actual instanceof JsonNode.BooleanNode ? CompareKt.compareBooleans(path, expected.getValue(), ((JsonNode.BooleanNode)actual).getValue()) : (options.getTypeCoercion().isEnabled$kotest_assertions_json() && actual instanceof JsonNode.StringNode ? (Intrinsics.areEqual((Object)(string2 = ((JsonNode.StringNode)actual).getValue()), (Object)"true") ? CompareKt.compareBooleans(path, expected.getValue(), true) : (Intrinsics.areEqual((Object)string2, (Object)"false") ? CompareKt.compareBooleans(path, expected.getValue(), false) : (JsonError)new JsonError.UnequalValues(path, expected, actual))) : (JsonError)new JsonError.IncompatibleTypes(path, expected, actual));
        return jsonError;
    }

    @Nullable
    public static final JsonError compareBooleans(@NotNull List<String> path, boolean expected, boolean actual) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return expected == actual ? null : (JsonError)new JsonError.UnequalBooleans(path, expected, actual);
    }

    private static final JsonError compareNumbers(List<String> path, JsonNode.NumberNode expected, JsonNode actual, CompareJsonOptions options) {
        JsonError jsonError;
        block5: {
            JsonNode jsonNode;
            block4: {
                jsonNode = actual;
                if (!(jsonNode instanceof JsonNode.NumberNode)) break block4;
                switch (WhenMappings.$EnumSwitchMapping$2[options.getNumberFormat().ordinal()]) {
                    case 1: {
                        jsonError = !Intrinsics.areEqual((Object)expected.getContent(), (Object)((JsonNode.NumberNode)actual).getContent()) ? new JsonError.UnequalValues(path, expected.getContent(), ((JsonNode.NumberNode)actual).getContent()) : null;
                        break block5;
                    }
                    case 2: {
                        jsonError = CompareKt.compareNumberNodes(path, expected, (JsonNode.NumberNode)actual);
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            jsonError = jsonNode instanceof JsonNode.StringNode ? (options.getTypeCoercion().isEnabled$kotest_assertions_json() && ((JsonNode.StringNode)actual).contentIsNumber$kotest_assertions_json() ? CompareKt.compareNumberNodes(path, expected, ((JsonNode.StringNode)actual).toNumberNode$kotest_assertions_json()) : (JsonError)new JsonError.IncompatibleTypes(path, expected, actual)) : (JsonError)new JsonError.IncompatibleTypes(path, expected, actual);
        }
        return jsonError;
    }

    private static final JsonError compareNumberNodes(List<String> path, JsonNode.NumberNode expected, JsonNode.NumberNode actual) {
        return expected.lenientEquals(actual) ? null : (JsonError)new JsonError.UnequalValues(path, expected.getContent(), actual.getContent());
    }

    @Nullable
    public static final JsonError compareNull(@NotNull List<String> path, @NotNull JsonNode b) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b instanceof JsonNode.NullNode ? null : (JsonError)new JsonError.ExpectedNull(path, b);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Integer> compareArrays$availableIndexes(boolean[] consumedIndexes) {
        void $this$mapIndexedTo$iv$iv;
        boolean[] $this$mapIndexed$iv = consumedIndexes;
        boolean $i$f$mapIndexed = false;
        boolean[] blArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void isConsumed;
            int n = index$iv$iv++;
            void var10_10 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(isConsumed == false ? Integer.valueOf((int)index) : null);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    private static final Integer compareArrays$findMatchingIndex(List<String> $path, JsonNode.ArrayNode $expected, CompareJsonOptions $options, boolean[] consumedIndexes, JsonNode element2) {
        Iterator<Integer> iterator = CompareKt.compareArrays$availableIndexes(consumedIndexes).iterator();
        while (iterator.hasNext()) {
            int i = ((Number)iterator.next()).intValue();
            boolean isMatch = CompareKt.compare(CollectionsKt.plus((Collection)$path, (Object)("" + '[' + i + ']')), element2, $expected.getElements().get(i), $options) == null;
            if (!isMatch) continue;
            return i;
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[PropertyOrder.values().length];
            nArray[PropertyOrder.Strict.ordinal()] = 1;
            nArray[PropertyOrder.Lenient.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ArrayOrder.values().length];
            nArray[ArrayOrder.Strict.ordinal()] = 1;
            nArray[ArrayOrder.Lenient.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[NumberFormat.values().length];
            nArray[NumberFormat.Strict.ordinal()] = 1;
            nArray[NumberFormat.Lenient.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

