/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00192\u00020\u0001:\b\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001b\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u0082\u0001\u0006\u001a\u001b\u001c\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Lio/kotest/assertions/json/JsonNode;", "", "<init>", "()V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "type", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "ObjectNode", "ArrayNode", "ValueNode", "BooleanNode", "StringNode", "NumberNode", "NullNode", "Companion", "Lio/kotest/assertions/json/JsonNode$ArrayNode;", "Lio/kotest/assertions/json/JsonNode$BooleanNode;", "Lio/kotest/assertions/json/JsonNode$NullNode;", "Lio/kotest/assertions/json/JsonNode$NumberNode;", "Lio/kotest/assertions/json/JsonNode$ObjectNode;", "Lio/kotest/assertions/json/JsonNode$StringNode;", "kotest-assertions-json"})
public abstract class JsonNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<KSerializer<Object>> $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new SealedClassSerializer("io.kotest.assertions.json.JsonNode", Reflection.getOrCreateKotlinClass(JsonNode.class), new KClass[0], new KSerializer[0], new Annotation[0]));

    private JsonNode() {
    }

    @NotNull
    public final String type() {
        String string2;
        JsonNode jsonNode = this;
        if (jsonNode instanceof ObjectNode) {
            string2 = "object";
        } else if (jsonNode instanceof ArrayNode) {
            string2 = "array";
        } else if (jsonNode instanceof BooleanNode) {
            string2 = "boolean";
        } else if (jsonNode instanceof StringNode) {
            string2 = "string";
        } else if (jsonNode instanceof NumberNode) {
            string2 = "number";
        } else if (Intrinsics.areEqual((Object)jsonNode, (Object)NullNode.INSTANCE)) {
            string2 = "null";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(JsonNode self, CompositeEncoder output, SerialDescriptor serialDesc) {
    }

    public /* synthetic */ JsonNode(int seen0, SerializationConstructorMarker serializationConstructorMarker) {
    }

    public /* synthetic */ JsonNode(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/kotest/assertions/json/JsonNode$ArrayNode;", "Lio/kotest/assertions/json/JsonNode;", "elements", "", "<init>", "(Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotest-assertions-json"})
    public static final class ArrayNode
    extends JsonNode {
        @NotNull
        private final List<JsonNode> elements;

        public ArrayNode(@NotNull List<? extends JsonNode> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            super(null);
            this.elements = elements;
        }

        @NotNull
        public final List<JsonNode> getElements() {
            return this.elements;
        }

        @NotNull
        public final List<JsonNode> component1() {
            return this.elements;
        }

        @NotNull
        public final ArrayNode copy(@NotNull List<? extends JsonNode> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return new ArrayNode(elements);
        }

        public static /* synthetic */ ArrayNode copy$default(ArrayNode arrayNode, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = arrayNode.elements;
            }
            return arrayNode.copy(list);
        }

        @NotNull
        public String toString() {
            return "ArrayNode(elements=" + this.elements + ')';
        }

        public int hashCode() {
            return ((Object)this.elements).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArrayNode)) {
                return false;
            }
            ArrayNode arrayNode = (ArrayNode)other;
            return Intrinsics.areEqual(this.elements, arrayNode.elements);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/kotest/assertions/json/JsonNode$BooleanNode;", "Lio/kotest/assertions/json/JsonNode;", "Lio/kotest/assertions/json/JsonNode$ValueNode;", "value", "", "<init>", "(Z)V", "getValue", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotest-assertions-json"})
    public static final class BooleanNode
    extends JsonNode
    implements ValueNode {
        private final boolean value;

        public BooleanNode(boolean value) {
            super(null);
            this.value = value;
        }

        public final boolean getValue() {
            return this.value;
        }

        public final boolean component1() {
            return this.value;
        }

        @NotNull
        public final BooleanNode copy(boolean value) {
            return new BooleanNode(value);
        }

        public static /* synthetic */ BooleanNode copy$default(BooleanNode booleanNode, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = booleanNode.value;
            }
            return booleanNode.copy(bl);
        }

        @NotNull
        public String toString() {
            return "BooleanNode(value=" + this.value + ')';
        }

        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BooleanNode)) {
                return false;
            }
            BooleanNode booleanNode = (BooleanNode)other;
            return this.value == booleanNode.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lio/kotest/assertions/json/JsonNode$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lio/kotest/assertions/json/JsonNode;", "kotest-assertions-json"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<JsonNode> serializer() {
            return this.get$cachedSerializer();
        }

        private final /* synthetic */ KSerializer get$cachedSerializer() {
            return (KSerializer)$cachedSerializer$delegate.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/kotest/assertions/json/JsonNode$NullNode;", "Lio/kotest/assertions/json/JsonNode;", "Lio/kotest/assertions/json/JsonNode$ValueNode;", "<init>", "()V", "kotest-assertions-json"})
    public static final class NullNode
    extends JsonNode
    implements ValueNode {
        @NotNull
        public static final NullNode INSTANCE = new NullNode();

        private NullNode() {
            super(null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/kotest/assertions/json/JsonNode$NumberNode;", "Lio/kotest/assertions/json/JsonNode;", "Lio/kotest/assertions/json/JsonNode$ValueNode;", "content", "", "<init>", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "lenientEquals", "", "other", "component1", "copy", "equals", "", "hashCode", "", "toString", "Companion", "kotest-assertions-json"})
    public static final class NumberNode
    extends JsonNode
    implements ValueNode {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String content;
        @NotNull
        private static final Regex exponentRegex = new Regex(".+[eE][+-]?\\d+");

        public NumberNode(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            super(null);
            this.content = content;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final boolean lenientEquals(@NotNull NumberNode other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (Intrinsics.areEqual((Object)other.content, (Object)this.content)) {
                return true;
            }
            CharSequence charSequence = this.content;
            if (exponentRegex.matches(charSequence) ^ exponentRegex.matches(charSequence = (CharSequence)other.content)) {
                return Double.parseDouble(this.content) == Double.parseDouble(other.content);
            }
            Regex fractionalZeroesRegex = new Regex("(\\.\\d*)0+$");
            return Intrinsics.areEqual((Object)NumberNode.lenientEquals$trimInsignificant(fractionalZeroesRegex, this.content), (Object)NumberNode.lenientEquals$trimInsignificant(fractionalZeroesRegex, other.content));
        }

        @NotNull
        public final String component1() {
            return this.content;
        }

        @NotNull
        public final NumberNode copy(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new NumberNode(content);
        }

        public static /* synthetic */ NumberNode copy$default(NumberNode numberNode, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = numberNode.content;
            }
            return numberNode.copy(string2);
        }

        @NotNull
        public String toString() {
            return "NumberNode(content=" + this.content + ')';
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NumberNode)) {
                return false;
            }
            NumberNode numberNode = (NumberNode)other;
            return Intrinsics.areEqual((Object)this.content, (Object)numberNode.content);
        }

        private static final CharSequence lenientEquals$trimInsignificant$lambda$0(MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            char[] cArray = new char[]{'0'};
            return StringsKt.trimEnd((String)((String)it.getGroupValues().get(1)), (char[])cArray);
        }

        private static final String lenientEquals$trimInsignificant(Regex fractionalZeroesRegex, String value) {
            Object object = value;
            Function1 function1 = NumberNode::lenientEquals$trimInsignificant$lambda$0;
            String string2 = fractionalZeroesRegex.replace((CharSequence)object, function1);
            object = new char[1];
            object[0] = 46;
            return StringsKt.trimEnd((String)string2, (char[])object);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/kotest/assertions/json/JsonNode$NumberNode$Companion;", "", "<init>", "()V", "exponentRegex", "Lkotlin/text/Regex;", "kotest-assertions-json"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/kotest/assertions/json/JsonNode$ObjectNode;", "Lio/kotest/assertions/json/JsonNode;", "elements", "", "", "<init>", "(Ljava/util/Map;)V", "getElements", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotest-assertions-json"})
    public static final class ObjectNode
    extends JsonNode {
        @NotNull
        private final Map<String, JsonNode> elements;

        public ObjectNode(@NotNull Map<String, ? extends JsonNode> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            super(null);
            this.elements = elements;
        }

        @NotNull
        public final Map<String, JsonNode> getElements() {
            return this.elements;
        }

        @NotNull
        public final Map<String, JsonNode> component1() {
            return this.elements;
        }

        @NotNull
        public final ObjectNode copy(@NotNull Map<String, ? extends JsonNode> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return new ObjectNode(elements);
        }

        public static /* synthetic */ ObjectNode copy$default(ObjectNode objectNode, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = objectNode.elements;
            }
            return objectNode.copy(map);
        }

        @NotNull
        public String toString() {
            return "ObjectNode(elements=" + this.elements + ')';
        }

        public int hashCode() {
            return ((Object)this.elements).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectNode)) {
                return false;
            }
            ObjectNode objectNode = (ObjectNode)other;
            return Intrinsics.areEqual(this.elements, objectNode.elements);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lio/kotest/assertions/json/JsonNode$StringNode;", "Lio/kotest/assertions/json/JsonNode;", "Lio/kotest/assertions/json/JsonNode$ValueNode;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "contentIsNumber", "", "contentIsNumber$kotest_assertions_json", "toNumberNode", "Lio/kotest/assertions/json/JsonNode$NumberNode;", "toNumberNode$kotest_assertions_json", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "kotest-assertions-json"})
    public static final class StringNode
    extends JsonNode
    implements ValueNode {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String value;
        @NotNull
        private static final Regex numberRegex = new Regex("-?([1-9]\\d*|0)(\\.\\d+)?([eE][+-]?\\d+)?");

        public StringNode(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public final boolean contentIsNumber$kotest_assertions_json() {
            CharSequence charSequence = this.value;
            return numberRegex.matches(charSequence);
        }

        @NotNull
        public final NumberNode toNumberNode$kotest_assertions_json() {
            return new NumberNode(this.value);
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final StringNode copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new StringNode(value);
        }

        public static /* synthetic */ StringNode copy$default(StringNode stringNode, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = stringNode.value;
            }
            return stringNode.copy(string2);
        }

        @NotNull
        public String toString() {
            return "StringNode(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StringNode)) {
                return false;
            }
            StringNode stringNode = (StringNode)other;
            return Intrinsics.areEqual((Object)this.value, (Object)stringNode.value);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/kotest/assertions/json/JsonNode$StringNode$Companion;", "", "<init>", "()V", "numberRegex", "Lkotlin/text/Regex;", "kotest-assertions-json"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lio/kotest/assertions/json/JsonNode$ValueNode;", "", "kotest-assertions-json"})
    public static interface ValueNode {
    }
}

