/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.kotest.assertions.Actual;
import io.kotest.assertions.Expected;
import io.kotest.assertions.IntellijFormatterKt;
import io.kotest.assertions.json.ExtractValueOutcome;
import io.kotest.assertions.json.JsonArrayElementRef;
import io.kotest.assertions.json.JsonSubPathFound;
import io.kotest.assertions.json.JsonSubPathJsonArrayTooShort;
import io.kotest.assertions.json.JsonSubPathNotFound;
import io.kotest.assertions.json.JsonSubPathSearchOutcome;
import io.kotest.assertions.json.KeyvaluesKt;
import io.kotest.assertions.print.PrintKt;
import io.kotest.common.KotestInternal;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a9\u0010\u0000\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u0001*\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u0002H\u0002H\u0086\b\u0082\u0002\n\n\b\b\u0000\u001a\u0004\b\u0003\u0010\u0000\u00a2\u0006\u0002\u0010\u0006\u001a*\u0010\u0007\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u0002H\u0002H\u0086\b\u00a2\u0006\u0002\u0010\u0006\u001a.\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\"\u0006\b\u0000\u0010\u0002\u0018\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u0002H\u0002H\u0086\b\u00a2\u0006\u0002\u0010\u000b\u001aE\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\"\u0004\b\u0000\u0010\u0002\"\u0010\b\u0001\u0010\f*\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u0002H\u00022\u0006\u0010\u000e\u001a\u0002H\fH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a&\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a!\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a8\u0006\u001b"}, d2={"shouldContainJsonKeyValue", "", "T", "", "path", "value", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "shouldNotContainJsonKeyValue", "containJsonKeyValue", "Lio/kotest/matchers/Matcher;", "t", "(Ljava/lang/String;Ljava/lang/Object;)Lio/kotest/matchers/Matcher;", "C", "Ljava/lang/Class;", "tClass", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)Lio/kotest/matchers/Matcher;", "extractByPath", "Lio/kotest/assertions/json/ExtractValueOutcome;", "json", "removeLastPartFromPath", "findValidSubPath", "Lio/kotest/assertions/json/JsonSubPathSearchOutcome;", "getPossibleSizeOfJsonArray", "", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "extractPossiblePathOfJsonArray", "Lio/kotest/assertions/json/JsonArrayElementRef;", "kotest-assertions-json"})
@SourceDebugExtension(value={"SMAP\nkeyvalues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 keyvalues.kt\nio/kotest/assertions/json/KeyvaluesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n31#1:187\n31#1:189\n1#2:188\n1#2:190\n1#2:191\n*S KotlinDebug\n*F\n+ 1 keyvalues.kt\nio/kotest/assertions/json/KeyvaluesKt\n*L\n24#1:187\n28#1:189\n24#1:188\n28#1:190\n*E\n"})
public final class KeyvaluesKt {
    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> void shouldContainJsonKeyValue(String $this$shouldContainJsonKeyValue, String path, T value) {
        Object object;
        T t;
        String string2;
        block3: {
            block2: {
                void it$iv;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                boolean $i$f$shouldContainJsonKeyValue = false;
                boolean $i$f$containJsonKeyValue = false;
                string2 = path;
                t = value;
                object = value;
                if (object == null) break block2;
                T t2 = object;
                T t3 = t;
                String string3 = string2;
                boolean bl = false;
                Class<?> clazz = it$iv.getClass();
                string2 = string3;
                t = t3;
                Class<?> clazz2 = clazz;
                object = clazz2;
                if (clazz2 != null) break block3;
            }
            object = Void.class;
        }
        ShouldKt.should((Object)$this$shouldContainJsonKeyValue, KeyvaluesKt.containJsonKeyValue(string2, t, object));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> void shouldNotContainJsonKeyValue(String $this$shouldNotContainJsonKeyValue, String path, T value) {
        Object object;
        T t;
        String string2;
        block3: {
            block2: {
                void it$iv;
                Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainJsonKeyValue, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                boolean $i$f$shouldNotContainJsonKeyValue = false;
                boolean $i$f$containJsonKeyValue = false;
                string2 = path;
                t = value;
                object = value;
                if (object == null) break block2;
                T t2 = object;
                T t3 = t;
                String string3 = string2;
                boolean bl = false;
                Class<?> clazz = it$iv.getClass();
                string2 = string3;
                t = t3;
                Class<?> clazz2 = clazz;
                object = clazz2;
                if (clazz2 != null) break block3;
            }
            object = Void.class;
        }
        ShouldKt.shouldNot((Object)$this$shouldNotContainJsonKeyValue, KeyvaluesKt.containJsonKeyValue(string2, t, object));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> Matcher<String> containJsonKeyValue(String path, T t) {
        Object object;
        T t2;
        String string2;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                boolean $i$f$containJsonKeyValue = false;
                string2 = path;
                t2 = t;
                object = t;
                if (object == null) break block2;
                T t3 = object;
                T t4 = t2;
                String string3 = string2;
                boolean bl = false;
                Class<?> clazz = it.getClass();
                string2 = string3;
                t2 = t4;
                Class<?> clazz2 = clazz;
                object = clazz2;
                if (clazz2 != null) break block3;
            }
            object = Void.class;
        }
        return KeyvaluesKt.containJsonKeyValue(string2, t2, object);
    }

    @KotestInternal
    @NotNull
    public static final <T, C extends Class<? extends T>> Matcher<String> containJsonKeyValue(@NotNull String path, T t, @NotNull C tClass) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(tClass, (String)"tClass");
        return (Matcher)new Matcher<String>(path, tClass, t){
            final /* synthetic */ String $path;
            final /* synthetic */ C $tClass;
            final /* synthetic */ T $t;
            {
                this.$path = $path;
                this.$tClass = $tClass;
                this.$t = $t;
            }

            private final MatcherResult keyIsAbsentFailure(String validSubPathDescription) {
                return MatcherResult.Companion.invoke(false, () -> containJsonKeyValue.2.keyIsAbsentFailure$lambda$0(this.$path, validSubPathDescription), () -> containJsonKeyValue.2.keyIsAbsentFailure$lambda$1(this.$path));
            }

            private final MatcherResult invalidJsonFailure(String actualJson) {
                return MatcherResult.Companion.invoke(false, () -> containJsonKeyValue.2.invalidJsonFailure$lambda$2(actualJson), () -> containJsonKeyValue.2.invalidJsonFailure$lambda$3(actualJson));
            }

            public MatcherResult test(String value) {
                String string2;
                CharSequence charSequence = value;
                if (charSequence == null || charSequence.length() == 0) {
                    return this.invalidJsonFailure(value);
                }
                if (value.length() < 50) {
                    string2 = ((Object)StringsKt.trim((CharSequence)value)).toString();
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string3 = value.substring(0, 50);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    string2 = stringBuilder.append(((Object)StringsKt.trim((CharSequence)string3)).toString()).append("...").toString();
                }
                String sub = string2;
                ExtractValueOutcome actualKeyValue = KeyvaluesKt.extractByPath(value, this.$path, this.$tClass);
                if (actualKeyValue instanceof ExtractValueOutcome.ExtractedValue) {
                    T actualValue = ((ExtractValueOutcome.ExtractedValue)actualKeyValue).getValue();
                    boolean passed = Intrinsics.areEqual(this.$t, actualValue);
                    return MatcherResult.Companion.invoke(passed, () -> containJsonKeyValue.2.test$lambda$4(this.$path, this.$t, actualValue), () -> containJsonKeyValue.2.test$lambda$5(sub, this.$path, this.$t));
                }
                if (actualKeyValue instanceof ExtractValueOutcome.JsonPathNotFound) {
                    String subPathDescription = KeyvaluesKt.findValidSubPath(value, this.$path).description();
                    return this.keyIsAbsentFailure(subPathDescription);
                }
                throw new NoWhenBranchMatchedException();
            }

            public <U> Matcher<U> contramap(Function1<? super U, String> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<String> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String keyIsAbsentFailure$lambda$0(String $path, String $validSubPathDescription) {
                return "Expected given to contain json key <'" + $path + "'> but key was not found. " + $validSubPathDescription;
            }

            private static final String keyIsAbsentFailure$lambda$1(String $path) {
                return "Expected given to not contain json key <'" + $path + "'> but key was found.";
            }

            private static final String invalidJsonFailure$lambda$2(String $actualJson) {
                return "Expected a valid JSON, but was " + ($actualJson == null ? "null" : "empty");
            }

            private static final String invalidJsonFailure$lambda$3(String $actualJson) {
                return "Expected a valid JSON, but was " + ($actualJson == null ? "null" : "empty");
            }

            private static final String test$lambda$4(String $path, Object $t, Object $actualValue) {
                return "Value mismatch at '" + $path + "': " + IntellijFormatterKt.intellijFormatError((Expected)new Expected(PrintKt.print((Object)$t)), (Actual)new Actual(PrintKt.print((Object)$actualValue)));
            }

            private static final String test$lambda$5(String $sub, String $path, Object $t) {
                return $sub + " should not contain the element " + $path + " = " + $t;
            }
        };
    }

    @NotNull
    public static final ExtractValueOutcome extractByPath(@Nullable String json, @NotNull String path, @NotNull Class<?> tClass) {
        ExtractValueOutcome extractValueOutcome;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(tClass, (String)"tClass");
        DocumentContext parsedJson = JsonPath.parse((String)json);
        try {
            Object extractedValue = parsedJson.read(path, tClass, new Predicate[0]);
            extractValueOutcome = new ExtractValueOutcome.ExtractedValue<Object>(extractedValue);
        }
        catch (PathNotFoundException e) {
            extractValueOutcome = ExtractValueOutcome.JsonPathNotFound.INSTANCE;
        }
        catch (InvalidPathException e) {
            throw new AssertionError((Object)(path + " is not a valid JSON path"));
        }
        return extractValueOutcome;
    }

    @NotNull
    public static final String removeLastPartFromPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] stringArray = new String[]{"."};
        List tokens = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)tokens, (int)(tokens.size() - 1)), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final JsonSubPathSearchOutcome findValidSubPath(@Nullable String json, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DocumentContext parsedJson = JsonPath.parse((String)json);
        String subPath = path;
        while (((CharSequence)subPath).length() > 0 && !Intrinsics.areEqual((Object)subPath, (Object)"$")) {
            try {
                parsedJson.read(subPath, Object.class, new Predicate[0]);
                return new JsonSubPathFound(subPath);
            }
            catch (PathNotFoundException e) {
                if (KeyvaluesKt.extractPossiblePathOfJsonArray(subPath) != null) {
                    JsonArrayElementRef possiblePathOfJsonArray;
                    boolean bl = false;
                    Integer n = KeyvaluesKt.getPossibleSizeOfJsonArray(json, possiblePathOfJsonArray.getPathToArray());
                    if (n != null) {
                        int sizeOfJsonArray = ((Number)n).intValue();
                        boolean bl2 = false;
                        return new JsonSubPathJsonArrayTooShort(possiblePathOfJsonArray.getPathToArray(), sizeOfJsonArray, possiblePathOfJsonArray.getIndex());
                    }
                }
                subPath = KeyvaluesKt.removeLastPartFromPath(subPath);
            }
        }
        return JsonSubPathNotFound.INSTANCE;
    }

    @Nullable
    public static final Integer getPossibleSizeOfJsonArray(@Nullable String json, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            DocumentContext parsedJson = JsonPath.parse((String)json);
            List possibleJsonArray = (List)parsedJson.read(path, List.class, new Predicate[0]);
            return possibleJsonArray.size();
        }
        catch (Exception ignore) {
            Integer n = null;
            return n;
        }
    }

    @Nullable
    public static final JsonArrayElementRef extractPossiblePathOfJsonArray(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] stringArray = new String[]{"."};
        List pathElements = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String lastPathElement = (String)CollectionsKt.last((List)pathElements);
        String[] stringArray2 = new String[]{"["};
        List tokens = StringsKt.split$default((CharSequence)lastPathElement, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        if (StringsKt.last((CharSequence)path) != ']') {
            return null;
        }
        if (tokens.size() != 2) {
            return null;
        }
        String possibleNumber = StringsKt.dropLast((String)((String)tokens.get(1)), (int)1);
        Integer n = StringsKt.toIntOrNull((String)possibleNumber);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            return new JsonArrayElementRef(CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)pathElements, (int)1), tokens.get(0)), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), it);
        }
        return null;
    }
}

