/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json.comparisons;

import io.kotest.assertions.json.CompareJsonOptions;
import io.kotest.assertions.json.JsonError;
import io.kotest.assertions.json.JsonNode;
import io.kotest.assertions.json.comparisons.CompareArraysKt;
import io.kotest.assertions.json.comparisons.CompareBooleanKt;
import io.kotest.assertions.json.comparisons.CompareNullKt;
import io.kotest.assertions.json.comparisons.CompareNumbersKt;
import io.kotest.assertions.json.comparisons.CompareObjectsKt;
import io.kotest.assertions.json.comparisons.CompareStringKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"compare", "Lio/kotest/assertions/json/JsonError;", "path", "", "", "expected", "Lio/kotest/assertions/json/JsonNode;", "actual", "options", "Lio/kotest/assertions/json/CompareJsonOptions;", "kotest-assertions-json"})
public final class CompareKt {
    @Nullable
    public static final JsonError compare(@NotNull List<String> path, @NotNull JsonNode expected, @NotNull JsonNode actual, @NotNull CompareJsonOptions options) {
        JsonError jsonError;
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JsonNode jsonNode = expected;
        if (jsonNode instanceof JsonNode.ObjectNode) {
            jsonError = actual instanceof JsonNode.ObjectNode ? CompareObjectsKt.compareObjects(path, (JsonNode.ObjectNode)expected, (JsonNode.ObjectNode)actual, options) : (JsonError)new JsonError.ExpectedObject(path, actual);
        } else if (jsonNode instanceof JsonNode.ArrayNode) {
            jsonError = actual instanceof JsonNode.ArrayNode ? CompareArraysKt.compareArrays(path, (JsonNode.ArrayNode)expected, (JsonNode.ArrayNode)actual, options) : (JsonError)new JsonError.ExpectedArray(path, actual);
        } else if (jsonNode instanceof JsonNode.BooleanNode) {
            jsonError = CompareBooleanKt.compareBoolean(path, (JsonNode.BooleanNode)expected, actual, options);
        } else if (jsonNode instanceof JsonNode.StringNode) {
            jsonError = CompareStringKt.compareString(path, (JsonNode.StringNode)expected, actual, options);
        } else if (jsonNode instanceof JsonNode.NumberNode) {
            jsonError = CompareNumbersKt.compareNumbers(path, (JsonNode.NumberNode)expected, actual, options);
        } else if (Intrinsics.areEqual((Object)jsonNode, (Object)JsonNode.NullNode.INSTANCE)) {
            jsonError = CompareNullKt.compareNull(path, actual);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonError;
    }
}

