/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json.comparisons;

import io.kotest.assertions.json.CompareJsonOptions;
import io.kotest.assertions.json.FieldComparison;
import io.kotest.assertions.json.JsonError;
import io.kotest.assertions.json.JsonNode;
import io.kotest.assertions.json.PropertyOrder;
import io.kotest.assertions.json.comparisons.CompareKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"compareObjects", "Lio/kotest/assertions/json/JsonError;", "path", "", "", "expected", "Lio/kotest/assertions/json/JsonNode$ObjectNode;", "actual", "options", "Lio/kotest/assertions/json/CompareJsonOptions;", "kotest-assertions-json"})
@SourceDebugExtension(value={"SMAP\nCompareObjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareObjects.kt\nio/kotest/assertions/json/comparisons/CompareObjectsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1863#2,2:51\n1863#2,2:53\n*S KotlinDebug\n*F\n+ 1 CompareObjects.kt\nio/kotest/assertions/json/comparisons/CompareObjectsKt\n*L\n34#1:51,2\n41#1:53,2\n*E\n"})
public final class CompareObjectsKt {
    @Nullable
    public static final JsonError compareObjects(@NotNull List<String> path, @NotNull JsonNode.ObjectNode expected, @NotNull JsonNode.ObjectNode actual, @NotNull CompareJsonOptions options) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (FieldComparison.Strict == options.getFieldComparison()) {
            Set<String> expectedKeys = expected.getElements().keySet();
            Set<String> actualKeys = actual.getElements().keySet();
            Set extraKeys = SetsKt.minus(actualKeys, (Iterable)expectedKeys);
            Set missingKeys = SetsKt.minus(expectedKeys, (Iterable)actualKeys);
            if (!((Collection)extraKeys).isEmpty() && !((Collection)missingKeys).isEmpty()) {
                return new JsonError.ObjectExtraAndMissingKeys(path, extraKeys, missingKeys);
            }
            if (!((Collection)extraKeys).isEmpty()) {
                return new JsonError.ObjectExtraKeys(path, extraKeys);
            }
            if (!((Collection)missingKeys).isEmpty()) {
                return new JsonError.ObjectMissingKeys(path, missingKeys);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[options.getPropertyOrder().ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)CollectionsKt.withIndex((Iterable)expected.getElements().entrySet()), (Iterable)actual.getElements().entrySet());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonError error;
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    IndexedValue e = (IndexedValue)pair.component1();
                    Map.Entry a = (Map.Entry)pair.component2();
                    if (!Intrinsics.areEqual(a.getKey(), ((Map.Entry)e.getValue()).getKey())) {
                        return new JsonError.NameOrderDiff(path, e.getIndex(), (String)((Map.Entry)e.getValue()).getKey(), (String)a.getKey());
                    }
                    JsonError jsonError = error = CompareKt.compare(CollectionsKt.plus((Collection)path, a.getKey()), (JsonNode)((Map.Entry)e.getValue()).getValue(), (JsonNode)a.getValue(), options);
                    if (jsonError == null) continue;
                    return jsonError;
                }
                break;
            }
            case 2: {
                Iterable $this$forEach$iv = expected.getElements().entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonNode a;
                    JsonError error;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String name = (String)entry.getKey();
                    JsonNode e = (JsonNode)entry.getValue();
                    if (actual.getElements().get(name) == null) {
                        return new JsonError.ObjectMissingKeys(path, SetsKt.setOf((Object)name));
                    }
                    JsonError jsonError = error = CompareKt.compare(CollectionsKt.plus((Collection)path, (Object)name), e, a, options);
                    if (jsonError == null) continue;
                    return jsonError;
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PropertyOrder.values().length];
            try {
                nArray[PropertyOrder.Strict.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOrder.Lenient.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

