/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json.schema;

import io.kotest.assertions.json.ContainsSpec;
import io.kotest.assertions.json.JsonMatchersKt;
import io.kotest.assertions.json.JsonNode;
import io.kotest.assertions.json.JsonTree;
import io.kotest.assertions.json.schema.JsonSchema;
import io.kotest.assertions.json.schema.JsonSchemaElement;
import io.kotest.assertions.json.schema.MatchSchemaKt;
import io.kotest.assertions.json.schema.SchemaViolation;
import io.kotest.common.ExperimentalKotest;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherKt;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0087\u0004\u001a\u0017\u0010\u0005\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0087\u0004\u001a\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0087\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0087\u0004\u001a\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0003\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0014H\u0002\"\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"shouldMatchSchema", "", "", "schema", "Lio/kotest/assertions/json/schema/JsonSchema;", "shouldNotMatchSchema", "stringJsonMatcher", "Lio/kotest/matchers/Matcher;", "Lkotlinx/serialization/json/JsonElement;", "parseToJson", "getParseToJson", "()Lio/kotest/matchers/Matcher;", "matchSchema", "validate", "", "Lio/kotest/assertions/json/schema/SchemaViolation;", "currentPath", "tree", "Lio/kotest/assertions/json/JsonNode;", "expected", "Lio/kotest/assertions/json/schema/JsonSchemaElement;", "isCompatible", "", "actual", "kotest-assertions-json"})
@SourceDebugExtension(value={"SMAP\nmatchSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 matchSchema.kt\nio/kotest/assertions/json/schema/MatchSchemaKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n827#2:188\n855#2,2:189\n1368#2:191\n1454#2,5:192\n1567#2:204\n1598#2,4:205\n1782#2,4:209\n77#3:197\n97#3,5:198\n1#4:203\n*S KotlinDebug\n*F\n+ 1 matchSchema.kt\nio/kotest/assertions/json/schema/MatchSchemaKt\n*L\n129#1:188\n129#1:189,2\n130#1:191\n130#1:192,5\n94#1:204\n94#1:205,4\n97#1:209,4\n135#1:197\n135#1:198,5\n*E\n"})
public final class MatchSchemaKt {
    @NotNull
    private static final Matcher<String> parseToJson = (Matcher)new Matcher<String>(){

        public MatcherResult test(String value) {
            Object object;
            if (value == null) {
                return MatcherResult.Companion.invoke(false, parseToJson.1::test$lambda$0, parseToJson.1::test$lambda$1);
            }
            parseToJson.1 var3_2 = this;
            try {
                parseToJson.1 $this$test_u24lambda_u242 = var3_2;
                boolean bl = false;
                object = Result.constructor-impl((Object)Json.Default.parseToJsonElement(value));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object parsed = object;
            return MatcherResult.Companion.invoke(Result.isSuccess-impl((Object)parsed), () -> parseToJson.1.test$lambda$3(parsed), () -> parseToJson.1.test$lambda$4(parsed));
        }

        public <U> Matcher<U> contramap(Function1<? super U, String> f) {
            return Matcher.DefaultImpls.contramap((Matcher)this, f);
        }

        public Matcher<String> invert() {
            return Matcher.DefaultImpls.invert((Matcher)this);
        }

        public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
            return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
        }

        private static final String test$lambda$0() {
            return "expected null to match schema: ";
        }

        private static final String test$lambda$1() {
            return "expected not to match schema, but null matched JsonNull schema";
        }

        private static final String test$lambda$3(Object $parsed) {
            Throwable throwable = Result.exceptionOrNull-impl((Object)$parsed);
            return "Failed to parse actual as JSON: " + (throwable != null ? throwable.getMessage() : null);
        }

        private static final String test$lambda$4(Object $parsed) {
            Throwable throwable = Result.exceptionOrNull-impl((Object)$parsed);
            return "Failed to parse actual as JSON: " + (throwable != null ? throwable.getMessage() : null);
        }
    };

    @ExperimentalKotest
    public static final void shouldMatchSchema(@Nullable String $this$shouldMatchSchema, @NotNull JsonSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        ShouldKt.should((Object)$this$shouldMatchSchema, MatchSchemaKt.stringJsonMatcher(schema));
    }

    @ExperimentalKotest
    public static final void shouldNotMatchSchema(@Nullable String $this$shouldNotMatchSchema, @NotNull JsonSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        ShouldKt.shouldNot((Object)$this$shouldNotMatchSchema, MatchSchemaKt.stringJsonMatcher(schema));
    }

    @ExperimentalKotest
    @NotNull
    public static final Matcher<String> stringJsonMatcher(@NotNull JsonSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return MatcherKt.and(parseToJson, (Matcher)MatchSchemaKt.matchSchema(schema).contramap(MatchSchemaKt::stringJsonMatcher$lambda$0));
    }

    @ExperimentalKotest
    public static final void shouldMatchSchema(@NotNull JsonElement $this$shouldMatchSchema, @NotNull JsonSchema schema) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldMatchSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        ShouldKt.should((Object)$this$shouldMatchSchema, MatchSchemaKt.matchSchema(schema));
    }

    @ExperimentalKotest
    public static final void shouldNotMatchSchema(@NotNull JsonElement $this$shouldNotMatchSchema, @NotNull JsonSchema schema) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotMatchSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        ShouldKt.shouldNot((Object)$this$shouldNotMatchSchema, MatchSchemaKt.matchSchema(schema));
    }

    @NotNull
    public static final Matcher<String> getParseToJson() {
        return parseToJson;
    }

    @ExperimentalKotest
    @NotNull
    public static final Matcher<JsonElement> matchSchema(@NotNull JsonSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return (Matcher)new Matcher<JsonElement>(schema){
            final /* synthetic */ JsonSchema $schema;
            {
                this.$schema = $schema;
            }

            public MatcherResult test(JsonElement value) {
                if (value == null) {
                    return MatcherResult.Companion.invoke(false, matchSchema.1::test$lambda$0, matchSchema.1::test$lambda$1);
                }
                JsonTree tree = JsonMatchersKt.toJsonTree(value);
                List violations = MatchSchemaKt.access$validate("$", tree.getRoot(), this.$schema.getRoot());
                return MatcherResult.Companion.invoke(violations.isEmpty(), () -> matchSchema.1.test$lambda$3(violations), matchSchema.1::test$lambda$4);
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends JsonElement> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<JsonElement> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0() {
                return "expected null to match schema: ";
            }

            private static final String test$lambda$1() {
                return "expected not to match schema, but null matched JsonNull schema";
            }

            private static final CharSequence test$lambda$3$lambda$2(SchemaViolation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getPath() + " => " + it.getMessage();
            }

            private static final String test$lambda$3(List $violations) {
                return CollectionsKt.joinToString$default((Iterable)$violations, (CharSequence)"\n", null, null, (int)0, null, matchSchema.1::test$lambda$3$lambda$2, (int)30, null);
            }

            private static final String test$lambda$4() {
                return "Expected some violation against JSON schema, but everything matched";
            }
        };
    }

    @ExperimentalKotest
    private static final List<SchemaViolation> validate(String currentPath, JsonNode tree, JsonSchemaElement expected) {
        List<SchemaViolation> list;
        JsonNode jsonNode = tree;
        if (jsonNode instanceof JsonNode.ArrayNode) {
            if (expected instanceof JsonSchema.JsonArray) {
                List<SchemaViolation> list2;
                List<SchemaViolation> containsViolation;
                List<SchemaViolation> sizeViolation = MatchSchemaKt.validate$violationIf(currentPath, ((JsonNode.ArrayNode)tree).getElements().size() < ((JsonSchema.JsonArray)expected).getMinItems() || ((JsonNode.ArrayNode)tree).getElements().size() > ((JsonSchema.JsonArray)expected).getMaxItems(), "Expected items between " + ((JsonSchema.JsonArray)expected).getMinItems() + " and " + ((JsonSchema.JsonArray)expected).getMaxItems() + ", but was " + ((JsonNode.ArrayNode)tree).getElements().size());
                List<SchemaViolation> matcherViolation = MatchSchemaKt.validate$violation$2(currentPath, ((JsonSchema.JsonArray)expected).getMatcher(), CollectionsKt.asSequence((Iterable)((JsonNode.ArrayNode)tree).getElements()));
                Object object = ((JsonSchema.JsonArray)expected).getContains();
                if (object == null || (object = MatchSchemaKt.validate$violation$5((ContainsSpec)object, currentPath, (JsonNode.ArrayNode)tree)) == null) {
                    object = containsViolation = CollectionsKt.emptyList();
                }
                if ((list2 = ((JsonSchema.JsonArray)expected).getElementType()) == null || (list2 = MatchSchemaKt.validate$violation$7((JsonSchemaElement)((Object)list2), currentPath, (JsonNode.ArrayNode)tree)) == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List<SchemaViolation> elementTypeViolation = list2;
                list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)matcherViolation, (Iterable)sizeViolation), (Iterable)containsViolation), (Iterable)elementTypeViolation);
            } else {
                list = MatchSchemaKt.validate$violation(currentPath, "Expected " + expected.typeName() + ", but was array");
            }
        } else if (jsonNode instanceof JsonNode.ObjectNode) {
            if (expected instanceof JsonSchema.JsonObject) {
                List list3;
                Map<String, JsonSchemaElement> $this$flatMapTo$iv$iv;
                boolean $i$f$flatMapTo;
                Map<String, JsonSchemaElement> $this$flatMap$iv;
                boolean $i$f$flatMap;
                Object element$iv$iv;
                Iterator<Object> iterator;
                Collection destination$iv$iv;
                if (!((JsonSchema.JsonObject)expected).getAdditionalProperties()) {
                    String it;
                    Map<String, JsonSchemaElement> $this$filterNotTo$iv$iv;
                    Iterable $this$filterNot$iv;
                    Iterable matcherViolation = ((JsonNode.ObjectNode)tree).getElements().keySet();
                    boolean $i$f$filterNot = false;
                    void elementTypeViolation = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    iterator = $this$filterNotTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = iterator.next();
                        it = (String)element$iv$iv;
                        boolean bl = false;
                        if (((JsonSchema.JsonObject)expected).getProperties().keySet().contains(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterNot$iv = (List)destination$iv$iv;
                    $i$f$flatMap = false;
                    $this$filterNotTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$flatMapTo = false;
                    iterator = $this$flatMapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = iterator.next();
                        it = (String)element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = MatchSchemaKt.validate$propertyViolation(currentPath, it, "Key undefined in schema, and schema is set to disallow extra keys");
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list3 = (List)destination$iv$iv;
                } else {
                    list3 = CollectionsKt.emptyList();
                }
                List extraKeyViolations = list3;
                $this$flatMap$iv = ((JsonSchema.JsonObject)expected).getProperties();
                Collection collection = extraKeyViolations;
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object = element$iv$iv = (Map.Entry)iterator.next();
                    boolean bl = false;
                    String propertyName = (String)object.getKey();
                    JsonSchemaElement schema = (JsonSchemaElement)object.getValue();
                    JsonNode actual = ((JsonNode.ObjectNode)tree).getElements().get(propertyName);
                    Iterable list$iv$iv = actual == null ? (((JsonSchema.JsonObject)expected).getRequiredProperties().contains(propertyName) ? MatchSchemaKt.validate$propertyViolation(currentPath, propertyName, "Expected " + schema.typeName() + ", but was undefined") : CollectionsKt.emptyList()) : MatchSchemaKt.validate(currentPath + '.' + propertyName, actual, schema);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            } else {
                list = MatchSchemaKt.validate$violation(currentPath, "Expected " + expected.typeName() + ", but was object");
            }
        } else {
            if (jsonNode instanceof JsonNode.NullNode) {
                String string2 = "Check how Json schema handles null";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
            if (jsonNode instanceof JsonNode.NumberNode) {
                JsonSchemaElement jsonSchemaElement = expected;
                list = jsonSchemaElement instanceof JsonSchema.JsonInteger ? (StringsKt.contains$default((CharSequence)((JsonNode.NumberNode)tree).getContent(), (CharSequence)".", (boolean)false, (int)2, null) ? MatchSchemaKt.validate$violation(currentPath, "Expected integer, but was number") : MatchSchemaKt.validate$violation$2(currentPath, ((JsonSchema.JsonInteger)expected).getMatcher(), Long.parseLong(((JsonNode.NumberNode)tree).getContent()))) : (jsonSchemaElement instanceof JsonSchema.JsonDecimal ? MatchSchemaKt.validate$violation$2(currentPath, ((JsonSchema.JsonDecimal)expected).getMatcher(), Double.parseDouble(((JsonNode.NumberNode)tree).getContent())) : MatchSchemaKt.validate$violation(currentPath, "Expected " + expected.typeName() + ", but was " + tree.type()));
            } else if (jsonNode instanceof JsonNode.StringNode) {
                list = expected instanceof JsonSchema.JsonString ? MatchSchemaKt.validate$violation$2(currentPath, ((JsonSchema.JsonString)expected).getMatcher(), ((JsonNode.StringNode)tree).getValue()) : MatchSchemaKt.validate$violation(currentPath, "Expected " + expected.typeName() + ", but was " + tree.type());
            } else if (jsonNode instanceof JsonNode.BooleanNode) {
                list = !MatchSchemaKt.isCompatible(tree, expected) ? MatchSchemaKt.validate$violation(currentPath, "Expected " + expected.typeName() + ", but was " + tree.type()) : CollectionsKt.emptyList();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private static final boolean isCompatible(JsonNode actual, JsonSchemaElement schema) {
        return actual instanceof JsonNode.BooleanNode && schema instanceof JsonSchema.JsonBoolean || actual instanceof JsonNode.StringNode && schema instanceof JsonSchema.JsonString || actual instanceof JsonNode.NumberNode && schema instanceof JsonSchema.JsonNumber;
    }

    private static final JsonElement stringJsonMatcher$lambda$0(String it) {
        JsonElement jsonElement;
        String string2 = it;
        if (string2 != null) {
            String string3 = string2;
            Json.Default default_ = Json.Default;
            String p0 = string3;
            boolean bl = false;
            jsonElement = default_.parseToJsonElement(p0);
        } else {
            jsonElement = null;
        }
        return jsonElement;
    }

    private static final List<SchemaViolation> validate$propertyViolation(String $currentPath, String propertyName, String message) {
        return CollectionsKt.listOf((Object)new SchemaViolation($currentPath + '.' + propertyName, message, null, 4, null));
    }

    private static final List<SchemaViolation> validate$violation(String $currentPath, String message) {
        return CollectionsKt.listOf((Object)new SchemaViolation($currentPath, message, null, 4, null));
    }

    private static final List<SchemaViolation> validate$violationIf(String $currentPath, boolean conditionResult, String message) {
        return conditionResult ? MatchSchemaKt.validate$violation($currentPath, message) : CollectionsKt.emptyList();
    }

    private static final <T> List<SchemaViolation> validate$violation$2(String $currentPath, Matcher<? super T> matcher, T value) {
        Object object;
        block3: {
            block2: {
                object = matcher;
                if (object == null) break block2;
                Matcher<? super T> it = object;
                boolean bl = false;
                MatcherResult matcherResult = it.test(value);
                List<SchemaViolation> list = MatchSchemaKt.validate$violationIf($currentPath, !matcherResult.passed(), matcherResult.failureMessage());
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SchemaViolation> validate$violation$5(ContainsSpec $this$validate_u24violation_u245, String $currentPath, JsonNode.ArrayNode tree) {
        List<SchemaViolation> list;
        int foundElements;
        int n;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = tree.getElements();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void node;
            void i;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MatchSchemaKt.validate('\t' + $currentPath + '[' + (int)i + ']', (JsonNode)node, $this$validate_u24violation_u245.getSchema()));
        }
        List schemaViolations = (List)destination$iv$iv;
        Iterable $this$count$iv = schemaViolations;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                List it = (List)element$iv;
                boolean bl = false;
                if (!it.isEmpty() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = foundElements = count$iv;
        }
        if (foundElements == 0) {
            list = CollectionsKt.plus((Collection)MatchSchemaKt.validate$violation($currentPath, "Expected some item to match contains-specification:"), (Iterable)CollectionsKt.flatten((Iterable)schemaViolations));
        } else {
            int n4 = $this$validate_u24violation_u245.getMinContains();
            list = !(foundElements <= $this$validate_u24violation_u245.getMaxContains() ? n4 <= foundElements : false) ? MatchSchemaKt.validate$violation($currentPath, "Expected items of type " + $this$validate_u24violation_u245.getSchema().typeName() + " between " + $this$validate_u24violation_u245.getMinContains() + " and " + $this$validate_u24violation_u245.getMaxContains() + ", but found " + foundElements) : CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SchemaViolation> validate$violation$7(JsonSchemaElement $this$validate_u24violation_u247, String $currentPath, JsonNode.ArrayNode tree) {
        Iterable iterable = tree.getElements();
        Collection collection = new ArrayList();
        int n = 0;
        for (Object t : iterable) {
            void node;
            int n2;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsonNode jsonNode = (JsonNode)t;
            int i = n2;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)MatchSchemaKt.validate($currentPath + '[' + i + ']', (JsonNode)node, $this$validate_u24violation_u247));
        }
        return (List)collection;
    }

    public static final /* synthetic */ List access$validate(String currentPath, JsonNode tree, JsonSchemaElement expected) {
        return MatchSchemaKt.validate(currentPath, tree, expected);
    }
}

