/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.throwables;

import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.jvmcounter;
import io.kotest.assertions.show.ShowKt;
import io.kotest.assertions.show.StringShow;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00a2\u0006\u0002\u0010\u0004\u001a\u0017\u0010\u0005\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0086\b\u001a%\u0010\u0007\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u001a\u0019\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0003H\u0086\b\u001a\u0017\u0010\r\u001a\u00020\u000b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0086\b\u001a%\u0010\u000e\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00a8\u0006\u000f"}, d2={"shouldNotThrowAny", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shouldNotThrowAnyUnit", "", "shouldNotThrowMessage", "message", "", "shouldThrowAny", "", "", "shouldThrowAnyUnit", "shouldThrowMessage", "kotest-assertions-shared"})
public final class AnyThrowableHandlingKt {
    @NotNull
    public static final Throwable shouldThrowAnyUnit(@NotNull Function0<Unit> block) {
        Throwable thrownException$iv;
        Throwable throwable;
        int $i$f$shouldThrowAnyUnit = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        boolean $i$f$shouldThrowAny = false;
        jvmcounter.getAssertionCounter().inc();
        try {
            block.invoke();
            throwable = null;
        }
        catch (Throwable e$iv) {
            throwable = e$iv;
        }
        Throwable throwable2 = thrownException$iv = throwable;
        if (throwable2 == null) {
            throw (Throwable)((Object)FailuresKt.failure("Expected a throwable, but nothing was thrown."));
        }
        return throwable2;
    }

    public static final void shouldNotThrowAnyUnit(@NotNull Function0<Unit> block) {
        int $i$f$shouldNotThrowAnyUnit = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        boolean $i$f$shouldNotThrowAny = false;
        jvmcounter.getAssertionCounter().inc();
        try {
            block.invoke();
        }
        catch (Throwable e$iv) {
            Throwable throwable;
            Throwable thrownException$iv = throwable = e$iv;
            throw (Throwable)((Object)FailuresKt.failure("No exception expected, but a " + Reflection.getOrCreateKotlinClass(thrownException$iv.getClass()).getSimpleName() + " was thrown.", thrownException$iv));
        }
    }

    @NotNull
    public static final Throwable shouldThrowAny(@NotNull Function0<? extends Object> block) {
        Throwable thrownException;
        Throwable throwable;
        int $i$f$shouldThrowAny = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        jvmcounter.getAssertionCounter().inc();
        try {
            block.invoke();
            throwable = null;
        }
        catch (Throwable e) {
            throwable = e;
        }
        Throwable throwable2 = thrownException = throwable;
        if (throwable2 == null) {
            throw (Throwable)((Object)FailuresKt.failure("Expected a throwable, but nothing was thrown."));
        }
        return throwable2;
    }

    public static final <T> T shouldNotThrowAny(@NotNull Function0<? extends T> block) {
        int $i$f$shouldNotThrowAny = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        jvmcounter.getAssertionCounter().inc();
        try {
            return (T)block.invoke();
        }
        catch (Throwable e) {
            Throwable throwable;
            Throwable thrownException = throwable = e;
            throw (Throwable)((Object)FailuresKt.failure("No exception expected, but a " + Reflection.getOrCreateKotlinClass(thrownException.getClass()).getSimpleName() + " was thrown.", thrownException));
        }
    }

    public static final <T> void shouldThrowMessage(@NotNull String message, @NotNull Function0<? extends T> block) {
        Throwable thrownException;
        Throwable throwable;
        int $i$f$shouldThrowMessage = 0;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        jvmcounter.getAssertionCounter().inc();
        try {
            block.invoke();
            throwable = null;
        }
        catch (Throwable e) {
            throwable = e;
        }
        if ((thrownException = throwable) == null) {
            throw (Throwable)((Object)FailuresKt.failure(StringsKt.trimMargin$default((String)("Expected a throwable with message " + StringShow.INSTANCE.show(message).getValue() + " but nothing was thrown"), null, (int)1, null)));
        }
        if (Intrinsics.areEqual((Object)thrownException.getMessage(), (Object)message) ^ true) {
            throw (Throwable)((Object)FailuresKt.failure(StringsKt.trimMargin$default((String)("Expected a throwable with message " + StringShow.INSTANCE.show(message).getValue() + " but got a throwable with message " + ShowKt.show(thrownException.getMessage()).getValue()), null, (int)1, null), thrownException));
        }
    }

    public static final <T> void shouldNotThrowMessage(@NotNull String message, @NotNull Function0<? extends T> block) {
        Throwable throwable;
        int $i$f$shouldNotThrowMessage = 0;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        jvmcounter.getAssertionCounter().inc();
        try {
            block.invoke();
            throwable = null;
        }
        catch (Throwable e) {
            throwable = e;
        }
        Throwable thrownException = throwable;
        if (thrownException != null && Intrinsics.areEqual((Object)thrownException.getMessage(), (Object)message)) {
            throw (Throwable)((Object)FailuresKt.failure(StringsKt.trimMargin$default((String)("Expected no exception with message: \"" + message + "\"\n                          |but a " + Reflection.getOrCreateKotlinClass(thrownException.getClass()).getSimpleName() + " was thrown with given message"), null, (int)1, null), thrownException));
        }
    }
}

