/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.eq;

import io.kotest.assertions.Actual;
import io.kotest.assertions.Expected;
import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.eq.Eq;
import io.kotest.assertions.eq.EqKt;
import io.kotest.assertions.show.ShowKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\"\u0010\n\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J \u0010\u000b\u001a\u00020\f2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lio/kotest/assertions/eq/IterableEq;", "Lio/kotest/assertions/eq/Eq;", "", "()V", "checkIterableEquality", "", "actual", "expected", "checkSetEquality", "", "equals", "equalsIgnoringOrder", "", "generateError", "", "kotest-assertions-shared"})
public final class IterableEq
implements Eq<Iterable<?>> {
    public static final IterableEq INSTANCE;

    @Override
    @Nullable
    public Throwable equals(@NotNull Iterable<?> actual, @NotNull Iterable<?> expected) {
        Intrinsics.checkParameterIsNotNull(actual, (String)"actual");
        Intrinsics.checkParameterIsNotNull(expected, (String)"expected");
        return actual instanceof Set && expected instanceof Set ? this.checkSetEquality((Set)actual, (Set)expected) : this.checkIterableEquality(actual, expected);
    }

    private final Throwable checkSetEquality(Set<?> actual, Set<?> expected) {
        return actual.size() != expected.size() || !this.equalsIgnoringOrder(actual, expected) ? this.generateError(actual, expected) : null;
    }

    private final boolean equalsIgnoringOrder(Set<?> actual, Set<?> expected) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = actual;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object elementInActualSet = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (CollectionsKt.contains((Iterable)expected, elementInActualSet)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final Throwable checkIterableEquality(Iterable<?> actual, Iterable<?> expected) {
        boolean bl;
        block4: {
            List actualAsList = CollectionsKt.toList(actual);
            List expectedAsList = CollectionsKt.toList(expected);
            if (actualAsList.size() != expectedAsList.size()) {
                return this.generateError(actual, expected);
            }
            Iterable $this$any$iv = CollectionsKt.zip((Iterable)actualAsList, (Iterable)expectedAsList);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!(EqKt.eq(it.getFirst(), it.getSecond()) != null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean anyUnequalElement = bl;
        return anyUnequalElement ? this.generateError(actual, expected) : null;
    }

    private final Throwable generateError(Object actual, Object expected) {
        return FailuresKt.failure$default(new Expected(ShowKt.show(expected)), new Actual(ShowKt.show(actual)), null, 4, null);
    }

    private IterableEq() {
    }

    static {
        IterableEq iterableEq;
        INSTANCE = iterableEq = new IterableEq();
    }
}

