/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.eq;

import io.kotest.assertions.Actual;
import io.kotest.assertions.Expected;
import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.eq.Eq;
import io.kotest.assertions.eq.EqKt;
import io.kotest.assertions.print.PrintKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0006J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\r\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u000f\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0010\u001a\u00020\f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lio/kotest/assertions/eq/IterableEq;", "Lio/kotest/assertions/eq/Eq;", "", "()V", "asIterable", "it", "", "checkEquality", "", "actual", "expected", "strictNumberEq", "", "checkSetEquality", "", "equals", "equalsIgnoringOrder", "generateError", "isValidIterable", "kotest-assertions-shared"})
public final class IterableEq
implements Eq<Iterable<?>> {
    @NotNull
    public static final IterableEq INSTANCE = new IterableEq();

    private IterableEq() {
    }

    public final boolean isValidIterable(@NotNull Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it;
        return ((object instanceof List ? true : object instanceof Set) ? true : object instanceof Object[]) ? true : object instanceof Collection;
    }

    @NotNull
    public final Iterable<?> asIterable(@NotNull Object it) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it;
        if (object instanceof Object[]) {
            iterable = ArraysKt.asList((Object[])((Object[])it));
        } else if (object instanceof List) {
            iterable = (Iterable)it;
        } else if (object instanceof Set) {
            iterable = (Iterable)it;
        } else if (object instanceof Collection) {
            iterable = (Iterable)it;
        } else {
            throw new IllegalStateException(("Cannot convert " + it + " to Iterable<*>").toString());
        }
        return iterable;
    }

    @Override
    @Nullable
    public Throwable equals(@NotNull Iterable<?> actual, @NotNull Iterable<?> expected, boolean strictNumberEq) {
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return actual instanceof Set && expected instanceof Set ? this.checkSetEquality((Set)actual, (Set)expected, strictNumberEq) : this.checkEquality(actual, expected, strictNumberEq);
    }

    private final Throwable checkSetEquality(Set<?> actual, Set<?> expected, boolean strictNumberEq) {
        return actual.size() != expected.size() || !this.equalsIgnoringOrder(actual, expected, strictNumberEq) ? this.generateError(actual, expected) : null;
    }

    private final boolean equalsIgnoringOrder(Set<?> actual, Set<?> expected, boolean strictNumberEq) {
        boolean bl;
        block14: {
            Iterable $this$all$iv = actual;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    boolean bl2;
                    block13: {
                        Object it;
                        Object element$iv;
                        Iterator iterator2;
                        boolean $i$f$any;
                        Iterable $this$any$iv;
                        Object element$iv2;
                        Object elementInActualSet = element$iv2 = iterator.next();
                        boolean bl3 = false;
                        Object t = elementInActualSet;
                        if (t instanceof Iterable) {
                            $this$any$iv = expected;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    it = element$iv = iterator2.next();
                                    boolean bl4 = false;
                                    if (!(EqKt.eq(elementInActualSet, it, strictNumberEq) == null)) continue;
                                    bl2 = true;
                                    break block13;
                                }
                                bl2 = false;
                            }
                        } else if (t instanceof Object[]) {
                            $this$any$iv = expected;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    it = element$iv = iterator2.next();
                                    boolean bl5 = false;
                                    if (!(EqKt.eq(elementInActualSet, it, strictNumberEq) == null)) continue;
                                    bl2 = true;
                                    break block13;
                                }
                                bl2 = false;
                            }
                        } else {
                            bl2 = CollectionsKt.contains((Iterable)expected, elementInActualSet);
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final Throwable checkEquality(Iterable<?> actual, Iterable<?> expected, boolean strictNumberEq) {
        StringBuilder stringBuilder;
        int index = 0;
        Iterator<?> iter1 = actual.iterator();
        Iterator<?> iter2 = expected.iterator();
        List elementDifferAtIndex = new ArrayList();
        Integer unexpectedElementAtIndex = null;
        Integer missingElementAt = null;
        while (iter1.hasNext()) {
            Object a = iter1.next();
            if (iter2.hasNext()) {
                Object b = iter2.next();
                Throwable t = EqKt.eq(a, b, strictNumberEq);
                if (t != null) {
                    elementDifferAtIndex.add(index);
                }
            } else {
                unexpectedElementAtIndex = index;
            }
            int n = index;
            index = n + 1;
        }
        if (iter2.hasNext()) {
            missingElementAt = index;
        }
        StringBuilder $this$checkEquality_u24lambda_u2d3 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!((Collection)elementDifferAtIndex).isEmpty()) {
            $this$checkEquality_u24lambda_u2d3.append("Element differ at index: " + PrintKt.print(elementDifferAtIndex).getValue() + '\n');
        }
        if (unexpectedElementAtIndex != null) {
            $this$checkEquality_u24lambda_u2d3.append("Unexpected elements from index " + unexpectedElementAtIndex + '\n');
        }
        if (missingElementAt != null) {
            $this$checkEquality_u24lambda_u2d3.append("Missing elements from index " + missingElementAt + '\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026     }\n      }.toString()");
        String detailErrorMessage = string;
        return !StringsKt.isBlank((CharSequence)detailErrorMessage) ? FailuresKt.failure(new Expected(PrintKt.print(expected)), new Actual(PrintKt.print(actual)), detailErrorMessage) : null;
    }

    private final Throwable generateError(Object actual, Object expected) {
        return FailuresKt.failure$default(new Expected(PrintKt.print(expected)), new Actual(PrintKt.print(actual)), null, 4, null);
    }

    @Override
    @Nullable
    public Throwable equals(@NotNull Iterable<?> actual, @NotNull Iterable<?> expected) {
        return Eq.DefaultImpls.equals(this, actual, expected);
    }
}

