/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.print;

import io.kotest.assertions.AssertionsConfig;
import io.kotest.assertions.ConfigValue;
import io.kotest.assertions.print.Print;
import io.kotest.assertions.print.PrintKt;
import io.kotest.assertions.print.Printed;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0017\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/kotest/assertions/print/ListPrint;", "T", "Lio/kotest/assertions/print/Print;", "", "limitConfigValue", "Lio/kotest/assertions/ConfigValue;", "", "<init>", "(Lio/kotest/assertions/ConfigValue;)V", "print", "Lio/kotest/assertions/print/Printed;", "a", "level", "kotest-assertions-shared"})
public final class ListPrint<T>
implements Print<List<? extends T>> {
    @NotNull
    private final ConfigValue<Integer> limitConfigValue;

    public ListPrint(@NotNull ConfigValue<Integer> limitConfigValue) {
        Intrinsics.checkNotNullParameter(limitConfigValue, (String)"limitConfigValue");
        this.limitConfigValue = limitConfigValue;
    }

    public /* synthetic */ ListPrint(ConfigValue configValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            configValue = AssertionsConfig.INSTANCE.getMaxCollectionPrintSize();
        }
        this(configValue);
    }

    @Override
    @NotNull
    public Printed print(@NotNull List<? extends T> a, int level) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (!a.isEmpty()) {
            int limit = ((Number)this.limitConfigValue.getValue()).intValue();
            int remainingItems = a.size() - limit;
            String limitHint = this.limitConfigValue.getSourceDescription() == null ? "" : " (set " + this.limitConfigValue.getSourceDescription() + " to see more / less items)";
            return PrintKt.printed(CollectionsKt.joinToString((Iterable)a, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)limit, (CharSequence)("...and " + remainingItems + " more" + limitHint), arg_0 -> ListPrint.print$lambda$0(a, level, arg_0)));
        }
        return new Printed("[]");
    }

    private static final CharSequence print$lambda$0(List $a, int $level, Object it) {
        return it instanceof Iterable && Intrinsics.areEqual((Object)CollectionsKt.toList((Iterable)((Iterable)it)), (Object)$a) && $a.size() == 1 ? (CharSequence)String.valueOf($a.get(0)) : (CharSequence)PrintKt.recursiveRepr($a, it, $level).getValue();
    }

    public ListPrint() {
        this(null, 1, null);
    }
}

