/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.submatching;

import io.kotest.submatching.MatchedCollectionElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006 "}, d2={"Lio/kotest/submatching/PartialCollectionMatch;", "", "matchedElement", "Lio/kotest/submatching/MatchedCollectionElement;", "length", "", "<init>", "(Lio/kotest/submatching/MatchedCollectionElement;I)V", "getMatchedElement", "()Lio/kotest/submatching/MatchedCollectionElement;", "getLength", "()I", "endOfMatchAtTarget", "getEndOfMatchAtTarget", "rangeOfExpected", "Lkotlin/ranges/IntRange;", "getRangeOfExpected", "()Lkotlin/ranges/IntRange;", "rangeOfValue", "getRangeOfValue", "indexIsInValue", "", "index", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "kotest-assertions-shared"})
public final class PartialCollectionMatch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MatchedCollectionElement matchedElement;
    private final int length;
    @NotNull
    private final IntRange rangeOfExpected;
    @NotNull
    private final IntRange rangeOfValue;

    public PartialCollectionMatch(@NotNull MatchedCollectionElement matchedElement, int length) {
        Intrinsics.checkNotNullParameter((Object)matchedElement, (String)"matchedElement");
        this.matchedElement = matchedElement;
        this.length = length;
        this.rangeOfExpected = Companion.rangeOfLength(this.matchedElement.getStartIndexInExpected(), this.length);
        this.rangeOfValue = Companion.rangeOfLength(this.matchedElement.getStartIndexInValue(), this.length);
    }

    @NotNull
    public final MatchedCollectionElement getMatchedElement() {
        return this.matchedElement;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getEndOfMatchAtTarget() {
        return this.matchedElement.getStartIndexInValue() + this.length - 1;
    }

    @NotNull
    public final IntRange getRangeOfExpected() {
        return this.rangeOfExpected;
    }

    @NotNull
    public final IntRange getRangeOfValue() {
        return this.rangeOfValue;
    }

    public final boolean indexIsInValue(int index) {
        IntRange intRange = this.rangeOfValue;
        int n = intRange.getFirst();
        return index <= intRange.getLast() ? n <= index : false;
    }

    @NotNull
    public final MatchedCollectionElement component1() {
        return this.matchedElement;
    }

    public final int component2() {
        return this.length;
    }

    @NotNull
    public final PartialCollectionMatch copy(@NotNull MatchedCollectionElement matchedElement, int length) {
        Intrinsics.checkNotNullParameter((Object)matchedElement, (String)"matchedElement");
        return new PartialCollectionMatch(matchedElement, length);
    }

    public static /* synthetic */ PartialCollectionMatch copy$default(PartialCollectionMatch partialCollectionMatch, MatchedCollectionElement matchedCollectionElement, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            matchedCollectionElement = partialCollectionMatch.matchedElement;
        }
        if ((n2 & 2) != 0) {
            n = partialCollectionMatch.length;
        }
        return partialCollectionMatch.copy(matchedCollectionElement, n);
    }

    @NotNull
    public String toString() {
        return "PartialCollectionMatch(matchedElement=" + this.matchedElement + ", length=" + this.length + ")";
    }

    public int hashCode() {
        int result2 = this.matchedElement.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.length);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PartialCollectionMatch)) {
            return false;
        }
        PartialCollectionMatch partialCollectionMatch = (PartialCollectionMatch)other;
        if (!Intrinsics.areEqual((Object)this.matchedElement, (Object)partialCollectionMatch.matchedElement)) {
            return false;
        }
        return this.length == partialCollectionMatch.length;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lio/kotest/submatching/PartialCollectionMatch$Companion;", "", "<init>", "()V", "rangeOfLength", "Lkotlin/ranges/IntRange;", "start", "", "length", "kotest-assertions-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange rangeOfLength(int start, int length) {
            return RangesKt.until((int)start, (int)(start + length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

