/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.core.engine.discovery;

import io.kotest.core.spec.Spec;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lio/kotest/core/engine/discovery/DiscoverySelector;", "", "()V", "test", "", "kclass", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "ClassDiscoverySelector", "PackageDiscoverySelector", "Lio/kotest/core/engine/discovery/DiscoverySelector$ClassDiscoverySelector;", "Lio/kotest/core/engine/discovery/DiscoverySelector$PackageDiscoverySelector;", "kotest-core"})
public abstract class DiscoverySelector {
    public abstract boolean test(@NotNull KClass<? extends Spec> var1);

    private DiscoverySelector() {
    }

    public /* synthetic */ DiscoverySelector(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0018\u0010\u000f\u001a\u00020\n2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lio/kotest/core/engine/discovery/DiscoverySelector$ClassDiscoverySelector;", "Lio/kotest/core/engine/discovery/DiscoverySelector;", "className", "", "(Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "test", "kclass", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "toString", "kotest-core"})
    public static final class ClassDiscoverySelector
    extends DiscoverySelector {
        @NotNull
        private final String className;

        @Override
        public boolean test(@NotNull KClass<? extends Spec> kclass) {
            Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
            String string = kclass.getQualifiedName();
            if (string == null) {
                string = JvmClassMappingKt.getJavaClass(kclass).getCanonicalName();
            }
            return Intrinsics.areEqual((Object)this.className, (Object)string);
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public ClassDiscoverySelector(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            super(null);
            this.className = className;
        }

        @NotNull
        public final String component1() {
            return this.className;
        }

        @NotNull
        public final ClassDiscoverySelector copy(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            return new ClassDiscoverySelector(className);
        }

        public static /* synthetic */ ClassDiscoverySelector copy$default(ClassDiscoverySelector classDiscoverySelector, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = classDiscoverySelector.className;
            }
            return classDiscoverySelector.copy(string);
        }

        @NotNull
        public String toString() {
            return "ClassDiscoverySelector(className=" + this.className + ")";
        }

        public int hashCode() {
            String string = this.className;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClassDiscoverySelector)) break block3;
                    ClassDiscoverySelector classDiscoverySelector = (ClassDiscoverySelector)object;
                    if (!Intrinsics.areEqual((Object)this.className, (Object)classDiscoverySelector.className)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0018\u0010\u000f\u001a\u00020\n2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lio/kotest/core/engine/discovery/DiscoverySelector$PackageDiscoverySelector;", "Lio/kotest/core/engine/discovery/DiscoverySelector;", "packageName", "", "(Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "test", "kclass", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "toString", "kotest-core"})
    public static final class PackageDiscoverySelector
    extends DiscoverySelector {
        @NotNull
        private final String packageName;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean test(@NotNull KClass<? extends Spec> kclass) {
            Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
            Package package_ = JvmClassMappingKt.getJavaClass(kclass).getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"kclass.java.`package`");
            if (Intrinsics.areEqual((Object)this.packageName, (Object)package_.getName())) return true;
            Package package_2 = JvmClassMappingKt.getJavaClass(kclass).getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_2, (String)"kclass.java.`package`");
            String string = package_2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kclass.java.`package`.name");
            if (!StringsKt.startsWith$default((String)string, (String)(this.packageName + '.'), (boolean)false, (int)2, null)) return false;
            return true;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        public PackageDiscoverySelector(@NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            super(null);
            this.packageName = packageName;
        }

        @NotNull
        public final String component1() {
            return this.packageName;
        }

        @NotNull
        public final PackageDiscoverySelector copy(@NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return new PackageDiscoverySelector(packageName);
        }

        public static /* synthetic */ PackageDiscoverySelector copy$default(PackageDiscoverySelector packageDiscoverySelector, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = packageDiscoverySelector.packageName;
            }
            return packageDiscoverySelector.copy(string);
        }

        @NotNull
        public String toString() {
            return "PackageDiscoverySelector(packageName=" + this.packageName + ")";
        }

        public int hashCode() {
            String string = this.packageName;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PackageDiscoverySelector)) break block3;
                    PackageDiscoverySelector packageDiscoverySelector = (PackageDiscoverySelector)object;
                    if (!Intrinsics.areEqual((Object)this.packageName, (Object)packageDiscoverySelector.packageName)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

