/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.extensions.junitxml;

import io.kotest.core.config.ExtensionRegistry;
import io.kotest.core.config.ProjectConfiguration;
import io.kotest.core.listeners.FinalizeSpecListener;
import io.kotest.core.listeners.PrepareSpecListener;
import io.kotest.core.names.DisplayNameFormatter;
import io.kotest.core.spec.Spec;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.core.test.TestType;
import io.kotest.engine.test.names.DefaultDisplayNameFormatterKt;
import io.kotest.engine.test.names.PathsKt;
import java.io.BufferedWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J5\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u0006\u001a\u00020\u001cH\u0002J!\u0010\u001d\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lio/kotest/extensions/junitxml/JunitXmlReporter;", "Lio/kotest/core/listeners/PrepareSpecListener;", "Lio/kotest/core/listeners/FinalizeSpecListener;", "includeContainers", "", "useTestPathAsName", "outputDir", "", "(ZZLjava/lang/String;)V", "formatter", "Lio/kotest/core/names/DisplayNameFormatter;", "marks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "", "filterResults", "", "Lio/kotest/core/test/TestCase;", "Lio/kotest/core/test/TestResult;", "results", "finalizeSpec", "", "kclass", "(Lkotlin/reflect/KClass;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentDateTime", "Ljava/time/LocalDateTime;", "hostname", "Ljava/nio/file/Path;", "prepareSpec", "(Lkotlin/reflect/KClass;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "write", "document", "Lorg/jdom2/Document;", "Companion", "kotest-extensions-junitxml"})
public final class JunitXmlReporter
implements PrepareSpecListener,
FinalizeSpecListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean includeContainers;
    private final boolean useTestPathAsName;
    @NotNull
    private final String outputDir;
    @NotNull
    private final DisplayNameFormatter formatter;
    @NotNull
    private ConcurrentHashMap<KClass<? extends Spec>, Long> marks;
    @NotNull
    public static final String DefaultBuildDir = "./build";
    @NotNull
    public static final String BuildDirKey = "gradle.build.dir";
    @NotNull
    public static final String AttributeName = "name";

    public JunitXmlReporter(boolean includeContainers, boolean useTestPathAsName, @NotNull String outputDir) {
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        this.includeContainers = includeContainers;
        this.useTestPathAsName = useTestPathAsName;
        this.outputDir = outputDir;
        this.formatter = DefaultDisplayNameFormatterKt.getDisplayNameFormatter((ExtensionRegistry)new ProjectConfiguration().getRegistry(), (ProjectConfiguration)new ProjectConfiguration());
        this.marks = new ConcurrentHashMap();
    }

    public /* synthetic */ JunitXmlReporter(boolean bl, boolean bl2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            string = "test-results/test";
        }
        this(bl, bl2, string);
    }

    private final Path outputDir() {
        Path path;
        String buildDir = System.getProperty(BuildDirKey);
        if (buildDir != null) {
            Path path2 = Paths.get(buildDir, new String[0]).resolve(this.outputDir);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(buildDir).resolve(outputDir)");
        } else {
            Path path3 = Paths.get(DefaultBuildDir, new String[0]).resolve(this.outputDir);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(DefaultBuildDir).resolve(outputDir)");
        }
        return path;
    }

    @Nullable
    public Object prepareSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Continuation<? super Unit> $completion) {
        ((Map)this.marks).put(kclass, Boxing.boxLong((long)System.currentTimeMillis()));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TestCase, TestResult> filterResults(Map<TestCase, ? extends TestResult> results) {
        Map map;
        boolean bl = this.includeContainers;
        if (bl) {
            map = results;
        } else if (!bl) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = results;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!(((TestCase)it.getKey()).getType() == TestType.Test)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            map = destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object finalizeSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Map<TestCase, ? extends TestResult> results, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Map.Entry<Object, Object> it;
        Map<TestCase, TestResult> $this$filterTo$iv$iv;
        Map<TestCase, TestResult> $this$filter$iv;
        Long l = this.marks.get(kclass);
        if (l == null) {
            l = Boxing.boxLong((long)System.currentTimeMillis());
        }
        long start = ((Number)l).longValue();
        long duration = System.currentTimeMillis() - start;
        Map<TestCase, TestResult> filtered = this.filterResults(results);
        Document document = new Document();
        Element testSuite = new Element("testsuite");
        testSuite.setAttribute("timestamp", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.getCurrentDateTime()));
        testSuite.setAttribute("time", String.valueOf(Duration.toDouble-impl((long)Duration.Companion.milliseconds-UwyO8pc(duration), (DurationUnit)DurationUnit.SECONDS)));
        testSuite.setAttribute("hostname", this.hostname());
        Map<TestCase, TestResult> map = filtered;
        String string = "errors";
        Object object = testSuite;
        boolean $i$f$filter = false;
        void var13_13 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!((TestResult)it.getValue()).isError()) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Map map2 = destination$iv$iv;
        object.setAttribute(string, String.valueOf(map2.size()));
        $this$filter$iv = filtered;
        string = "failures";
        object = testSuite;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry<Object, Object> entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!((TestResult)it.getValue()).isFailure()) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        map2 = destination$iv$iv;
        object.setAttribute(string, String.valueOf(map2.size()));
        $this$filter$iv = filtered;
        string = "skipped";
        object = testSuite;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry<Object, Object> entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!((TestResult)it.getValue()).isIgnored()) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        map2 = destination$iv$iv;
        object.setAttribute(string, String.valueOf(map2.size()));
        testSuite.setAttribute("tests", String.valueOf(filtered.size()));
        testSuite.setAttribute(AttributeName, this.formatter.format(kclass));
        document.addContent((Content)testSuite);
        Map<TestCase, TestResult> $this$map$iv = filtered;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Map.Entry<Object, Object>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            Map.Entry<Object, Object> entry;
            Map.Entry<Object, Object> entry2 = entry = iterator.next();
            object = destination$iv$iv;
            bl = false;
            TestCase testcase = (TestCase)entry2.getKey();
            TestResult result = (TestResult)entry2.getValue();
            boolean bl2 = this.useTestPathAsName;
            if (bl2) {
                string2 = PathsKt.formatTestPath((DisplayNameFormatter)this.formatter, (TestCase)testcase, (String)" -- ");
            } else if (!bl2) {
                string2 = this.formatter.format(testcase);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String name = string2;
            Element e = new Element("testcase");
            e.setAttribute(AttributeName, name);
            e.setAttribute("classname", JvmClassMappingKt.getJavaClass(kclass).getCanonicalName());
            e.setAttribute("time", String.valueOf(Duration.toDouble-impl((long)result.getDuration-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS)));
            TestResult testResult = result;
            if (testResult instanceof TestResult.Error) {
                Element err = new Element("error");
                if (result.getErrorOrNull() != null) {
                    Throwable it2;
                    boolean bl3 = false;
                    err.setAttribute("type", it2.getClass().getName());
                    err.setText(it2.getMessage());
                }
                e.addContent((Content)err);
            } else if (testResult instanceof TestResult.Failure) {
                Element failure = new Element("failure");
                if (result.getErrorOrNull() != null) {
                    Throwable it2;
                    boolean bl4 = false;
                    failure.setAttribute("type", it2.getClass().getName());
                    failure.setText(it2.getMessage());
                }
                e.addContent((Content)failure);
            }
            object.add(testSuite.addContent((Content)e));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.write(kclass, document);
        return Unit.INSTANCE;
    }

    private final void write(KClass<?> kclass, Document document) {
        Path path = this.outputDir().resolve("TEST-" + this.formatter.format(kclass) + ".xml");
        path.getParent().toFile().mkdirs();
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE};
        BufferedWriter writer = Files.newBufferedWriter(path, openOptionArray);
        outputter.output(document, (Writer)writer);
        writer.flush();
        writer.close();
    }

    private final String hostname() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            string = null;
        }
        return string;
    }

    private final LocalDateTime getCurrentDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now(Clock.systemDefaultZone()).withNano(0);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(Clock.systemDefaultZone()).withNano(0)");
        return localDateTime;
    }

    @NotNull
    public String getName() {
        return PrepareSpecListener.DefaultImpls.getName((PrepareSpecListener)this);
    }

    public JunitXmlReporter() {
        this(false, false, null, 7, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/kotest/extensions/junitxml/JunitXmlReporter$Companion;", "", "()V", "AttributeName", "", "BuildDirKey", "DefaultBuildDir", "kotest-extensions-junitxml"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

