/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.extensions.system;

import io.kotest.core.listeners.TestListener;
import io.kotest.core.spec.DescriptionsKt;
import io.kotest.core.spec.Spec;
import io.kotest.core.test.Description;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.extensions.system.NoExitSecurityManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lio/kotest/extensions/system/SpecSystemExitListener;", "Lio/kotest/core/listeners/TestListener;", "()V", "previousSecurityManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/kotest/core/test/Description;", "Ljava/lang/SecurityManager;", "afterSpec", "", "spec", "Lio/kotest/core/spec/Spec;", "(Lio/kotest/core/spec/Spec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "beforeSpec", "kotest-extensions"})
public final class SpecSystemExitListener
implements TestListener {
    private static final ConcurrentHashMap<Description, SecurityManager> previousSecurityManagers;
    public static final SpecSystemExitListener INSTANCE;

    @Nullable
    public Object beforeSpec(@NotNull Spec spec, @NotNull Continuation<? super Unit> $completion) {
        SecurityManager previous = System.getSecurityManager();
        if (previous != null) {
            ((Map)previousSecurityManagers).put(DescriptionsKt.description((KClass)Reflection.getOrCreateKotlinClass(spec.getClass())), previous);
        }
        System.setSecurityManager(new NoExitSecurityManager(previous));
        return Unit.INSTANCE;
    }

    @Nullable
    public Object afterSpec(@NotNull Spec spec, @NotNull Continuation<? super Unit> $completion) {
        if (previousSecurityManagers.contains(DescriptionsKt.description((KClass)Reflection.getOrCreateKotlinClass(spec.getClass())))) {
            System.setSecurityManager(previousSecurityManagers.get(DescriptionsKt.description((KClass)Reflection.getOrCreateKotlinClass(spec.getClass()))));
        } else {
            System.setSecurityManager(null);
        }
        return Unit.INSTANCE;
    }

    private SpecSystemExitListener() {
    }

    static {
        SpecSystemExitListener specSystemExitListener;
        INSTANCE = specSystemExitListener = new SpecSystemExitListener();
        previousSecurityManagers = new ConcurrentHashMap();
    }

    @NotNull
    public String getName() {
        return TestListener.DefaultImpls.getName((TestListener)this);
    }

    @Nullable
    public Object afterInvocation(@NotNull TestCase testCase, int iteration, @NotNull Continuation<? super Unit> continuation) {
        return TestListener.DefaultImpls.afterInvocation((TestListener)this, (TestCase)testCase, (int)iteration, continuation);
    }

    @Nullable
    public Object afterTest(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> continuation) {
        return TestListener.DefaultImpls.afterTest((TestListener)this, (TestCase)testCase, (TestResult)result, continuation);
    }

    @Nullable
    public Object beforeInvocation(@NotNull TestCase testCase, int iteration, @NotNull Continuation<? super Unit> continuation) {
        return TestListener.DefaultImpls.beforeInvocation((TestListener)this, (TestCase)testCase, (int)iteration, continuation);
    }

    @Nullable
    public Object beforeTest(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> continuation) {
        return TestListener.DefaultImpls.beforeTest((TestListener)this, (TestCase)testCase, continuation);
    }

    @Nullable
    public Object finalizeSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Map<TestCase, TestResult> results, @NotNull Continuation<? super Unit> continuation) {
        return TestListener.DefaultImpls.finalizeSpec((TestListener)this, kclass, results, continuation);
    }

    @Nullable
    public Object prepareSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Continuation<? super Unit> continuation) {
        return TestListener.DefaultImpls.prepareSpec((TestListener)this, kclass, continuation);
    }
}

