/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.dispatchers;

import io.kotest.core.config.ExperimentalKotest;
import io.kotest.core.internal.ConcurrencyKt;
import io.kotest.core.spec.Spec;
import io.kotest.core.test.TestCase;
import io.kotest.engine.dispatchers.CoroutineDispatcherFactory;
import io.kotest.engine.dispatchers.ExecutorCoroutineDispatcher;
import io.kotest.mpp.LoggerKt;
import io.kotest.mpp.NamedThreadFactory;
import io.kotest.mpp.ReflectionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/kotest/engine/dispatchers/ExecutorCoroutineDispatcherFactory;", "Lio/kotest/engine/dispatchers/CoroutineDispatcherFactory;", "parallelism", "", "dispatcherAffinity", "", "(IZ)V", "dispatchers", "", "Lio/kotest/engine/dispatchers/ExecutorCoroutineDispatcher;", "dispatchersForSpecs", "", "", "dispatcherFor", "Lkotlinx/coroutines/CoroutineDispatcher;", "testCase", "Lio/kotest/core/test/TestCase;", "spec", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "stop", "", "kotest-framework-engine"})
@ExperimentalKotest
public final class ExecutorCoroutineDispatcherFactory
implements CoroutineDispatcherFactory {
    private final List<ExecutorCoroutineDispatcher> dispatchers;
    private final Map<String, ExecutorCoroutineDispatcher> dispatchersForSpecs;
    private final int parallelism;
    private final boolean dispatcherAffinity;

    @Override
    @NotNull
    public CoroutineDispatcher dispatcherFor(@NotNull KClass<? extends Spec> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        int n = ReflectionKt.bestName(spec).hashCode();
        boolean bl = false;
        CoroutineDispatcher dispatcher = this.dispatchers.get(Math.abs(n) % this.parallelism).getCoroutineDispatcher();
        LoggerKt.log((String)("ExecutorCoroutineDispatcherFactory: Selected dispatcher " + dispatcher + " for " + Reflection.getOrCreateKotlinClass(spec.getClass())));
        return dispatcher;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CoroutineDispatcher dispatcherFor(@NotNull TestCase testCase) {
        CoroutineDispatcher coroutineDispatcher;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Integer n = ConcurrencyKt.resolvedThreads((Spec)testCase.getSpec());
        int resolvedThreadCount = n != null ? n : 0;
        LoggerKt.log((String)("ExecutorCoroutineDispatcherFactory: resolvedThreadCount for " + Reflection.getOrCreateKotlinClass(testCase.getSpec().getClass()) + " is " + resolvedThreadCount));
        if (resolvedThreadCount > 1) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, ExecutorCoroutineDispatcher> map2 = this.dispatchersForSpecs;
            String key$iv = ReflectionKt.bestName((KClass)Reflection.getOrCreateKotlinClass(testCase.getSpec().getClass()));
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                ExecutorService executor;
                boolean bl2 = false;
                ExecutorService executorService = executor = Executors.newFixedThreadPool(resolvedThreadCount, (ThreadFactory)new NamedThreadFactory("ExecutorCoroutineDispatcherFactory-%d", false, 2, null));
                Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executor");
                ExecutorCoroutineDispatcher answer$iv = new ExecutorCoroutineDispatcher(executorService, (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)executor));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return ((ExecutorCoroutineDispatcher)object).getCoroutineDispatcher();
        }
        Boolean bl3 = testCase.getSpec().getDispatcherAffinity();
        if (bl3 == null) {
            bl3 = testCase.getSpec().dispatcherAffinity();
        }
        boolean bl4 = bl = bl3 != null ? bl3 : this.dispatcherAffinity;
        if (bl) {
            coroutineDispatcher = this.dispatcherFor((KClass<? extends Spec>)Reflection.getOrCreateKotlinClass(testCase.getSpec().getClass()));
        } else {
            Collection collection = this.dispatchers;
            boolean bl5 = false;
            coroutineDispatcher = ((ExecutorCoroutineDispatcher)CollectionsKt.random((Collection)collection, (Random)((Random)Random.Default))).getCoroutineDispatcher();
        }
        return coroutineDispatcher;
    }

    @Override
    public void stop() {
        ExecutorCoroutineDispatcher it;
        Iterable $this$forEach$iv = this.dispatchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ExecutorCoroutineDispatcher)element$iv;
            boolean bl = false;
            it.getExecutor().shutdown();
        }
        $this$forEach$iv = this.dispatchersForSpecs.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ExecutorCoroutineDispatcher)element$iv;
            boolean bl = false;
            it.getExecutor().shutdown();
        }
        try {
            $this$forEach$iv = this.dispatchers;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ExecutorCoroutineDispatcher)element$iv;
                boolean bl = false;
                it.getExecutor().awaitTermination(1L, TimeUnit.MINUTES);
            }
            $this$forEach$iv = this.dispatchersForSpecs.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ExecutorCoroutineDispatcher)element$iv;
                boolean bl = false;
                it.getExecutor().awaitTermination(1L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException e) {
            LoggerKt.log((String)"ExecutorCoroutineDispatcherFactory: Interrupted while waiting for dispatcher to terminate", (Throwable)e);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorCoroutineDispatcherFactory(int parallelism, boolean dispatcherAffinity) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Collection<Object> collection;
        this.parallelism = parallelism;
        this.dispatcherAffinity = dispatcherAffinity;
        int n = this.parallelism;
        ExecutorCoroutineDispatcherFactory executorCoroutineDispatcherFactory = this;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<ExecutorService> arrayList = new ArrayList<ExecutorService>(n);
        boolean bl3 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int n4 = n2++;
            boolean bl4 = false;
            int n5 = n4;
            collection = arrayList;
            boolean bl5 = false;
            object = Executors.newSingleThreadExecutor();
            ((ArrayList)collection).add(object);
        }
        collection = arrayList;
        Iterable iterable = collection;
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExecutorService executorService = (ExecutorService)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            void v0 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
            object = new ExecutorCoroutineDispatcher((ExecutorService)v0, (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)it));
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        executorCoroutineDispatcherFactory.dispatchers = collection;
        boolean bl7 = false;
        this.dispatchersForSpecs = new LinkedHashMap();
    }

    @Override
    @ExperimentalKotest
    public void complete(@NotNull KClass<? extends Spec> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        CoroutineDispatcherFactory.DefaultImpls.complete((CoroutineDispatcherFactory)this, spec);
    }

    @Override
    @ExperimentalKotest
    public void complete(@NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        CoroutineDispatcherFactory.DefaultImpls.complete((CoroutineDispatcherFactory)this, testCase);
    }
}

