/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.config;

import io.kotest.core.config.AbstractProjectConfig;
import io.kotest.core.config.Configuration;
import io.kotest.engine.config.ApplyConfigFromAbstractProjectConfigKt;
import io.kotest.engine.config.ApplyConfigFromAutoScanKt;
import io.kotest.engine.config.ApplyConfigFromSystemPropertiesKt;
import io.kotest.engine.config.ApplyPlatformDefaultsKt;
import io.kotest.mpp.LoggerKt;
import io.kotest.mpp.TimeInMillisKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kotest/engine/config/ConfigManager;", "", "()V", "initialized", "", "initialize", "Lio/kotest/core/config/Configuration;", "configuration", "projectConfigs", "", "Lio/kotest/core/config/AbstractProjectConfig;", "kotest-framework-engine"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    private static boolean initialized;

    private ConfigManager() {
    }

    @NotNull
    public final Configuration initialize(@NotNull Configuration configuration, @NotNull List<? extends AbstractProjectConfig> projectConfigs) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(projectConfigs, (String)"projectConfigs");
        if (!initialized) {
            boolean $i$f$log = false;
            if (LoggerKt.isLoggingEnabled()) {
                StringBuilder stringBuilder = new StringBuilder().append(TimeInMillisKt.timeInMillis()).append(' ');
                boolean bl = false;
                String string = Intrinsics.stringPlus((String)"ConfigManager: initialize config projectConfigs=", projectConfigs);
                String string2 = stringBuilder.append(string).toString();
                bl = false;
                System.out.println((Object)string2);
            }
            ApplyPlatformDefaultsKt.applyPlatformDefaults(configuration);
            ApplyConfigFromSystemPropertiesKt.applyConfigFromSystemProperties(configuration);
            ApplyConfigFromAutoScanKt.applyConfigFromAutoScan(configuration);
            Iterable $this$forEach$iv = projectConfigs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractProjectConfig it = (AbstractProjectConfig)element$iv;
                boolean bl = false;
                ApplyConfigFromAbstractProjectConfigKt.applyConfigFromProjectConfig(it, configuration);
            }
            initialized = true;
        }
        return configuration;
    }
}

