/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.reporter;

import com.github.ajalt.mordant.TermColors;
import io.kotest.core.spec.DescriptionKt;
import io.kotest.core.test.Description;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.core.test.TestStatus;
import io.kotest.core.test.TestType;
import io.kotest.engine.reporter.ConsoleReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0006H\u0016J\u001a\u0010#\u001a\u00020 2\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\u0006H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020 H\u0002J\b\u0010+\u001a\u00020 H\u0002J\u001a\u0010,\u001a\u00020 2\b\u0010-\u001a\u0004\u0018\u00010\"2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u00100\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u00101\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J2\u00102\u001a\u00020 2\n\u00103\u001a\u0006\u0012\u0002\b\u00030%2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001305H\u0016J\u0014\u00106\u001a\u00020 2\n\u00103\u001a\u0006\u0012\u0002\b\u00030%H\u0016J\u0018\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u0013H\u0016J\u0010\u0010:\u001a\u00020 2\u0006\u00108\u001a\u00020\u0012H\u0016J\u0010\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020\u0012H\u0016J\u0010\u0010<\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lio/kotest/engine/reporter/TaycanConsoleReporter;", "Lio/kotest/engine/reporter/ConsoleReporter;", "()V", "errors", "", "intros", "", "", "slow", "specsFailed", "Lio/kotest/core/test/Description;", "specsSeen", "start", "", "term", "Lcom/github/ajalt/mordant/TermColors;", "testsFailed", "Lkotlin/Pair;", "Lio/kotest/core/test/TestCase;", "Lio/kotest/core/test/TestResult;", "testsIgnored", "testsPassed", "verySlow", "bold", "str", "brightRed", "brightRedBold", "brightYellow", "brightYellowBold", "durationString", "durationMs", "engineFinished", "", "t", "", "engineStarted", "classes", "Lkotlin/reflect/KClass;", "green", "greenBold", "hasErrors", "", "printSpecCounts", "printTestsCounts", "printThrowable", "error", "padding", "red", "redBold", "setTerm", "specFinished", "kclass", "results", "", "specStarted", "testFinished", "testCase", "result", "testIgnored", "testStarted", "yellow", "yellowBold", "kotest-framework-engine"})
public final class TaycanConsoleReporter
implements ConsoleReporter {
    @NotNull
    private TermColors term = new TermColors(null, 1, null);
    private int errors;
    private long start = System.currentTimeMillis();
    @NotNull
    private List<Pair<TestCase, TestResult>> testsFailed = CollectionsKt.emptyList();
    private int testsIgnored;
    private int testsPassed;
    @NotNull
    private List<? extends Description> specsFailed = CollectionsKt.emptyList();
    @NotNull
    private List<? extends Description> specsSeen = CollectionsKt.emptyList();
    private int slow = 500;
    private int verySlow = 5000;
    @NotNull
    private final List<String> intros;

    public TaycanConsoleReporter() {
        Object[] objectArray = new String[]{"Feeding the kotest engine with freshly harvested tests", "Engaging kotest engine at warp factor 9", "Harvesting the test fields", "Preparing to sacrifice your code to the demi-god of test", "Hamsters are turning the wheels of kotest", "Battle commanders are ready to declare war on bugs", "Be afraid - be very afraid - of failing tests", "The point is, ladies and gentlemen, that green is good", "Lock test-foils in attack position", "Fasten your seatbelts. It's going to be a bumpy test-run", "Lets crack open this test suite", "Lets get testing, I'm on the clock here", "Test time is the best time", "Open the test suite doors, HAL", "Mama always said testing was like a box of chocolates. You don't know which ones are gonna fail", "A test suite. Shaken, not stirred", "I'm going to make him a test he can't refuse", "You testing me? I don't see any other tests here, so you must be testing me", "I love the smell of tests in the morning", "Do you feel lucky punk? Do you think your tests will pass? Well, do ya?", "Mirab, with tests unfurled", "Dolly works 9 to 5. I test 24/7", "A test suite's gotta do what a test suite's gotta do", "I test code and chew bubblegum, and I'm all out of bubblegum"};
        this.intros = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void setTerm(@NotNull TermColors term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.term = term;
    }

    private final String green(String str) {
        return this.term.getGreen().invoke(str);
    }

    private final String greenBold(String str) {
        return this.term.getGreen().plus(this.term.getBold()).invoke(str);
    }

    private final String red(String str) {
        return this.term.getRed().invoke(str);
    }

    private final String brightRed(String str) {
        return this.term.getBrightRed().invoke(str);
    }

    private final String brightRedBold(String str) {
        return this.term.getBrightRed().plus(this.term.getBold()).invoke(str);
    }

    private final String redBold(String str) {
        return this.term.getRed().plus(this.term.getBold()).invoke(str);
    }

    private final String yellow(String str) {
        return this.term.getYellow().invoke(str);
    }

    private final String brightYellow(String str) {
        return this.term.getBrightYellow().invoke(str);
    }

    private final String brightYellowBold(String str) {
        return this.term.getBrightYellow().plus(this.term.getBold()).invoke(str);
    }

    private final String yellowBold(String str) {
        return this.term.getYellow().plus(this.term.getBold()).invoke(str);
    }

    private final String bold(String str) {
        return this.term.getBold().invoke(str);
    }

    @Override
    public void engineStarted(@NotNull List<? extends KClass<?>> classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        String string = this.bold(">> Kotest");
        boolean bl = false;
        System.out.println((Object)string);
        string = Intrinsics.stringPlus((String)"- ", (Object)CollectionsKt.first((List)CollectionsKt.shuffled((Iterable)this.intros)));
        bl = false;
        System.out.println((Object)string);
        string = "- Test plan has ";
        bl = false;
        System.out.print((Object)string);
        string = this.greenBold(String.valueOf(classes.size()));
        bl = false;
        System.out.print((Object)string);
        string = " specs";
        bl = false;
        System.out.println((Object)string);
        boolean bl2 = false;
        System.out.println();
    }

    @Override
    public boolean hasErrors() {
        return this.errors > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void engineFinished(@NotNull List<? extends Throwable> t) {
        boolean bl;
        Object it22;
        Intrinsics.checkNotNullParameter(t, (String)"t");
        if (this.specsSeen.isEmpty()) {
            return;
        }
        Object object = t;
        boolean bl2 = false;
        if (!object.isEmpty()) {
            object = this;
            ((TaycanConsoleReporter)object).errors += t.size();
            Iterable $this$forEach$iv = t;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it22 = (Throwable)element$iv;
                bl = false;
                this.printThrowable((Throwable)it22, 0);
            }
        }
        long duration = System.currentTimeMillis() - this.start;
        long seconds = duration / (long)1000;
        if (this.errors == 0) {
            it22 = this.bold(">> All tests passed");
            bl = false;
            System.out.println(it22);
        } else {
            it22 = this.redBold(">> There were test failures");
            bl = false;
            System.out.println(it22);
            boolean it22 = false;
            System.out.println();
            Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)this.specsFailed);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv;
                Description spec = (Description)element$iv;
                boolean bl3 = false;
                String string = this.brightRedBold(Intrinsics.stringPlus((String)" ", (Object)spec.displayName()));
                boolean bl4 = false;
                System.out.println((Object)string);
                Iterable $this$filter$iv = this.testsFailed;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Pair it = (Pair)element$iv$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)((TestCase)it.getFirst()).getDescription().spec(), (Object)spec)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pair $dstr$testCase$_u24__u24 = (Pair)element$iv2;
                    boolean bl6 = false;
                    TestCase testCase = (TestCase)$dstr$testCase$_u24__u24.component1();
                    String string2 = this.brightRed(Intrinsics.stringPlus((String)" - ", (Object)testCase.getDescription().testDisplayPath().getValue()));
                    boolean bl7 = false;
                    System.out.println((Object)string2);
                }
            }
        }
        boolean bl8 = false;
        System.out.println();
        this.printSpecCounts();
        this.printTestsCounts();
        String string = "Time:    ";
        boolean bl9 = false;
        System.out.print((Object)string);
        string = this.bold("" + seconds + 's');
        bl9 = false;
        System.out.println((Object)string);
    }

    private final void printThrowable(Throwable error, int padding) {
        if (error != null) {
            Object object;
            String message = error.getMessage();
            if (message != null) {
                object = this.brightRed(StringsKt.padStart((String)message, (int)padding, (char)' '));
                boolean bl = false;
                System.out.println(object);
            }
            if ((object = error.getStackTrace()) != null) {
                StackTraceElement[] $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                StackTraceElement[] stackTraceElementArray = $this$forEach$iv;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement element$iv;
                    StackTraceElement it = element$iv = stackTraceElementArray[i];
                    boolean bl = false;
                    String string = this.red(Intrinsics.stringPlus((String)StringsKt.padStart((String)"", (int)(padding + 2), (char)' '), (Object)it));
                    boolean bl2 = false;
                    System.out.println((Object)string);
                }
            }
        }
    }

    private final void printSpecCounts() {
        int specsSeenSize = CollectionsKt.distinct((Iterable)this.specsSeen).size();
        int specsPassedSize = CollectionsKt.minus((Iterable)CollectionsKt.distinct((Iterable)this.specsSeen), (Iterable)this.specsFailed).size();
        int specsFailedSize = CollectionsKt.distinct((Iterable)this.specsFailed).size();
        String string = "Specs:   ";
        boolean bl = false;
        System.out.print((Object)string);
        string = this.greenBold(specsPassedSize + " passed");
        bl = false;
        System.out.print((Object)string);
        string = ", ";
        bl = false;
        System.out.print((Object)string);
        if (this.specsFailed.isEmpty()) {
            string = this.bold(specsFailedSize + " failed");
            bl = false;
            System.out.print((Object)string);
            string = this.bold(", ");
            bl = false;
            System.out.print((Object)string);
        } else {
            string = this.redBold(specsFailedSize + " failed");
            bl = false;
            System.out.print((Object)string);
            string = this.bold(", ");
            bl = false;
            System.out.print((Object)string);
        }
        string = specsSeenSize + " total";
        bl = false;
        System.out.println((Object)string);
    }

    private final void printTestsCounts() {
        String string = "Tests:   ";
        boolean bl = false;
        System.out.print((Object)string);
        string = this.greenBold(this.testsPassed + " passed");
        bl = false;
        System.out.print((Object)string);
        string = ", ";
        bl = false;
        System.out.print((Object)string);
        if (this.testsFailed.isEmpty()) {
            string = this.bold(this.testsFailed.size() + " failed");
            bl = false;
            System.out.print((Object)string);
            string = ", ";
            bl = false;
            System.out.print((Object)string);
        } else {
            string = this.redBold(this.testsFailed.size() + " failed");
            bl = false;
            System.out.print((Object)string);
            string = ", ";
            bl = false;
            System.out.print((Object)string);
        }
        if (this.testsIgnored > 0) {
            string = this.yellowBold(this.testsIgnored + " ignored");
            bl = false;
            System.out.print((Object)string);
            string = ", ";
            bl = false;
            System.out.print((Object)string);
        } else {
            string = this.bold(this.testsIgnored + " ignored");
            bl = false;
            System.out.print((Object)string);
            string = ", ";
            bl = false;
            System.out.print((Object)string);
        }
        string = this.testsPassed + this.testsFailed.size() + this.testsIgnored + " total";
        bl = false;
        System.out.println((Object)string);
    }

    @Override
    public void specStarted(@NotNull KClass<?> kclass) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        this.specsSeen = CollectionsKt.plus((Collection)this.specsSeen, (Object)DescriptionKt.toDescription(kclass));
        int specCount = this.specsSeen.size();
        String string = this.bold(StringsKt.padEnd((String)(specCount + ". "), (int)4, (char)' '));
        boolean bl = false;
        System.out.print((Object)string);
        string = this.bold(DescriptionKt.toDescription(kclass).displayName());
        bl = false;
        System.out.println((Object)string);
    }

    @Override
    public void specFinished(@NotNull KClass<?> kclass, @Nullable Throwable t, @NotNull Map<TestCase, TestResult> results) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        if (t != null) {
            TaycanConsoleReporter taycanConsoleReporter = this;
            int n = taycanConsoleReporter.errors;
            taycanConsoleReporter.errors = n + 1;
            this.specsFailed = CollectionsKt.plus((Collection)this.specsFailed, (Object)DescriptionKt.toDescription(kclass));
            this.printThrowable(t, 4);
        }
        boolean bl = false;
        System.out.println();
    }

    @Override
    public void testIgnored(@NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Object object = this;
        int n = ((TaycanConsoleReporter)object).testsIgnored;
        ((TaycanConsoleReporter)object).testsIgnored = n + 1;
        object = StringsKt.padEnd((String)"", (int)(testCase.getDescription().depth() * 4), (char)' ');
        n = 0;
        System.out.print(object);
        object = Intrinsics.stringPlus((String)"- ", (Object)testCase.getDisplayName());
        n = 0;
        System.out.print(object);
        object = this.brightYellowBold(" IGNORED");
        n = 0;
        System.out.println(object);
    }

    private final String durationString(long durationMs) {
        int n = this.slow;
        return (durationMs <= (long)this.verySlow ? (long)n <= durationMs : false) ? this.term.getBrightYellow().invoke("" + '(' + durationMs + "ms)") : (durationMs > (long)this.verySlow ? this.term.getBrightRed().invoke("" + '(' + durationMs + "ms)") : "");
    }

    @Override
    public void testFinished(@NotNull TestCase testCase, @NotNull TestResult result2) {
        int n;
        Object object;
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Object object2 = result2.getStatus();
        int n2 = WhenMappings.$EnumSwitchMapping$0[object2.ordinal()];
        switch (n2) {
            case 1: {
                if (testCase.getType() != TestType.Test) break;
                object = this;
                n = ((TaycanConsoleReporter)object).testsPassed;
                ((TaycanConsoleReporter)object).testsPassed = n + 1;
                break;
            }
            case 2: 
            case 3: {
                object = this;
                n = ((TaycanConsoleReporter)object).errors;
                ((TaycanConsoleReporter)object).errors = n + 1;
                this.testsFailed = CollectionsKt.plus((Collection)this.testsFailed, (Object)new Pair((Object)testCase, (Object)result2));
                this.specsFailed = CollectionsKt.plus((Collection)this.specsFailed, (Object)testCase.getDescription().spec());
                break;
            }
        }
        if (testCase.getType() == TestType.Test) {
            object2 = StringsKt.padEnd((String)"", (int)(testCase.getDescription().depth() * 4), (char)' ');
            n2 = 0;
            System.out.print(object2);
            object2 = Intrinsics.stringPlus((String)"- ", (Object)testCase.getDisplayName());
            n2 = 0;
            System.out.print(object2);
            object2 = result2.getStatus();
            n2 = WhenMappings.$EnumSwitchMapping$0[object2.ordinal()];
            switch (n2) {
                case 1: {
                    object = this.greenBold(" OK");
                    n = 0;
                    System.out.print(object);
                    break;
                }
                case 3: {
                    object = this.brightRed(" ERROR");
                    n = 0;
                    System.out.print(object);
                    break;
                }
                case 2: {
                    object = this.brightRed(" FAILED");
                    n = 0;
                    System.out.print(object);
                    break;
                }
                case 4: {
                    object = this.brightYellow(" IGNORED");
                    n = 0;
                    System.out.print(object);
                }
            }
            if (result2.getDuration() > (long)this.slow) {
                object2 = Intrinsics.stringPlus((String)" ", (Object)this.durationString(result2.getDuration()));
                n2 = 0;
                System.out.print(object2);
            }
            boolean bl = false;
            System.out.println();
        }
        if (result2.getError() != null) {
            boolean bl = false;
            System.out.println();
            this.printThrowable(result2.getError(), testCase.getDescription().depth() * 4);
            bl = false;
            System.out.println();
        }
    }

    @Override
    public void testStarted(@NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        if (testCase.getType() == TestType.Container) {
            String string = StringsKt.padEnd((String)"", (int)(testCase.getDescription().depth() * 4), (char)' ');
            boolean bl = false;
            System.out.print((Object)string);
            string = Intrinsics.stringPlus((String)"+ ", (Object)testCase.getDisplayName());
            bl = false;
            System.out.println((Object)string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestStatus.values().length];
            nArray[TestStatus.Success.ordinal()] = 1;
            nArray[TestStatus.Failure.ordinal()] = 2;
            nArray[TestStatus.Error.ordinal()] = 3;
            nArray[TestStatus.Ignored.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

