/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.reporter;

import io.kotest.core.spec.DescriptionKt;
import io.kotest.core.test.Description;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.core.test.TestStatus;
import io.kotest.core.test.TestType;
import io.kotest.engine.reporter.Reporter;
import io.kotest.engine.teamcity.Locations;
import io.kotest.engine.teamcity.TeamCityMessageBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001a\u0010\u0010\u001a\u00020\f2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u001a\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0002J2\u0010\u001a\u001a\u00020\f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0014\u0010\u001f\u001a\u00020\f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0014\u0010 \u001a\u00020\f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\u0007\u001aR\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u0006 \n*(\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/kotest/engine/reporter/TeamCityConsoleReporter;", "Lio/kotest/engine/reporter/Reporter;", "prefix", "", "(Ljava/lang/String;)V", "errors", "", "started", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lkotlin/reflect/KClass;", "kotlin.jvm.PlatformType", "engineFinished", "", "t", "", "", "engineStarted", "classes", "hasErrors", "insertDummyFailure", "desc", "Lio/kotest/core/test/Description;", "locationHint", "testCase", "Lio/kotest/core/test/TestCase;", "printStackTrace", "specFinished", "kclass", "results", "", "Lio/kotest/core/test/TestResult;", "specStarted", "start", "testFinished", "result", "testStarted", "kotest-framework-engine"})
public final class TeamCityConsoleReporter
implements Reporter {
    @NotNull
    private final String prefix;
    private boolean errors;
    private final ConcurrentHashMap.KeySetView<KClass<?>, Boolean> started;

    public TeamCityConsoleReporter(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        this.started = ConcurrentHashMap.newKeySet();
    }

    public /* synthetic */ TeamCityConsoleReporter(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "##teamcity";
        }
        this(string);
    }

    private final String locationHint(TestCase testCase) {
        String string = testCase.getSpec().getClass().getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testCase.spec.javaClass.canonicalName");
        return Locations.INSTANCE.locationHint(string, testCase.getSource().getLineNumber());
    }

    private final void insertDummyFailure(Description desc, Throwable t) {
        String string;
        Object object;
        String initName = Intrinsics.stringPlus((String)desc.getName().getDisplayName(), (Object)" <init>");
        String string2 = TeamCityMessageBuilder.Companion.testStarted(this.prefix, initName).build();
        boolean bl = false;
        System.out.println((Object)string2);
        if (t != null) {
            this.printStackTrace(t);
        }
        if ((object = t) == null) {
            string = "Spec failed";
        } else {
            String string3 = ((Throwable)object).getMessage();
            if (string3 == null) {
                string = "Spec failed";
            } else {
                String string4 = string3;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string4;
                boolean bl4 = false;
                String string5 = StringsKt.lines((CharSequence)it).size() == 1 ? it : null;
                string = string5 == null ? "Spec failed" : string5;
            }
        }
        String message = string;
        object = TeamCityMessageBuilder.Companion.testFailed(this.prefix, initName).message(message).build();
        boolean bl5 = false;
        System.out.println(object);
    }

    private final void printStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        System.err.println();
        System.err.println(writer.toString());
        System.err.flush();
    }

    @Override
    public boolean hasErrors() {
        return this.errors;
    }

    @Override
    public void specStarted(@NotNull KClass<?> kclass) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        this.start(kclass);
    }

    private final void start(KClass<?> kclass) {
        boolean bl = false;
        System.out.println();
        String string = TeamCityMessageBuilder.Companion.testSuiteStarted(this.prefix, DescriptionKt.toDescription(kclass).getName().getDisplayName()).locationHint(Locations.INSTANCE.locationHint(kclass)).id(DescriptionKt.toDescription(kclass).getId().getValue()).spec().build();
        boolean bl2 = false;
        System.out.println((Object)string);
        this.started.add(kclass);
    }

    @Override
    public void specFinished(@NotNull KClass<?> kclass, @Nullable Throwable t, @NotNull Map<TestCase, TestResult> results) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        if (!this.started.contains(kclass)) {
            this.start(kclass);
        }
        boolean bl = false;
        System.out.println();
        Description.Spec desc = DescriptionKt.toDescription(kclass);
        if (t == null) {
            String string = TeamCityMessageBuilder.Companion.testSuiteFinished(this.prefix, desc.getName().getDisplayName()).id(desc.getId().getValue()).spec().resultStatus(TestStatus.Success.name()).build();
            boolean bl2 = false;
            System.out.println((Object)string);
        } else {
            this.errors = true;
            this.insertDummyFailure((Description)desc, t);
            String string = TeamCityMessageBuilder.Companion.testSuiteFinished(this.prefix, desc.getName().getDisplayName()).id(desc.getId().getValue()).spec().resultStatus(TestStatus.Failure.name()).build();
            boolean bl3 = false;
            System.out.println((Object)string);
        }
    }

    @Override
    public void testStarted(@NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        if (testCase.getType() == TestType.Container) {
            boolean bl = false;
            System.out.println();
            String string = TeamCityMessageBuilder.Companion.testSuiteStarted(this.prefix, testCase.getDescription().getName().getDisplayName()).id(testCase.getDescription().getId().getValue()).parent(testCase.getDescription().getParent().getId().getValue()).locationHint(this.locationHint(testCase)).testType(testCase.getType().name()).build();
            boolean bl2 = false;
            System.out.println((Object)string);
        } else {
            boolean bl = false;
            System.out.println();
            String string = TeamCityMessageBuilder.Companion.testStarted(this.prefix, testCase.getDescription().getName().getDisplayName()).id(testCase.getDescription().getId().getValue()).parent(testCase.getDescription().getParent().getId().getValue()).locationHint(this.locationHint(testCase)).testType(testCase.getType().name()).build();
            boolean bl3 = false;
            System.out.println((Object)string);
        }
    }

    @Override
    public void engineStarted(@NotNull List<? extends KClass<?>> classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
    }

    @Override
    public void engineFinished(@NotNull List<? extends Throwable> t) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        Collection collection = t;
        boolean bl = false;
        if (!collection.isEmpty()) {
            boolean bl2 = false;
            System.out.println();
            String string = TeamCityMessageBuilder.Companion.testStarted(this.prefix, "Test failure").build();
            bl = false;
            System.out.println((Object)string);
            boolean bl3 = false;
            System.out.println();
            String errors2 = CollectionsKt.joinToString$default((Iterable)t, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Throwable, CharSequence>(t){
                final /* synthetic */ List<Throwable> $t;
                {
                    this.$t = $t;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$t.toString();
                }
            }), (int)30, null);
            String string2 = TeamCityMessageBuilder.Companion.testFailed(this.prefix, "Test failure").message(errors2).build();
            boolean bl4 = false;
            System.out.println((Object)string2);
        }
    }

    @Override
    public void testFinished(@NotNull TestCase testCase, @NotNull TestResult result2) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Description.Test desc = testCase.getDescription();
        boolean bl = false;
        System.out.println();
        TestStatus testStatus = result2.getStatus();
        int n = WhenMappings.$EnumSwitchMapping$0[testStatus.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                this.errors = true;
                TestType testType = testCase.getType();
                int n2 = WhenMappings.$EnumSwitchMapping$1[testType.ordinal()];
                switch (n2) {
                    case 1: {
                        this.insertDummyFailure((Description)desc, result2.getError());
                        String string = TeamCityMessageBuilder.Companion.testSuiteFinished(this.prefix, desc.getName().getDisplayName()).id(desc.getId().getValue()).parent(testCase.getDescription().getParent().getId().getValue()).duration(result2.getDuration()).testType(testCase.getType().name()).resultStatus(result2.getStatus().name()).build();
                        boolean bl2 = false;
                        System.out.println((Object)string);
                        break;
                    }
                    case 2: {
                        String string = TeamCityMessageBuilder.Companion.testFailed(this.prefix, desc.getName().getDisplayName()).withException(result2.getError()).id(desc.getId().getValue()).parent(testCase.getDescription().getParent().getId().getValue()).duration(result2.getDuration()).testType(testCase.getType().name()).resultStatus(result2.getStatus().name()).build();
                        boolean bl3 = false;
                        System.out.println((Object)string);
                    }
                }
                break;
            }
            case 3: {
                String string;
                TestType testType = testCase.getType();
                int n3 = WhenMappings.$EnumSwitchMapping$1[testType.ordinal()];
                switch (n3) {
                    case 1: {
                        string = TeamCityMessageBuilder.Companion.testSuiteFinished(this.prefix, desc.getName().getDisplayName()).id(desc.getId().getValue()).parent(testCase.getDescription().getParent().getId().getValue()).testType(testCase.getType().name()).resultStatus(result2.getStatus().name()).build();
                        break;
                    }
                    case 2: {
                        String string2 = result2.getReason();
                        string = TeamCityMessageBuilder.Companion.testIgnored(this.prefix, desc.getName().getDisplayName()).id(desc.getId().getValue()).parent(testCase.getDescription().getParent().getId().getValue()).message(string2 == null ? "No reason" : string2).testType(testCase.getType().name()).resultStatus(result2.getStatus().name()).build();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String msg = string;
                boolean bl4 = false;
                System.out.println((Object)msg);
                break;
            }
            case 4: {
                String string;
                TestType testType = testCase.getType();
                int n4 = WhenMappings.$EnumSwitchMapping$1[testType.ordinal()];
                switch (n4) {
                    case 1: {
                        string = TeamCityMessageBuilder.Companion.testSuiteFinished(this.prefix, desc.getName().getDisplayName()).id(desc.getId().getValue()).parent(testCase.getDescription().getParent().getId().getValue()).duration(result2.getDuration()).testType(testCase.getType().name()).resultStatus(result2.getStatus().name()).build();
                        break;
                    }
                    case 2: {
                        string = TeamCityMessageBuilder.Companion.testFinished(this.prefix, desc.getName().getDisplayName()).id(desc.getId().getValue()).parent(testCase.getDescription().getParent().getId().getValue()).duration(result2.getDuration()).testType(testCase.getType().name()).resultStatus(result2.getStatus().name()).build();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String msg = string;
                boolean bl5 = false;
                System.out.println((Object)msg);
            }
        }
    }

    @Override
    public void testIgnored(@NotNull TestCase testCase) {
        Reporter.DefaultImpls.testIgnored(this, testCase);
    }

    public TeamCityConsoleReporter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TestStatus.values().length];
            nArray[TestStatus.Failure.ordinal()] = 1;
            nArray[TestStatus.Error.ordinal()] = 2;
            nArray[TestStatus.Ignored.ordinal()] = 3;
            nArray[TestStatus.Success.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TestType.values().length];
            nArray[TestType.Container.ordinal()] = 1;
            nArray[TestType.Test.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

