package io.kotest.engine.extensions

import io.kotest.core.config.configuration
import io.kotest.core.extensions.Extension
import io.kotest.core.spec.Spec

/**
 * Returns all [Extension]s applicable to this [Spec]. This includes extensions via the
 * function override, those registered explicitly in the spec, and project wide extensions
 * from configuration.
 */
internal fun Spec.resolvedExtensions(): List<Extension> {
   return this.extensions() + this.registeredExtensions() + configuration.extensions()
}
