/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.listener;

import io.kotest.core.config.Configuration;
import io.kotest.core.descriptors.Descriptor;
import io.kotest.core.descriptors.KclassesKt;
import io.kotest.core.names.DisplayNameFormatter;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestCaseKt;
import io.kotest.core.test.TestResult;
import io.kotest.engine.errors.ExtensionExceptionExtractor;
import io.kotest.engine.extensions.MultipleExceptions;
import io.kotest.engine.interceptors.EngineContext;
import io.kotest.engine.listener.TestEngineListener;
import io.kotest.engine.teamcity.Locations;
import io.kotest.engine.teamcity.TeamCityMessageBuilder;
import io.kotest.engine.test.names.DefaultDisplayNameFormatter;
import io.kotest.engine.test.names.DefaultDisplayNameFormatterKt;
import io.kotest.mpp.ReflectionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u001f\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0011\u0010 \u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0014\u0010$\u001a\u00020\u00152\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\tH\u0002J'\u0010-\u001a\u00020\u00152\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J'\u0010/\u001a\u00020\u00152\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u00100\u001a\u0004\u0018\u00010\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u001d\u00102\u001a\u00020\u00152\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0014\u00104\u001a\u00020\u00152\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0010\u00105\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u00106\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J!\u00107\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J#\u00109\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u00010\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0019\u0010;\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"Lio/kotest/engine/listener/TeamCityTestEngineListener;", "Lio/kotest/engine/listener/TestEngineListener;", "prefix", "", "details", "", "(Ljava/lang/String;Z)V", "children", "", "Lio/kotest/core/descriptors/Descriptor;", "", "Lio/kotest/core/test/TestCase;", "formatter", "Lio/kotest/core/names/DisplayNameFormatter;", "results", "Lio/kotest/core/test/TestResult;", "rootTests", "started", "", "Lkotlin/reflect/KClass;", "addChild", "", "testCase", "engineFinished", "t", "", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "engineInitialized", "context", "Lio/kotest/engine/interceptors/EngineContext;", "(Lio/kotest/engine/interceptors/EngineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "engineStarted", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "failTest", "result", "finishSpec", "kclass", "finishTest", "finishTestSuite", "handleTest", "ignoreTest", "Lio/kotest/core/test/TestResult$Ignored;", "insertPlaceholder", "parent", "specFinished", "(Lkotlin/reflect/KClass;Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "specIgnored", "reason", "(Lkotlin/reflect/KClass;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "specStarted", "(Lkotlin/reflect/KClass;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startSpec", "startTest", "startTestSuite", "testFinished", "(Lio/kotest/core/test/TestCase;Lio/kotest/core/test/TestResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "testIgnored", "(Lio/kotest/core/test/TestCase;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "testStarted", "(Lio/kotest/core/test/TestCase;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kotest-framework-engine"})
public final class TeamCityTestEngineListener
implements TestEngineListener {
    @NotNull
    private final String prefix;
    private final boolean details;
    @NotNull
    private DisplayNameFormatter formatter;
    @NotNull
    private final Set<KClass<?>> started;
    @NotNull
    private final List<TestCase> rootTests;
    @NotNull
    private final Map<Descriptor, List<TestCase>> children;
    @NotNull
    private final Map<Descriptor, TestResult> results;

    public TeamCityTestEngineListener(@NotNull String prefix, boolean details) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        this.details = details;
        this.formatter = new DefaultDisplayNameFormatter(new Configuration());
        this.started = new LinkedHashSet();
        this.rootTests = new ArrayList();
        this.children = new LinkedHashMap();
        this.results = new LinkedHashMap();
    }

    public /* synthetic */ TeamCityTestEngineListener(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "##teamcity";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    private final void insertPlaceholder(Throwable t, Descriptor parent) {
        Pair<String, Throwable> pair = ExtensionExceptionExtractor.INSTANCE.resolve(t);
        String name = (String)pair.component1();
        Throwable cause = (Throwable)pair.component2();
        String msg1 = TeamCityMessageBuilder.Companion.testStarted(this.prefix, name).id(name).parent(Descriptor.DefaultImpls.path$default((Descriptor)parent, (boolean)false, (int)1, null).getValue()).build();
        System.out.println((Object)msg1);
        String msg2 = TeamCityMessageBuilder.Companion.testFailed(this.prefix, name).id(name).parent(Descriptor.DefaultImpls.path$default((Descriptor)parent, (boolean)false, (int)1, null).getValue()).withException(cause, this.details).build();
        System.out.println((Object)msg2);
        String msg3 = TeamCityMessageBuilder.Companion.testFinished(this.prefix, name).id(name).parent(Descriptor.DefaultImpls.path$default((Descriptor)parent, (boolean)false, (int)1, null).getValue()).build();
        System.out.println((Object)msg3);
    }

    @Override
    @Nullable
    public Object engineStarted(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object engineInitialized(@NotNull EngineContext context2, @NotNull Continuation<? super Unit> $completion) {
        this.formatter = DefaultDisplayNameFormatterKt.getDisplayNameFormatter(context2.getConfiguration().registry(), context2.getConfiguration());
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object engineFinished(@NotNull List<? extends Throwable> t, @NotNull Continuation<? super Unit> $completion) {
        if (!((Collection)t).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)t);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IndexedValue $dstr$index$error = (IndexedValue)element$iv;
                boolean bl = false;
                int index = $dstr$index$error.component1();
                Throwable error = (Throwable)$dstr$index$error.component2();
                String testName = t.size() == 1 ? "Engine exception" : Intrinsics.stringPlus((String)"Engine exception ", (Object)Boxing.boxInt((int)(index + 1)));
                System.out.println((Object)TeamCityMessageBuilder.Companion.testStarted(this.prefix, testName).build());
                String string = error.getMessage();
                if (string == null) {
                    string = ReflectionKt.bestName((KClass)Reflection.getOrCreateKotlinClass(t.getClass()));
                }
                String message = string;
                System.out.println((Object)TeamCityMessageBuilder.Companion.testFailed(this.prefix, testName).message(message).build());
                System.out.println((Object)TeamCityMessageBuilder.Companion.testFinished(this.prefix, testName).build());
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object specStarted(@NotNull KClass<?> kclass, @NotNull Continuation<? super Unit> $completion) {
        this.startSpec(kclass);
        return Unit.INSTANCE;
    }

    private final void startSpec(KClass<?> kclass) {
        String msg = TeamCityMessageBuilder.Companion.testSuiteStarted(this.prefix, this.formatter.format(kclass)).id(Descriptor.DefaultImpls.path$default((Descriptor)((Descriptor)KclassesKt.toDescriptor(kclass)), (boolean)false, (int)1, null).getValue()).locationHint(Locations.INSTANCE.location(kclass)).build();
        System.out.println((Object)msg);
        this.started.add(kclass);
    }

    private final void finishSpec(KClass<?> kclass) {
        String msg = TeamCityMessageBuilder.Companion.testSuiteFinished(this.prefix, this.formatter.format(kclass)).id(Descriptor.DefaultImpls.path$default((Descriptor)((Descriptor)KclassesKt.toDescriptor(kclass)), (boolean)false, (int)1, null).getValue()).locationHint(Locations.INSTANCE.location(kclass)).build();
        System.out.println((Object)msg);
    }

    @Override
    @Nullable
    public Object specFinished(@NotNull KClass<?> kclass, @Nullable Throwable t, @NotNull Continuation<? super Unit> $completion) {
        if (!this.started.contains(kclass)) {
            this.startSpec(kclass);
        }
        Iterable $this$forEach$iv = this.rootTests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestCase it = (TestCase)element$iv;
            boolean bl = false;
            this.handleTest(it);
        }
        Throwable throwable = t;
        if (throwable != null) {
            if (throwable instanceof MultipleExceptions) {
                Iterable $this$forEach$iv2 = ((MultipleExceptions)t).getCauses();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Throwable it = (Throwable)element$iv;
                    boolean bl = false;
                    this.insertPlaceholder(it, (Descriptor)KclassesKt.toDescriptor(kclass));
                }
            } else {
                this.insertPlaceholder(t, (Descriptor)KclassesKt.toDescriptor(kclass));
            }
        }
        this.finishSpec(kclass);
        return Unit.INSTANCE;
    }

    private final void handleTest(TestCase testCase) {
        TestResult testResult = this.results.get(testCase.getDescriptor());
        if (testResult == null) {
            return;
        }
        TestResult result = testResult;
        if (result instanceof TestResult.Ignored) {
            this.ignoreTest(testCase, (TestResult.Ignored)result);
        } else {
            List nestedTests;
            List list = this.children.get(testCase.getDescriptor());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if ((nestedTests = list).isEmpty()) {
                this.startTest(testCase);
                if (result.isErrorOrFailure()) {
                    this.failTest(testCase, result);
                }
                this.finishTest(testCase, result);
            } else {
                this.startTestSuite(testCase);
                Iterable $this$forEach$iv = nestedTests;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TestCase it = (TestCase)element$iv;
                    boolean bl = false;
                    this.handleTest(it);
                }
                Throwable t = result.getErrorOrNull();
                if (t != null) {
                    if (t instanceof MultipleExceptions) {
                        Iterable $this$forEach$iv2 = ((MultipleExceptions)t).getCauses();
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            Throwable it = (Throwable)element$iv;
                            boolean bl = false;
                            this.insertPlaceholder(it, (Descriptor)testCase.getDescriptor());
                        }
                    } else {
                        this.insertPlaceholder(t, (Descriptor)testCase.getDescriptor());
                    }
                }
                this.finishTestSuite(testCase, result);
            }
        }
    }

    @Override
    @Nullable
    public Object specIgnored(@NotNull KClass<?> kclass, @Nullable String reason, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object testStarted(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        if (TestCaseKt.isRootTest((TestCase)testCase)) {
            this.rootTests.add(testCase);
        } else {
            this.addChild(testCase);
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object testIgnored(@NotNull TestCase testCase, @Nullable String reason, @NotNull Continuation<? super Unit> $completion) {
        if (TestCaseKt.isRootTest((TestCase)testCase)) {
            this.rootTests.add(testCase);
        } else {
            this.addChild(testCase);
        }
        this.results.put((Descriptor)testCase.getDescriptor(), (TestResult)new TestResult.Ignored(reason));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void addChild(TestCase testCase) {
        Object object;
        void $this$getOrPut$iv;
        Map<Descriptor, List<TestCase>> map = this.children;
        Descriptor key$iv = testCase.getDescriptor().getParent();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(testCase);
    }

    @Override
    @Nullable
    public Object testFinished(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        Map<Descriptor, TestResult> map = this.results;
        Descriptor.TestDescriptor testDescriptor = testCase.getDescriptor();
        map.put((Descriptor)testDescriptor, result);
        return Unit.INSTANCE;
    }

    private final void ignoreTest(TestCase testCase, TestResult.Ignored result) {
        String msg = TeamCityMessageBuilder.Companion.testIgnored(this.prefix, this.formatter.format(testCase)).id(Descriptor.DefaultImpls.path$default((Descriptor)((Descriptor)testCase.getDescriptor()), (boolean)false, (int)1, null).getValue()).parent(Descriptor.DefaultImpls.path$default((Descriptor)testCase.getDescriptor().getParent(), (boolean)false, (int)1, null).getValue()).locationHint(Locations.INSTANCE.location(testCase.getSource())).message(result.getReason()).result((TestResult)result).build();
        System.out.println((Object)msg);
    }

    private final void startTest(TestCase testCase) {
        String msg = TeamCityMessageBuilder.Companion.testStarted(this.prefix, this.formatter.format(testCase)).id(Descriptor.DefaultImpls.path$default((Descriptor)((Descriptor)testCase.getDescriptor()), (boolean)false, (int)1, null).getValue()).parent(Descriptor.DefaultImpls.path$default((Descriptor)testCase.getDescriptor().getParent(), (boolean)false, (int)1, null).getValue()).locationHint(Locations.INSTANCE.location(testCase.getSource())).build();
        System.out.println((Object)msg);
    }

    private final void failTest(TestCase testCase, TestResult result) {
        String msg = TeamCityMessageBuilder.Companion.testFailed(this.prefix, this.formatter.format(testCase)).id(Descriptor.DefaultImpls.path$default((Descriptor)((Descriptor)testCase.getDescriptor()), (boolean)false, (int)1, null).getValue()).parent(Descriptor.DefaultImpls.path$default((Descriptor)testCase.getDescriptor().getParent(), (boolean)false, (int)1, null).getValue()).duration-LRDsOJo(result.getDuration-UwyO8pc()).locationHint(Locations.INSTANCE.location(testCase.getSource())).withException(result.getErrorOrNull(), this.details).result(result).build();
        System.out.println((Object)msg);
    }

    private final void finishTest(TestCase testCase, TestResult result) {
        String msg = TeamCityMessageBuilder.Companion.testFinished(this.prefix, this.formatter.format(testCase)).id(Descriptor.DefaultImpls.path$default((Descriptor)((Descriptor)testCase.getDescriptor()), (boolean)false, (int)1, null).getValue()).parent(Descriptor.DefaultImpls.path$default((Descriptor)testCase.getDescriptor().getParent(), (boolean)false, (int)1, null).getValue()).duration-LRDsOJo(result.getDuration-UwyO8pc()).locationHint(Locations.INSTANCE.location(testCase.getSource())).result(result).build();
        System.out.println((Object)msg);
    }

    private final void startTestSuite(TestCase testCase) {
        String msg = TeamCityMessageBuilder.Companion.testSuiteStarted(this.prefix, this.formatter.format(testCase)).id(Descriptor.DefaultImpls.path$default((Descriptor)((Descriptor)testCase.getDescriptor()), (boolean)false, (int)1, null).getValue()).parent(Descriptor.DefaultImpls.path$default((Descriptor)testCase.getDescriptor().getParent(), (boolean)false, (int)1, null).getValue()).locationHint(Locations.INSTANCE.location(testCase.getSource())).build();
        System.out.println((Object)msg);
    }

    private final void finishTestSuite(TestCase testCase, TestResult result) {
        String msg = TeamCityMessageBuilder.Companion.testSuiteFinished(this.prefix, this.formatter.format(testCase)).id(Descriptor.DefaultImpls.path$default((Descriptor)((Descriptor)testCase.getDescriptor()), (boolean)false, (int)1, null).getValue()).parent(Descriptor.DefaultImpls.path$default((Descriptor)testCase.getDescriptor().getParent(), (boolean)false, (int)1, null).getValue()).duration-LRDsOJo(result.getDuration-UwyO8pc()).locationHint(Locations.INSTANCE.location(testCase.getSource())).result(result).build();
        System.out.println((Object)msg);
    }

    public TeamCityTestEngineListener() {
        this(null, false, 3, null);
    }
}

