/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.teamcity;

import io.kotest.core.SourceRef;
import io.kotest.mpp.ReflectionKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\n\u001a\u00020\u00042\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a8\u0006\u000f"}, d2={"Lio/kotest/engine/teamcity/Locations;", "", "()V", "classHint", "", "fqn", "lineNumber", "", "fileHint", "fileName", "location", "sourceRef", "Lio/kotest/core/SourceRef;", "kclass", "Lkotlin/reflect/KClass;", "kotest-framework-engine"})
public final class Locations {
    @NotNull
    public static final Locations INSTANCE = new Locations();

    private Locations() {
    }

    @NotNull
    public final String location(@NotNull KClass<?> kclass) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        return "kotest:class://" + ReflectionKt.bestName(kclass) + ":1";
    }

    private final String fileHint(String fileName, int lineNumber) {
        return "kotest:file://" + fileName + ':' + lineNumber;
    }

    private final String classHint(String fqn, int lineNumber) {
        return "kotest:class://" + fqn + ':' + lineNumber;
    }

    @Nullable
    public final String location(@NotNull SourceRef sourceRef) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sourceRef, (String)"sourceRef");
        SourceRef sourceRef2 = sourceRef;
        if (sourceRef2 instanceof SourceRef.FileLineSource) {
            string = this.fileHint(((SourceRef.FileLineSource)sourceRef).getFileName(), ((SourceRef.FileLineSource)sourceRef).getLineNumber());
        } else if (sourceRef2 instanceof SourceRef.FileSource) {
            string = this.fileHint(((SourceRef.FileSource)sourceRef).getFileName(), 1);
        } else if (sourceRef2 instanceof SourceRef.ClassLineSource) {
            string = this.classHint(((SourceRef.ClassLineSource)sourceRef).getFqn(), ((SourceRef.ClassLineSource)sourceRef).getLineNumber());
        } else if (sourceRef2 instanceof SourceRef.ClassSource) {
            string = this.classHint(((SourceRef.ClassSource)sourceRef).getFqn(), 1);
        } else if (Intrinsics.areEqual((Object)sourceRef2, (Object)SourceRef.None.INSTANCE)) {
            string = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

