/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.errors;

import io.kotest.engine.extensions.ExtensionException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lio/kotest/engine/errors/ExtensionExceptionExtractor;", "", "()V", "resolve", "Lkotlin/Pair;", "", "", "t", "kotest-framework-engine"})
public final class ExtensionExceptionExtractor {
    @NotNull
    public static final ExtensionExceptionExtractor INSTANCE = new ExtensionExceptionExtractor();

    private ExtensionExceptionExtractor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Pair<String, Throwable> resolve(@NotNull Throwable t) {
        String string;
        Throwable cause;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Throwable throwable = t.getCause();
        if (throwable == null) {
            throwable = cause = t;
        }
        if (t instanceof ExtensionException) {
            ExtensionException extensionException = (ExtensionException)t;
            if (extensionException instanceof ExtensionException.BeforeProjectException) {
                string = "Before Project Error";
            } else if (extensionException instanceof ExtensionException.AfterProjectException) {
                string = "After Project Error";
            } else if (extensionException instanceof ExtensionException.BeforeTestException) {
                string = "Before Test Error";
            } else if (extensionException instanceof ExtensionException.AfterTestException) {
                string = "After Test Error";
            } else if (extensionException instanceof ExtensionException.BeforeEachException) {
                string = "Before Each Error";
            } else if (extensionException instanceof ExtensionException.AfterEachException) {
                string = "After Each Error";
            } else if (extensionException instanceof ExtensionException.BeforeContainerException) {
                string = "Before Container Error";
            } else if (extensionException instanceof ExtensionException.AfterContainerException) {
                string = "After Container Error";
            } else if (extensionException instanceof ExtensionException.BeforeAnyException) {
                string = "Before Any Error";
            } else if (extensionException instanceof ExtensionException.AfterAnyException) {
                string = "After Any Error";
            } else if (extensionException instanceof ExtensionException.BeforeInvocationException) {
                string = "Before Invocation Error";
            } else if (extensionException instanceof ExtensionException.AfterInvocationException) {
                string = "After Invocation Error";
            } else if (extensionException instanceof ExtensionException.BeforeSpecException) {
                string = "Before Spec Error";
            } else if (extensionException instanceof ExtensionException.AfterSpecException) {
                string = "After Spec Error";
            } else if (extensionException instanceof ExtensionException.PrepareSpecException) {
                string = "Prepare Spec Error";
            } else if (extensionException instanceof ExtensionException.FinalizeSpecException) {
                string = "Finalize Spec Error";
            } else {
                if (!(extensionException instanceof ExtensionException.IgnoredSpecException)) throw new NoWhenBranchMatchedException();
                string = "Ignored Spec Error";
            }
        } else {
            string = Reflection.getOrCreateKotlinClass(t.getClass()).getSimpleName();
            if (string == null) {
                string = "<error>";
            }
        }
        String name = string;
        return new Pair((Object)name, (Object)cause);
    }
}

