/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.listener;

import com.github.ajalt.mordant.TermColors;
import io.kotest.core.config.ProjectConfiguration;
import io.kotest.core.descriptors.Descriptor;
import io.kotest.core.descriptors.DescriptorKt;
import io.kotest.core.descriptors.KclassesKt;
import io.kotest.core.names.DisplayNameFormatter;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.core.test.TestType;
import io.kotest.engine.interceptors.EngineContext;
import io.kotest.engine.listener.AbstractTestEngineListener;
import io.kotest.engine.test.names.DefaultDisplayNameFormatter;
import io.kotest.engine.test.names.DefaultDisplayNameFormatterKt;
import io.kotest.engine.test.names.PathsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u001d\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\rH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u00101\u001a\u00020'H\u0002J\b\u00102\u001a\u00020'H\u0002J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u00010)2\u0006\u00105\u001a\u00020\u0006H\u0002J\u0010\u00106\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u00107\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J%\u00108\u001a\u00020'2\n\u00109\u001a\u0006\u0012\u0002\b\u00030:2\u0006\u0010;\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u001d\u0010=\u001a\u00020'2\n\u00109\u001a\u0006\u0012\u0002\b\u00030:H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J!\u0010?\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010AJ#\u0010B\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00172\b\u0010C\u001a\u0004\u0018\u00010\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJ\u0019\u0010E\u001a\u00020'2\u0006\u0010@\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u0010\u0010G\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010H\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\u00020\rX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00160\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001b\u001a\u00020\rX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000e\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006I"}, d2={"Lio/kotest/engine/listener/EnhancedConsoleTestEngineListener;", "Lio/kotest/engine/listener/AbstractTestEngineListener;", "term", "Lcom/github/ajalt/mordant/TermColors;", "(Lcom/github/ajalt/mordant/TermColors;)V", "errors", "", "formatter", "Lio/kotest/core/names/DisplayNameFormatter;", "intros", "", "", "slow", "Lkotlin/time/Duration;", "J", "specsFailed", "Lio/kotest/core/descriptors/Descriptor$SpecDescriptor;", "specsSeen", "Lio/kotest/core/descriptors/Descriptor;", "start", "", "testsFailed", "Lkotlin/Pair;", "Lio/kotest/core/test/TestCase;", "Lio/kotest/core/test/TestResult;", "testsIgnored", "testsPassed", "verySlow", "bold", "str", "brightRed", "brightRedBold", "brightYellow", "brightYellowBold", "durationString", "duration", "durationString-LRDsOJo", "(J)Ljava/lang/String;", "engineFinished", "", "t", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "engineInitialized", "context", "Lio/kotest/engine/interceptors/EngineContext;", "(Lio/kotest/engine/interceptors/EngineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "green", "greenBold", "printSpecCounts", "printTestsCounts", "printThrowable", "error", "padding", "red", "redBold", "specFinished", "kclass", "Lkotlin/reflect/KClass;", "result", "(Lkotlin/reflect/KClass;Lio/kotest/core/test/TestResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "specStarted", "(Lkotlin/reflect/KClass;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "testFinished", "testCase", "(Lio/kotest/core/test/TestCase;Lio/kotest/core/test/TestResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "testIgnored", "reason", "(Lio/kotest/core/test/TestCase;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "testStarted", "(Lio/kotest/core/test/TestCase;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "yellow", "yellowBold", "kotest-framework-engine"})
public final class EnhancedConsoleTestEngineListener
extends AbstractTestEngineListener {
    @NotNull
    private final TermColors term;
    private int errors;
    private long start;
    @NotNull
    private List<? extends Pair<TestCase, ? extends TestResult>> testsFailed;
    private int testsIgnored;
    private int testsPassed;
    @NotNull
    private List<Descriptor.SpecDescriptor> specsFailed;
    @NotNull
    private List<? extends Descriptor> specsSeen;
    private long slow;
    private long verySlow;
    @NotNull
    private DisplayNameFormatter formatter;
    @NotNull
    private final List<String> intros;

    public EnhancedConsoleTestEngineListener(@NotNull TermColors term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.term = term;
        this.start = System.currentTimeMillis();
        this.testsFailed = CollectionsKt.emptyList();
        this.specsFailed = CollectionsKt.emptyList();
        this.specsSeen = CollectionsKt.emptyList();
        this.slow = Duration.Companion.milliseconds-UwyO8pc(500);
        this.verySlow = Duration.Companion.milliseconds-UwyO8pc(5000);
        this.formatter = new DefaultDisplayNameFormatter(new ProjectConfiguration());
        Object[] objectArray = new String[]{"Feeding the kotest engine with freshly harvested tests", "Engaging kotest engine at warp factor 9", "Harvesting the test fields", "Preparing to sacrifice your code to the demi-god of test", "Hamsters are turning the wheels of kotest", "Battle commanders are ready to declare war on bugs", "Be afraid - be very afraid - of failing tests", "The point is, ladies and gentlemen, that green is good", "Lock test-foils in attack position", "Fasten your seatbelts. It's going to be a bumpy test-run", "Lets crack open this test suite", "Lets get testing, I'm on the clock here", "Test time is the best time", "Open the test suite doors, HAL", "Mama always said testing was like a box of chocolates. You don't know which ones are gonna fail", "A test suite. Shaken, not stirred", "I'm going to make him a test he can't refuse", "You testing me? I don't see any other tests here, so you must be testing me", "I love the smell of tests in the morning", "Do you feel lucky punk? Do you think your tests will pass? Well, do ya?", "Mirab, with tests unfurled", "Dolly works 9 to 5. I test 24/7", "A test suite's gotta do what a test suite's gotta do", "I test code and chew bubblegum, and I'm all out of bubblegum"};
        this.intros = CollectionsKt.listOf((Object[])objectArray);
    }

    private final String green(String str) {
        return this.term.getGreen().invoke(str);
    }

    private final String greenBold(String str) {
        return this.term.getGreen().plus(this.term.getBold()).invoke(str);
    }

    private final String red(String str) {
        return this.term.getRed().invoke(str);
    }

    private final String brightRed(String str) {
        return this.term.getBrightRed().invoke(str);
    }

    private final String brightRedBold(String str) {
        return this.term.getBrightRed().plus(this.term.getBold()).invoke(str);
    }

    private final String redBold(String str) {
        return this.term.getRed().plus(this.term.getBold()).invoke(str);
    }

    private final String yellow(String str) {
        return this.term.getYellow().invoke(str);
    }

    private final String brightYellow(String str) {
        return this.term.getBrightYellow().invoke(str);
    }

    private final String brightYellowBold(String str) {
        return this.term.getBrightYellow().plus(this.term.getBold()).invoke(str);
    }

    private final String yellowBold(String str) {
        return this.term.getYellow().plus(this.term.getBold()).invoke(str);
    }

    private final String bold(String str) {
        return this.term.getBold().invoke(str);
    }

    @Override
    @Nullable
    public Object engineInitialized(@NotNull EngineContext context2, @NotNull Continuation<? super Unit> $completion) {
        this.formatter = DefaultDisplayNameFormatterKt.getDisplayNameFormatter(context2.getConfiguration().getRegistry(), context2.getConfiguration());
        System.out.println((Object)this.bold(">> Kotest"));
        System.out.println((Object)Intrinsics.stringPlus((String)"- ", (Object)CollectionsKt.first((List)CollectionsKt.shuffled((Iterable)this.intros))));
        System.out.print((Object)"- Test plan has ");
        System.out.print((Object)this.greenBold(String.valueOf(context2.getSuite().getSpecs().size())));
        System.out.println((Object)" specs");
        System.out.println();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object engineFinished(@NotNull List<? extends Throwable> t, @NotNull Continuation<? super Unit> $completion) {
        if (this.specsSeen.isEmpty()) {
            return Unit.INSTANCE;
        }
        if (!((Collection)t).isEmpty()) {
            this.errors += t.size();
            Iterable $this$forEach$iv = t;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable it = (Throwable)element$iv;
                boolean bl = false;
                this.printThrowable(it, 0);
            }
        }
        long duration = System.currentTimeMillis() - this.start;
        long seconds = duration / (long)1000;
        if (this.errors == 0) {
            System.out.println((Object)this.bold(">> All tests passed"));
        } else {
            System.out.println((Object)this.redBold(">> There were test failures"));
            System.out.println();
            Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)this.specsFailed);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv;
                Descriptor.SpecDescriptor spec = (Descriptor.SpecDescriptor)element$iv;
                boolean bl = false;
                System.out.println((Object)this.brightRedBold(Intrinsics.stringPlus((String)" ", (Object)this.formatter.format(spec.getKclass()))));
                Iterable $this$filter$iv = this.testsFailed;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Pair it = (Pair)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)KclassesKt.toDescriptor((KClass)Reflection.getOrCreateKotlinClass(((TestCase)it.getFirst()).getSpec().getClass())), (Object)spec)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pair $dstr$testCase$_u24__u24 = (Pair)element$iv2;
                    boolean bl3 = false;
                    TestCase testCase = (TestCase)$dstr$testCase$_u24__u24.component1();
                    System.out.println((Object)this.brightRed(Intrinsics.stringPlus((String)" - ", (Object)PathsKt.formatTestPath(this.formatter, testCase, " -- "))));
                }
            }
        }
        System.out.println();
        this.printSpecCounts();
        this.printTestsCounts();
        System.out.print((Object)"Time:    ");
        System.out.println((Object)this.bold("" + seconds + 's'));
        return Unit.INSTANCE;
    }

    private final void printThrowable(Throwable error, int padding) {
        if (error != null) {
            String message = error.getMessage();
            if (message != null) {
                System.out.println((Object)this.brightRed(StringsKt.padStart((String)message, (int)padding, (char)' ')));
            }
            StackTraceElement[] stackTraceElementArray = error.getStackTrace();
            if (stackTraceElementArray != null) {
                StackTraceElement[] $this$forEach$iv = stackTraceElementArray;
                boolean $i$f$forEach = false;
                for (StackTraceElement element$iv : $this$forEach$iv) {
                    StackTraceElement it = element$iv;
                    boolean bl = false;
                    System.out.println((Object)this.red(Intrinsics.stringPlus((String)StringsKt.padStart((String)"", (int)(padding + 2), (char)' '), (Object)it)));
                }
            }
        }
    }

    private final void printSpecCounts() {
        int specsSeenSize = CollectionsKt.distinct((Iterable)this.specsSeen).size();
        int specsPassedSize = CollectionsKt.minus((Iterable)CollectionsKt.distinct((Iterable)this.specsSeen), (Iterable)this.specsFailed).size();
        int specsFailedSize = CollectionsKt.distinct((Iterable)this.specsFailed).size();
        System.out.print((Object)"Specs:   ");
        System.out.print((Object)this.greenBold(specsPassedSize + " passed"));
        System.out.print((Object)", ");
        if (this.specsFailed.isEmpty()) {
            System.out.print((Object)this.bold(specsFailedSize + " failed"));
            System.out.print((Object)this.bold(", "));
        } else {
            System.out.print((Object)this.redBold(specsFailedSize + " failed"));
            System.out.print((Object)this.bold(", "));
        }
        System.out.println((Object)(specsSeenSize + " total"));
    }

    private final void printTestsCounts() {
        System.out.print((Object)"Tests:   ");
        System.out.print((Object)this.greenBold(this.testsPassed + " passed"));
        System.out.print((Object)", ");
        if (this.testsFailed.isEmpty()) {
            System.out.print((Object)this.bold(this.testsFailed.size() + " failed"));
            System.out.print((Object)", ");
        } else {
            System.out.print((Object)this.redBold(this.testsFailed.size() + " failed"));
            System.out.print((Object)", ");
        }
        if (this.testsIgnored > 0) {
            System.out.print((Object)this.yellowBold(this.testsIgnored + " ignored"));
            System.out.print((Object)", ");
        } else {
            System.out.print((Object)this.bold(this.testsIgnored + " ignored"));
            System.out.print((Object)", ");
        }
        System.out.println((Object)(this.testsPassed + this.testsFailed.size() + this.testsIgnored + " total"));
    }

    @Override
    @Nullable
    public Object specStarted(@NotNull KClass<?> kclass, @NotNull Continuation<? super Unit> $completion) {
        this.specsSeen = CollectionsKt.plus((Collection)this.specsSeen, (Object)KclassesKt.toDescriptor(kclass));
        int specCount = this.specsSeen.size();
        System.out.print((Object)this.bold(StringsKt.padEnd((String)(specCount + ". "), (int)4, (char)' ')));
        System.out.println((Object)this.bold(this.formatter.format(kclass)));
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object specFinished(@NotNull KClass<?> kclass, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        if (result.isErrorOrFailure()) {
            int n = this.errors;
            this.errors = n + 1;
            this.specsFailed = CollectionsKt.plus((Collection)this.specsFailed, (Object)KclassesKt.toDescriptor(kclass));
            this.printThrowable(result.getErrorOrNull(), 4);
        }
        System.out.println();
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object testIgnored(@NotNull TestCase testCase, @Nullable String reason, @NotNull Continuation<? super Unit> $completion) {
        int n = this.testsIgnored;
        this.testsIgnored = n + 1;
        System.out.print((Object)StringsKt.padEnd((String)"", (int)(testCase.getDescriptor().depth() * 4), (char)' '));
        System.out.print((Object)Intrinsics.stringPlus((String)"- ", (Object)this.formatter.format(testCase)));
        System.out.println((Object)this.brightYellowBold(" IGNORED"));
        return Unit.INSTANCE;
    }

    private final String durationString-LRDsOJo(long duration) {
        long l = this.slow;
        return (Duration.box-impl((long)duration).compareTo((Object)Duration.box-impl((long)this.verySlow)) <= 0 ? 0 <= Duration.box-impl((long)duration).compareTo((Object)Duration.box-impl((long)l)) : false) ? this.term.getBrightYellow().invoke("" + '(' + Duration.getInWholeMilliseconds-impl((long)duration) + "ms)") : (Duration.compareTo-LRDsOJo((long)duration, (long)this.verySlow) > 0 ? this.term.getBrightRed().invoke("" + '(' + Duration.getInWholeMilliseconds-impl((long)duration) + "ms)") : "");
    }

    @Override
    @Nullable
    public Object testFinished(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        TestResult testResult = result;
        if (testResult instanceof TestResult.Success) {
            if (testCase.getType() == TestType.Test) {
                int n = this.testsPassed;
                this.testsPassed = n + 1;
            }
        } else if (testResult instanceof TestResult.Failure ? true : testResult instanceof TestResult.Error) {
            int n = this.errors;
            this.errors = n + 1;
            this.testsFailed = CollectionsKt.plus((Collection)this.testsFailed, (Object)new Pair((Object)testCase, (Object)result));
            this.specsFailed = CollectionsKt.plus((Collection)this.specsFailed, (Object)DescriptorKt.spec((Descriptor.TestDescriptor)testCase.getDescriptor()));
        }
        if (testCase.getType() == TestType.Test) {
            System.out.print((Object)StringsKt.padEnd((String)"", (int)(testCase.getDescriptor().depth() * 4), (char)' '));
            System.out.print((Object)Intrinsics.stringPlus((String)"- ", (Object)this.formatter.format(testCase)));
            testResult = result;
            if (testResult instanceof TestResult.Success) {
                System.out.print((Object)this.greenBold(" OK"));
            } else if (testResult instanceof TestResult.Error) {
                System.out.print((Object)this.brightRed(" ERROR"));
            } else if (testResult instanceof TestResult.Failure) {
                System.out.print((Object)this.brightRed(" FAILED"));
            } else if (testResult instanceof TestResult.Ignored) {
                System.out.print((Object)this.brightYellow(" IGNORED"));
            }
            if (Duration.compareTo-LRDsOJo((long)result.getDuration-UwyO8pc(), (long)this.slow) > 0) {
                System.out.print((Object)Intrinsics.stringPlus((String)" ", (Object)this.durationString-LRDsOJo(result.getDuration-UwyO8pc())));
            }
            System.out.println();
        }
        if (result.getErrorOrNull() != null) {
            System.out.println();
            this.printThrowable(result.getErrorOrNull(), testCase.getDescriptor().depth() * 4);
            System.out.println();
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object testStarted(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        if (testCase.getType() == TestType.Container) {
            System.out.print((Object)StringsKt.padEnd((String)"", (int)(testCase.getDescriptor().depth() * 4), (char)' '));
            System.out.println((Object)Intrinsics.stringPlus((String)"+ ", (Object)this.formatter.format(testCase)));
        }
        return Unit.INSTANCE;
    }
}

