/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.property.arbitrary.strings;

import io.kotest.property.Classifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/kotest/property/arbitrary/strings/StringClassifier;", "Lio/kotest/property/Classifier;", "", "min", "", "max", "(II)V", "classify", "value", "kotest-property"})
public final class StringClassifier
implements Classifier<String> {
    private final int min;
    private final int max;

    public StringClassifier(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    @Nullable
    public String classify(@NotNull String value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            string2 = "EMPTY STRING";
        } else if (StringsKt.isBlank((CharSequence)value)) {
            string2 = "BLANK STRING";
        } else if (value.length() == this.min) {
            string2 = "MIN LENGTH";
        } else if (value.length() == this.max) {
            string2 = "MAX LENGTH";
        } else if (value.length() == 1 && Character.isDigit(value.charAt(0))) {
            string2 = "SINGLE CHARACTER DIGIT";
        } else if (value.length() == 1 && Character.isLetter(value.charAt(0))) {
            string2 = "SINGLE CHARACTER LETTER";
        } else {
            boolean bl;
            block13: {
                CharSequence $this$all$iv = value;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (Character.isLetterOrDigit(it)) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
            string2 = bl ? "ANY LENGTH LETTER OR DIGITS" : null;
        }
        return string2;
    }
}

