package io.kotest.property.arbitrary

import io.kotest.property.Arb
import io.kotest.property.Gen
import kotlin.jvm.JvmOverloads

/**
 * Returns an [Arb] which returns sequences that contain values generated by the given generator.
 * The size of each sequence is determined randomly within the specified [range].
 *
 * The edge cases are the empty sequence, if the range includes zero, and a sequence with a repeated element (taken
 * as the first edge case from the underlying gen).
 *
 * Shrinking is performed by removing elements from the sequence until the empty sequence is reached.
 */
@JvmOverloads
fun <A> Arb.Companion.sequence(gen: Gen<A>, range: IntRange = 0..100): Arb<Sequence<A>> {
   return arbitrary {
      list(gen, range).bind().asSequence()
   }
}

/**
 * Returns an [Arb] which returns sequences that contain values generated by the given generator.
 * The size of each sequence is determined randomly within the specified [range].
 *
 * The edge cases are the empty sequence, if the range includes zero, and a sequence with a repeated element (taken
 * as the first edge case from the underlying gen).
 *
 * Shrinking is performed by removing elements from the sequence until the empty sequence is reached.
 */
fun <A> Arb.Companion.sequence(gen: Gen<A>, range: Arb<IntRange>): Arb<Sequence<A>> {
   return arbitrary {
      val domain = range.bind()
      sequence(gen, domain).bind()
   }
}
