/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.runner.junit4;

import io.kotest.common.ExperimentalKotest;
import io.kotest.core.plan.Descriptor;
import io.kotest.core.spec.Spec;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.core.test.TestStatus;
import io.kotest.engine.listener.TestEngineListener;
import io.kotest.runner.junit4.DescribeTestCaseKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/kotest/runner/junit4/JUnitTestEngineListener;", "Lio/kotest/engine/listener/TestEngineListener;", "notifier", "Lorg/junit/runner/notification/RunNotifier;", "(Lorg/junit/runner/notification/RunNotifier;)V", "notifyFailure", "", "desc", "Lorg/junit/runner/Description;", "result", "Lio/kotest/core/test/TestResult;", "testFinished", "testCase", "Lio/kotest/core/test/TestCase;", "testStarted", "kotest-runner-junit4"})
public final class JUnitTestEngineListener
implements TestEngineListener {
    @NotNull
    private final RunNotifier notifier;

    public JUnitTestEngineListener(@NotNull RunNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        this.notifier = notifier;
    }

    public void testStarted(@NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        this.notifier.fireTestStarted(DescribeTestCaseKt.describeTestCase(testCase));
    }

    public void testFinished(@NotNull TestCase testCase, @NotNull TestResult result) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Description desc = DescribeTestCaseKt.describeTestCase(testCase);
        TestStatus testStatus = result.getStatus();
        int n = WhenMappings.$EnumSwitchMapping$0[testStatus.ordinal()];
        switch (n) {
            case 1: {
                this.notifier.fireTestFinished(desc);
                break;
            }
            case 2: {
                this.notifyFailure(desc, result);
                break;
            }
            case 3: {
                this.notifier.fireTestIgnored(desc);
                break;
            }
            case 4: {
                this.notifyFailure(desc, result);
            }
        }
    }

    private final void notifyFailure(Description desc, TestResult result) {
        this.notifier.fireTestFailure(new Failure(desc, result.getError()));
        this.notifier.fireTestFinished(desc);
    }

    @ExperimentalKotest
    public void testFinished(@NotNull Descriptor.TestDescriptor descriptor, @NotNull TestResult result) {
        TestEngineListener.DefaultImpls.testFinished((TestEngineListener)this, (Descriptor.TestDescriptor)descriptor, (TestResult)result);
    }

    @ExperimentalKotest
    public void testIgnored(@NotNull Descriptor.TestDescriptor descriptor, @Nullable String reason) {
        TestEngineListener.DefaultImpls.testIgnored((TestEngineListener)this, (Descriptor.TestDescriptor)descriptor, (String)reason);
    }

    @ExperimentalKotest
    public void testStarted(@NotNull Descriptor.TestDescriptor descriptor) {
        TestEngineListener.DefaultImpls.testStarted((TestEngineListener)this, (Descriptor.TestDescriptor)descriptor);
    }

    @ExperimentalKotest
    @Nullable
    public Object specFinished(@NotNull Descriptor.SpecDescriptor descriptor, @Nullable Throwable t, @NotNull Map<Descriptor.TestDescriptor, TestResult> results, @NotNull Continuation<? super Unit> $completion) {
        return TestEngineListener.DefaultImpls.specFinished((TestEngineListener)this, (Descriptor.SpecDescriptor)descriptor, (Throwable)t, results, $completion);
    }

    public void engineFinished(@NotNull List<? extends Throwable> t) {
        TestEngineListener.DefaultImpls.engineFinished((TestEngineListener)this, t);
    }

    public void engineStarted(@NotNull List<? extends KClass<? extends Spec>> classes) {
        TestEngineListener.DefaultImpls.engineStarted((TestEngineListener)this, classes);
    }

    public void specFinished(@NotNull KClass<? extends Spec> kclass, @Nullable Throwable t, @NotNull Map<TestCase, TestResult> results) {
        TestEngineListener.DefaultImpls.specFinished((TestEngineListener)this, kclass, (Throwable)t, results);
    }

    public void specInstantiated(@NotNull Spec spec) {
        TestEngineListener.DefaultImpls.specInstantiated((TestEngineListener)this, (Spec)spec);
    }

    public void specInstantiationError(@NotNull KClass<? extends Spec> kclass, @NotNull Throwable t) {
        TestEngineListener.DefaultImpls.specInstantiationError((TestEngineListener)this, kclass, (Throwable)t);
    }

    public void specStarted(@NotNull KClass<? extends Spec> kclass) {
        TestEngineListener.DefaultImpls.specStarted((TestEngineListener)this, kclass);
    }

    public void testIgnored(@NotNull TestCase testCase, @Nullable String reason) {
        TestEngineListener.DefaultImpls.testIgnored((TestEngineListener)this, (TestCase)testCase, (String)reason);
    }

    @Nullable
    public Object specStarted(@NotNull Descriptor.SpecDescriptor descriptor, @NotNull Continuation<? super Unit> $completion) {
        return TestEngineListener.DefaultImpls.specStarted((TestEngineListener)this, (Descriptor.SpecDescriptor)descriptor, $completion);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestStatus.values().length];
            nArray[TestStatus.Success.ordinal()] = 1;
            nArray[TestStatus.Error.ordinal()] = 2;
            nArray[TestStatus.Ignored.ordinal()] = 3;
            nArray[TestStatus.Failure.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

