/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.runner.junit4;

import io.kotest.core.config.ProjectConfiguration;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.engine.listener.AbstractTestEngineListener;
import io.kotest.engine.test.names.DefaultDisplayNameFormatter;
import io.kotest.runner.junit4.DescribeTestCaseKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/kotest/runner/junit4/JUnitTestEngineListener;", "Lio/kotest/engine/listener/AbstractTestEngineListener;", "notifier", "Lorg/junit/runner/notification/RunNotifier;", "(Lorg/junit/runner/notification/RunNotifier;)V", "formatter", "Lio/kotest/engine/test/names/DefaultDisplayNameFormatter;", "notifyFailure", "", "desc", "Lorg/junit/runner/Description;", "result", "Lio/kotest/core/test/TestResult;", "testFinished", "testCase", "Lio/kotest/core/test/TestCase;", "(Lio/kotest/core/test/TestCase;Lio/kotest/core/test/TestResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "testStarted", "(Lio/kotest/core/test/TestCase;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kotest-runner-junit4"})
public final class JUnitTestEngineListener
extends AbstractTestEngineListener {
    @NotNull
    private final RunNotifier notifier;
    @NotNull
    private final DefaultDisplayNameFormatter formatter;

    public JUnitTestEngineListener(@NotNull RunNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        this.notifier = notifier;
        this.formatter = new DefaultDisplayNameFormatter(new ProjectConfiguration());
    }

    @Nullable
    public Object testStarted(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        this.notifier.fireTestStarted(DescribeTestCaseKt.describeTestCase(testCase, this.formatter.format(testCase)));
        return Unit.INSTANCE;
    }

    @Nullable
    public Object testFinished(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        Description desc = DescribeTestCaseKt.describeTestCase(testCase, this.formatter.format(testCase));
        TestResult testResult = result;
        if (testResult instanceof TestResult.Success) {
            this.notifier.fireTestFinished(desc);
        } else if (testResult instanceof TestResult.Error) {
            this.notifyFailure(desc, result);
        } else if (testResult instanceof TestResult.Ignored) {
            this.notifier.fireTestIgnored(desc);
        } else if (testResult instanceof TestResult.Failure) {
            this.notifyFailure(desc, result);
        }
        return Unit.INSTANCE;
    }

    private final void notifyFailure(Description desc, TestResult result) {
        this.notifier.fireTestFailure(new Failure(desc, result.getErrorOrNull()));
        this.notifier.fireTestFinished(desc);
    }
}

