/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.runner.junit.platform;

import io.kotest.core.config.ConfigurationKt;
import io.kotest.core.listeners.AfterProjectListenerException;
import io.kotest.core.listeners.BeforeProjectListenerException;
import io.kotest.core.spec.DescriptionKt;
import io.kotest.core.spec.Spec;
import io.kotest.core.test.Description;
import io.kotest.core.test.DescriptionNameKt;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.core.test.TestType;
import io.kotest.engine.WriteSpecFailuresKt;
import io.kotest.engine.listener.TestEngineListener;
import io.kotest.mpp.LoggerKt;
import io.kotest.runner.junit.platform.DescriptorsKt;
import io.kotest.runner.junit.platform.JUnitTestEngineListener;
import io.kotest.runner.junit.platform.JUnitTestEngineListener$WhenMappings;
import io.kotest.runner.junit.platform.Segment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0016J\u001e\u0010 \u001a\u00020\u001d2\u0014\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\u001fH\u0016J \u0010\"\u001a\u00020\u001d2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u001e\u001a\u00020\fH\u0002J6\u0010$\u001a\u00020\u001d2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020'0&H\u0016J \u0010(\u001a\u00020\u001d2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0018\u0010)\u001a\u00020\u001d2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0016J\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020'H\u0016J\u001a\u0010,\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010-\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010/\u001a\u000200*\u00020'H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lio/kotest/runner/junit/platform/JUnitTestEngineListener;", "Lio/kotest/engine/listener/TestEngineListener;", "listener", "Lorg/junit/platform/engine/EngineExecutionListener;", "root", "Lorg/junit/platform/engine/support/descriptor/EngineDescriptor;", "(Lorg/junit/platform/engine/EngineExecutionListener;Lorg/junit/platform/engine/support/descriptor/EngineDescriptor;)V", "descriptors", "", "Lio/kotest/core/test/Description;", "Lorg/junit/platform/engine/TestDescriptor;", "exceptionThrowBySpec", "", "failedSpecs", "", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "hasIgnoredTest", "", "hasVisibleTest", "getRoot", "()Lorg/junit/platform/engine/support/descriptor/EngineDescriptor;", "createAndRegisterTest", "name", "", "createTestDescriptor", "testCase", "Lio/kotest/core/test/TestCase;", "engineFinished", "", "t", "", "engineStarted", "classes", "ensureSpecIsVisible", "kclass", "specFinished", "results", "", "Lio/kotest/core/test/TestResult;", "specInstantiationError", "specStarted", "testFinished", "result", "testIgnored", "reason", "testStarted", "testExecutionResult", "Lorg/junit/platform/engine/TestExecutionResult;", "kotest-runner-junit5"})
public final class JUnitTestEngineListener
implements TestEngineListener {
    private final Map<Description, TestDescriptor> descriptors;
    private final Set<KClass<? extends Spec>> failedSpecs;
    private Throwable exceptionThrowBySpec;
    private boolean hasVisibleTest;
    private boolean hasIgnoredTest;
    private final EngineExecutionListener listener;
    @NotNull
    private final EngineDescriptor root;

    public void engineStarted(@NotNull List<? extends KClass<? extends Spec>> classes) {
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        LoggerKt.log((String)("Engine started; classes=[" + classes + ']'));
        this.listener.executionStarted((TestDescriptor)this.root);
    }

    /*
     * WARNING - void declaration
     */
    public void engineFinished(@NotNull List<? extends Throwable> t) {
        TestExecutionResult testExecutionResult;
        Iterator iterator;
        block8: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(t, (String)"t");
            LoggerKt.log((String)("Engine finished; throwables=[" + CollectionsKt.joinToString$default((Iterable)t, (CharSequence)"\n", null, null, (int)0, null, (Function1)engineFinished.1.INSTANCE, (int)30, null) + ']'));
            if (ConfigurationKt.getConfiguration().getWriteSpecFailureFile()) {
                WriteSpecFailuresKt.writeSpecFailures(this.failedSpecs, (String)ConfigurationKt.getConfiguration().getSpecFailureFilePath());
            }
            Iterable $this$map$iv = t;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TestExecutionResult testExecutionResult2;
                TestDescriptor container;
                void it;
                Throwable throwable = (Throwable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var12_14 = it;
                if (var12_14 instanceof AfterProjectListenerException) {
                    container = this.createAndRegisterTest(((AfterProjectListenerException)it).getName());
                    this.listener.executionStarted(container);
                    this.listener.executionFinished(container, TestExecutionResult.failed((Throwable)it));
                    testExecutionResult2 = TestExecutionResult.successful();
                } else if (var12_14 instanceof BeforeProjectListenerException) {
                    container = this.createAndRegisterTest(((BeforeProjectListenerException)it).getName());
                    this.listener.executionStarted(container);
                    this.listener.executionFinished(container, TestExecutionResult.failed((Throwable)it));
                    testExecutionResult2 = TestExecutionResult.successful();
                } else {
                    testExecutionResult2 = TestExecutionResult.failed((Throwable)it);
                }
                TestExecutionResult testExecutionResult3 = testExecutionResult2;
                collection.add(testExecutionResult3);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            boolean bl = false;
            iterable = iterable2;
            boolean bl2 = false;
            for (Iterator iterator2 : iterable) {
                TestExecutionResult it = (TestExecutionResult)iterator2;
                boolean bl3 = false;
                TestExecutionResult testExecutionResult4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)testExecutionResult4, (String)"it");
                if (!(testExecutionResult4.getStatus() == TestExecutionResult.Status.FAILED)) continue;
                iterator = iterator2;
                break block8;
            }
            iterator = null;
        }
        if ((testExecutionResult = (TestExecutionResult)iterator) == null) {
            testExecutionResult = ConfigurationKt.getConfiguration().getFailOnIgnoredTests() && this.hasIgnoredTest ? TestExecutionResult.failed((Throwable)new RuntimeException("Build contained ignored test")) : TestExecutionResult.successful();
        }
        TestExecutionResult result = testExecutionResult;
        LoggerKt.log((String)("Notifying junit that root descriptor completed " + this.root));
        this.listener.executionFinished((TestDescriptor)this.root, result);
    }

    public void specStarted(@NotNull KClass<? extends Spec> kclass) {
        Intrinsics.checkParameterIsNotNull(kclass, (String)"kclass");
        LoggerKt.log((String)("specStarted [" + kclass.getQualifiedName() + ']'));
        this.hasVisibleTest = false;
        this.hasIgnoredTest = false;
        try {
            TestDescriptor descriptor2 = DescriptorsKt.descriptor(kclass, (TestDescriptor)this.root);
            this.descriptors.put((Description)DescriptionKt.toDescription(kclass), descriptor2);
            LoggerKt.log((String)("Registering junit dynamic test and notifiying start: " + descriptor2));
            this.listener.dynamicTestRegistered(descriptor2);
            this.listener.executionStarted(descriptor2);
        }
        catch (Throwable t) {
            LoggerKt.log((String)"Error in JUnit Platform listener", (Throwable)t);
            this.exceptionThrowBySpec = t;
        }
    }

    public void specFinished(@NotNull KClass<? extends Spec> kclass, @Nullable Throwable t, @NotNull Map<TestCase, TestResult> results) {
        Intrinsics.checkParameterIsNotNull(kclass, (String)"kclass");
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        LoggerKt.log((String)("specFinished [" + kclass + ']'));
        TestDescriptor testDescriptor = this.descriptors.get(DescriptionKt.toDescription(kclass));
        if (testDescriptor == null) {
            throw (Throwable)new RuntimeException("Error retrieving description for spec: " + kclass.getQualifiedName());
        }
        TestDescriptor descriptor2 = testDescriptor;
        Throwable throwable = this.exceptionThrowBySpec;
        if (throwable == null) {
            throwable = t;
        }
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Throwable $this$apply = throwable2;
            boolean bl3 = false;
            this.ensureSpecIsVisible(kclass, $this$apply);
        }
        TestExecutionResult result = t != null ? TestExecutionResult.failed((Throwable)t) : (this.exceptionThrowBySpec != null ? TestExecutionResult.failed((Throwable)this.exceptionThrowBySpec) : TestExecutionResult.successful());
        LoggerKt.log((String)("Notifying junit that a spec has finished [" + descriptor2 + ", " + result + ']'));
        this.listener.executionFinished(descriptor2, result);
    }

    public void specInstantiationError(@NotNull KClass<? extends Spec> kclass, @NotNull Throwable t) {
        Intrinsics.checkParameterIsNotNull(kclass, (String)"kclass");
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        this.exceptionThrowBySpec = t;
    }

    private final void ensureSpecIsVisible(KClass<? extends Spec> kclass, Throwable t) {
        if (!this.hasVisibleTest) {
            Description.Spec description = DescriptionKt.toDescription(kclass);
            TestDescriptor testDescriptor = this.descriptors.get(description);
            if (testDescriptor == null) {
                Intrinsics.throwNpe();
            }
            TestDescriptor spec = testDescriptor;
            TestDescriptor test = DescriptorsKt.append(spec, (Description)description.append(DescriptionNameKt.createTestName((String)"Spec execution failed"), TestType.Test), TestDescriptor.Type.TEST, null, (Segment)Segment.Test.INSTANCE);
            this.listener.dynamicTestRegistered(test);
            this.listener.executionStarted(test);
            this.listener.executionFinished(test, TestExecutionResult.aborted((Throwable)t));
        }
    }

    public void testStarted(@NotNull TestCase testCase) {
        Intrinsics.checkParameterIsNotNull((Object)testCase, (String)"testCase");
        TestDescriptor descriptor2 = this.createTestDescriptor(testCase);
        LoggerKt.log((String)("Registering junit dynamic test: " + descriptor2));
        this.listener.dynamicTestRegistered(descriptor2);
        LoggerKt.log((String)("Notifying junit that execution has started: " + descriptor2));
        this.listener.executionStarted(descriptor2);
        this.hasVisibleTest = true;
    }

    public void testFinished(@NotNull TestCase testCase, @NotNull TestResult result) {
        Intrinsics.checkParameterIsNotNull((Object)testCase, (String)"testCase");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        TestDescriptor testDescriptor = this.descriptors.get(testCase.getDescription());
        if (testDescriptor == null) {
            throw (Throwable)new RuntimeException("Error retrieving description for: " + testCase.getDescription());
        }
        TestDescriptor descriptor2 = testDescriptor;
        LoggerKt.log((String)("Notifying junit that a test has finished [" + descriptor2 + ']'));
        this.listener.executionFinished(descriptor2, this.testExecutionResult(result));
    }

    public void testIgnored(@NotNull TestCase testCase, @Nullable String reason) {
        Intrinsics.checkParameterIsNotNull((Object)testCase, (String)"testCase");
        TestDescriptor descriptor2 = this.createTestDescriptor(testCase);
        this.hasIgnoredTest = true;
        LoggerKt.log((String)("Notifying junit that a test was ignored [" + descriptor2 + ']'));
        this.listener.dynamicTestRegistered(descriptor2);
        this.listener.executionSkipped(descriptor2, reason);
    }

    private final TestDescriptor createAndRegisterTest(String name) {
        TestDescriptor descriptor2 = DescriptorsKt.append((TestDescriptor)this.root, name, TestDescriptor.Type.TEST, null, (Segment)Segment.Spec.INSTANCE);
        this.listener.dynamicTestRegistered(descriptor2);
        return descriptor2;
    }

    private final TestDescriptor createTestDescriptor(TestCase testCase) {
        TestDescriptor parent = this.descriptors.get(testCase.getDescription().getParent());
        if (parent == null) {
            String msg = "Cannot find parent description for: " + testCase.getDescription();
            LoggerKt.log((String)msg);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(msg.toString());
        }
        TestDescriptor descriptor2 = DescriptorsKt.descriptor(parent, testCase);
        this.descriptors.put((Description)testCase.getDescription(), descriptor2);
        return descriptor2;
    }

    private final TestExecutionResult testExecutionResult(TestResult $this$testExecutionResult) {
        TestExecutionResult testExecutionResult;
        switch (JUnitTestEngineListener$WhenMappings.$EnumSwitchMapping$0[$this$testExecutionResult.getStatus().ordinal()]) {
            case 1: {
                String string = "An ignored test cannot reach this state";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 2: {
                TestExecutionResult testExecutionResult2 = TestExecutionResult.successful();
                testExecutionResult = testExecutionResult2;
                Intrinsics.checkExpressionValueIsNotNull((Object)testExecutionResult2, (String)"TestExecutionResult.successful()");
                break;
            }
            case 3: {
                TestExecutionResult testExecutionResult3 = TestExecutionResult.failed((Throwable)$this$testExecutionResult.getError());
                testExecutionResult = testExecutionResult3;
                Intrinsics.checkExpressionValueIsNotNull((Object)testExecutionResult3, (String)"TestExecutionResult.failed(this.error)");
                break;
            }
            case 4: {
                TestExecutionResult testExecutionResult4 = TestExecutionResult.failed((Throwable)$this$testExecutionResult.getError());
                testExecutionResult = testExecutionResult4;
                Intrinsics.checkExpressionValueIsNotNull((Object)testExecutionResult4, (String)"TestExecutionResult.failed(this.error)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return testExecutionResult;
    }

    @NotNull
    public final EngineDescriptor getRoot() {
        return this.root;
    }

    public JUnitTestEngineListener(@NotNull EngineExecutionListener listener, @NotNull EngineDescriptor root) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.listener = listener;
        this.root = root;
        boolean bl = false;
        this.descriptors = new LinkedHashMap();
        bl = false;
        this.failedSpecs = new LinkedHashSet();
    }

    public void specInstantiated(@NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestEngineListener.DefaultImpls.specInstantiated((TestEngineListener)this, (Spec)spec);
    }
}

