/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers;

import io.kotlintest.Matcher;
import io.kotlintest.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u0003\u001a%\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0005\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u0006\u001a1\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00030\t\"\u0002H\u0003\u00a2\u0006\u0002\u0010\n\u001a&\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u000b\u001a3\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00030\t\"\u0002H\u0003H\u0007\u00a2\u0006\u0002\u0010\n\u001a(\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u000bH\u0007\u001a;\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u000b0\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u000e2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00030\t\"\u0002H\u0003\u00a2\u0006\u0002\u0010\u000f\u001a0\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u000b0\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00030\u000b\u001a%\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0005\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u0006\u001a \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0013\u001a\u00020\u0014\u001a \u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0013\u001a\u00020\u0014\u001a%\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0005\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u0006\u001a\"\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u000b0\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u000e\u00a8\u0006\u0018"}, d2={"beEmpty", "Lio/kotlintest/Matcher;", "", "T", "contain", "t", "(Ljava/lang/Object;)Lio/kotlintest/Matcher;", "containAll", "ts", "", "([Ljava/lang/Object;)Lio/kotlintest/Matcher;", "", "containsAll", "containsInOrder", "", "([Ljava/lang/Comparable;)Lio/kotlintest/Matcher;", "expected", "containsMatcher", "haveSize", "size", "", "haveSizeMatcher", "singleElement", "sorted", "kotlintest-assertions"})
public final class CollectionMatchersKt {
    @NotNull
    public static final <T> Matcher<Collection<T>> haveSizeMatcher(int size) {
        return new Matcher<Collection<? extends T>>(size){
            final /* synthetic */ int $size;

            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                return new Result(value.size() == this.$size, "Collection should have size " + this.$size + " but has size " + value.size(), "Collection should not have size " + this.$size);
            }
            {
                this.$size = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> containsMatcher(T t) {
        return new Matcher<Collection<? extends T>>(t){
            final /* synthetic */ Object $t;

            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                return new Result(value.contains(this.$t), "Collection should contain element " + this.$t, "Collection should not contain element " + this.$t);
            }
            {
                this.$t = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> beEmpty() {
        return new Matcher<Collection<? extends T>>(){

            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                return new Result(value.isEmpty(), "Collection should be empty", "Collection should not be empty");
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @Deprecated(message="use containAll", replaceWith=@ReplaceWith(imports={}, expression="containsAll(ts.asList())"))
    @NotNull
    public static final <T> Matcher<Collection<T>> containsAll(T ... ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return CollectionMatchersKt.containAll(ArraysKt.asList((Object[])ts));
    }

    @Deprecated(message="use containAll", replaceWith=@ReplaceWith(imports={}, expression="containAll(ts)"))
    @NotNull
    public static final <T> Matcher<Collection<T>> containsAll(@NotNull List<? extends T> ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return CollectionMatchersKt.containAll(ts);
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> containAll(T ... ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return CollectionMatchersKt.containAll(ArraysKt.asList((Object[])ts));
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> containAll(@NotNull List<? extends T> ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return new Matcher<Collection<? extends T>>(ts){
            final /* synthetic */ List $ts;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                boolean bl;
                Result result;
                Result result2;
                block3: {
                    void $receiver$iv;
                    Result result3;
                    Intrinsics.checkParameterIsNotNull(value, (String)"value");
                    Iterable iterable = this.$ts;
                    result2 = result3;
                    result = result3;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            T it = element$iv;
                            if (value.contains(it)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                boolean bl2 = bl;
                result2(bl2, "Collection should contain all of " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)this.$ts, (int)10), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), "Collection should not contain all of " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)this.$ts, (int)10), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                return result;
            }
            {
                this.$ts = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<T>> containsInOrder(T ... ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return CollectionMatchersKt.containsInOrder(ArraysKt.asList((Object[])ts));
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<T>> containsInOrder(@NotNull List<? extends T> expected) {
        Intrinsics.checkParameterIsNotNull(expected, (String)"expected");
        return new Matcher<List<? extends T>>(expected){
            final /* synthetic */ List $expected;

            @NotNull
            public Result test(@NotNull List<? extends T> value) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                Collection collection = this.$expected;
                boolean bl2 = bl = !collection.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "expected values must not be empty";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                bl = Intrinsics.areEqual((Object)CollectionsKt.sorted((Iterable)this.$expected), (Object)this.$expected);
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "expected values must be sorted but was " + this.$expected;
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                int cursor = 0;
                boolean passed = true;
                Iterable $receiver$iv = this.$expected;
                for (T element$iv : $receiver$iv) {
                    IndexedValue it;
                    Iterable $receiver$iv$iv;
                    Comparable expected = (Comparable)element$iv;
                    Iterable $receiver$iv2 = CollectionsKt.withIndex((Iterable)value);
                    Iterable iterable = $receiver$iv2;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        it = (IndexedValue)element$iv$iv;
                        if (!Intrinsics.areEqual((Object)((Comparable)it.getValue()), (Object)expected)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv2 = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv2;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        it = (IndexedValue)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        Integer n = it.getIndex();
                        collection2.add(n);
                    }
                    List indexes = (List)destination$iv$iv;
                    if (indexes.isEmpty()) {
                        passed = false;
                    }
                    $receiver$iv2 = indexes;
                    for (E element$iv2 : $receiver$iv2) {
                        int it2 = ((Number)element$iv2).intValue();
                        if (passed && it2 < cursor) {
                            passed = false;
                            continue;
                        }
                        Comparable comparable = CollectionsKt.max((Iterable)indexes);
                        if (comparable == null) {
                            Intrinsics.throwNpe();
                        }
                        cursor = ((Number)((Object)comparable)).intValue();
                    }
                }
                String failureMessage = "" + '[' + value + "] did not contain the same elements in order as [" + this.$expected + ']';
                String negatedFailureMessage = "" + '[' + value + "] should not contain the same elements in order as [" + this.$expected + ']';
                return new Result(passed, failureMessage, negatedFailureMessage);
            }
            {
                this.$expected = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<List<T>> and(@NotNull Matcher<List<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<List<T>> or(@NotNull Matcher<List<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> haveSize(int size) {
        return CollectionMatchersKt.haveSizeMatcher(size);
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> contain(T t) {
        return CollectionMatchersKt.containsMatcher(t);
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> singleElement(T t) {
        return new Matcher<Collection<? extends T>>(t){
            final /* synthetic */ Object $t;

            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                return new Result(value.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)value), (Object)this.$t), "Collection should be a single element of " + this.$t + " but has " + value.size() + " elements", "Collection should not be a single element of " + this.$t);
            }
            {
                this.$t = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<T>> sorted() {
        return new Matcher<List<? extends T>>(){

            @NotNull
            public Result test(@NotNull List<? extends T> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                boolean passed = Intrinsics.areEqual((Object)CollectionsKt.sorted((Iterable)value), value);
                String snippet = value.size() <= 10 ? CollectionsKt.joinToString$default((Iterable)value, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)value, (int)10), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "...";
                return new Result(passed, "Collection " + snippet + " should be sorted", "Colelction " + snippet + " should not be sorted");
            }

            @NotNull
            public Matcher<List<T>> and(@NotNull Matcher<List<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<List<T>> or(@NotNull Matcher<List<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }
}

