/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers.string;

import io.kotlintest.Matcher;
import io.kotlintest.Result;
import io.kotlintest.matchers.string.MatchersKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\u001a\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u00a8\u0006\u0011"}, d2={"beBlank", "Lio/kotlintest/Matcher;", "", "beEmpty", "beLowerCase", "beUpperCase", "contain", "substr", "containADigit", "containIgnoringCase", "substring", "containOnlyDigits", "containOnlyOnce", "containOnlyWhitespace", "haveSameLengthAs", "other", "include", "kotlintest-assertions"})
public final class MatchersKt {
    @NotNull
    public static final Matcher<String> containOnlyDigits() {
        return new Matcher<String>(){

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                boolean passed2 = value.chars().allMatch(containOnlyDigits.test.passed.1.INSTANCE);
                return new Result(passed2, "String " + value + " should contain only digits", "String " + value + " should not contain only digits");
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> containADigit() {
        return new Matcher<String>(){

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                boolean passed2 = value.chars().anyMatch(containADigit.test.passed.1.INSTANCE);
                return new Result(passed2, "String " + value + " should contain at least one digits", "String " + value + " should not contain any digits");
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> containOnlyOnce(@NotNull String substring) {
        Intrinsics.checkParameterIsNotNull((Object)substring, (String)"substring");
        return new Matcher<String>(substring){
            final /* synthetic */ String $substring;

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                boolean passed2 = StringsKt.indexOf$default((CharSequence)value, (String)this.$substring, (int)0, (boolean)false, (int)6, null) == StringsKt.lastIndexOf$default((CharSequence)value, (String)this.$substring, (int)0, (boolean)false, (int)6, null);
                return new Result(passed2, "String " + value + " should contain the substring " + this.$substring + " only once", "String " + value + " should not contain the substring " + this.$substring + " exactly once");
            }
            {
                this.$substring = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> beLowerCase() {
        return new Matcher<String>(){

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                String string2 = value;
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                boolean passed2 = Intrinsics.areEqual((Object)string3, (Object)value);
                return new Result(passed2, "String " + value + " should be lower case", "String " + value + " should not should be lower case");
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> beUpperCase() {
        return new Matcher<String>(){

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                String string2 = value;
                String string3 = string2.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                boolean passed2 = Intrinsics.areEqual((Object)string3, (Object)value);
                return new Result(passed2, "String " + value + " should be upper case", "String " + value + " should not should be upper case");
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> beEmpty() {
        return new Matcher<String>(){

            @NotNull
            public Result test(@NotNull String value) {
                Result result;
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                CharSequence charSequence = value;
                Result result2 = result;
                Result result3 = result;
                boolean bl = charSequence.length() == 0;
                result2(bl, "String " + value + " should be empty", "String " + value + " should not be empty");
                return result3;
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> haveSameLengthAs(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Matcher<String>(other){
            final /* synthetic */ String $other;

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Result(value.length() == this.$other.length(), "String " + value + " should have the same length as " + this.$other, "String " + value + " should not have the same length as " + this.$other);
            }
            {
                this.$other = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> containOnlyWhitespace() {
        return MatchersKt.beBlank();
    }

    @NotNull
    public static final Matcher<String> beBlank() {
        return new Matcher<String>(){

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Result(StringsKt.isBlank((CharSequence)value), "String " + value + " should contain only whitespace", "String " + value + " should not contain only whitespace");
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> containIgnoringCase(@NotNull String substring) {
        Intrinsics.checkParameterIsNotNull((Object)substring, (String)"substring");
        return new Matcher<String>(substring){
            final /* synthetic */ String $substring;

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                String string2 = value;
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                string2 = this.$substring;
                CharSequence charSequence = string3;
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                String string6 = string5;
                boolean passed2 = StringsKt.indexOf$default((CharSequence)charSequence, (String)string6, (int)0, (boolean)false, (int)6, null) >= 0;
                return new Result(passed2, "String " + value + " should contain the substring " + this.$substring + " (case insensitive)", "String " + value + " should not contain the substring " + this.$substring + " (case insensitive)");
            }
            {
                this.$substring = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> contain(@NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        return MatchersKt.include(substr);
    }

    @NotNull
    public static final Matcher<String> include(@NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        return new Matcher<String>(substr){
            final /* synthetic */ String $substr;

            @NotNull
            public Result test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Result(StringsKt.contains$default((CharSequence)value, (CharSequence)this.$substr, (boolean)false, (int)2, null), "String " + value + " should include substring " + this.$substr, "String " + value + " should not include substring " + this.$substr);
            }
            {
                this.$substr = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }
}

