/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers;

import io.kotlintest.Matcher;
import io.kotlintest.Result;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0002H\u0086\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\r"}, d2={"Lio/kotlintest/matchers/FloatToleranceMatcher;", "Lio/kotlintest/Matcher;", "", "expected", "tolerance", "(FF)V", "getExpected", "()F", "getTolerance", "plusOrMinus", "test", "Lio/kotlintest/Result;", "value", "kotlintest-assertions"})
public final class FloatToleranceMatcher
implements Matcher<Float> {
    private final float expected;
    private final float tolerance;

    @Override
    @NotNull
    public Result test(float value) {
        Result result;
        if (FloatCompanionObject.INSTANCE.getNaN() == this.expected && FloatCompanionObject.INSTANCE.getNaN() == value) {
            String string2 = "[WARN] By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
            System.out.println((Object)string2);
            result = new Result(false, "By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776", "By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
        } else {
            float diff;
            if (this.tolerance == 0.0f) {
                String string3 = "[WARN] When comparing Float consider using tolerance, eg: a shouldBe b plusOrMinus c";
                System.out.println((Object)string3);
            }
            result = new Result((diff = Math.abs(value - this.expected)) <= this.tolerance, "" + value + " should be equal to " + this.expected, "" + value + " should not be equal to " + this.expected);
        }
        return result;
    }

    @NotNull
    public final FloatToleranceMatcher plusOrMinus(float tolerance) {
        return new FloatToleranceMatcher(this.expected, tolerance);
    }

    public final float getExpected() {
        return this.expected;
    }

    public final float getTolerance() {
        return this.tolerance;
    }

    public FloatToleranceMatcher(float expected, float tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @Override
    @NotNull
    public Matcher<Float> invert() {
        return Matcher.DefaultImpls.invert(this);
    }

    @Override
    @NotNull
    public <U> Matcher<U> compose(@NotNull Function1<? super U, Float> fn) {
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        return Matcher.DefaultImpls.compose(this, fn);
    }

    @Override
    @NotNull
    public Matcher<Float> and(@NotNull Matcher<Float> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return Matcher.DefaultImpls.and(this, other);
    }

    @Override
    @NotNull
    public Matcher<Float> or(@NotNull Matcher<Float> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return Matcher.DefaultImpls.or(this, other);
    }
}

