/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers;

import io.kotlintest.Matcher;
import io.kotlintest.Result;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0002H\u0086\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/kotlintest/matchers/ToleranceMatcher;", "Lio/kotlintest/Matcher;", "", "expected", "tolerance", "(DD)V", "plusOrMinus", "test", "Lio/kotlintest/Result;", "value", "kotlintest-assertions"})
public final class ToleranceMatcher
implements Matcher<Double> {
    private final double expected;
    private final double tolerance;

    @Override
    @NotNull
    public Result test(double value) {
        Result result;
        if (DoubleCompanionObject.INSTANCE.getNaN() == this.expected && DoubleCompanionObject.INSTANCE.getNaN() == value) {
            String string2 = "[WARN] By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
            System.out.println((Object)string2);
            result = new Result(false, "By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776", "By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
        } else {
            double diff;
            if (this.tolerance == 0.0) {
                String string3 = "[WARN] When comparing doubles consider using tolerance, eg: a shouldBe (b plusOrMinus c)";
                System.out.println((Object)string3);
            }
            result = new Result((diff = Math.abs(value - this.expected)) <= this.tolerance, "" + value + " should be equal to " + this.expected, "" + value + " should not be equal to " + this.expected);
        }
        return result;
    }

    @NotNull
    public final ToleranceMatcher plusOrMinus(double tolerance) {
        return new ToleranceMatcher(this.expected, tolerance);
    }

    public ToleranceMatcher(double expected, double tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @Override
    @NotNull
    public Matcher<Double> invert() {
        return Matcher.DefaultImpls.invert(this);
    }

    @Override
    @NotNull
    public <U> Matcher<U> compose(@NotNull Function1<? super U, Double> fn) {
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        return Matcher.DefaultImpls.compose(this, fn);
    }

    @Override
    @NotNull
    public Matcher<Double> and(@NotNull Matcher<Double> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return Matcher.DefaultImpls.and(this, other);
    }

    @Override
    @NotNull
    public Matcher<Double> or(@NotNull Matcher<Double> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return Matcher.DefaultImpls.or(this, other);
    }
}

