/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers;

import io.kotlintest.Matcher;
import io.kotlintest.Result;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003H\u0086\b\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00030\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u001a\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003H\u0086\b\u001a\u001f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\b\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a8\u0006\u000b"}, d2={"beInstanceOf", "Lio/kotlintest/Matcher;", "T", "", "expected", "Lkotlin/reflect/KClass;", "beOfType", "beTheSameInstanceAs", "ref", "(Ljava/lang/Object;)Lio/kotlintest/Matcher;", "instanceOf", "kotlintest-assertions"})
public final class TypeMatchersKt {
    @NotNull
    public static final Matcher<Object> instanceOf(@NotNull KClass<?> expected) {
        Intrinsics.checkParameterIsNotNull(expected, (String)"expected");
        return TypeMatchersKt.beInstanceOf(expected);
    }

    @NotNull
    public static final Matcher<Object> beInstanceOf(@NotNull KClass<?> expected) {
        Intrinsics.checkParameterIsNotNull(expected, (String)"expected");
        return new Matcher<Object>(expected){
            final /* synthetic */ KClass $expected;

            @NotNull
            public Result test(@NotNull Object value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Result(JvmClassMappingKt.getJavaClass((KClass)this.$expected).isAssignableFrom(value.getClass()), "" + value + " is of type " + value.getClass() + " but expected " + this.$expected, "" + value + " should not be of type " + this.$expected);
            }
            {
                this.$expected = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Object> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Object> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<Object> and(@NotNull Matcher<Object> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Object> or(@NotNull Matcher<Object> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<T> beTheSameInstanceAs(T ref) {
        return new Matcher<T>(ref){
            final /* synthetic */ Object $ref;

            @NotNull
            public Result test(T value) {
                return new Result(value == this.$ref, "" + value + " should be the same reference as " + this.$ref, "" + value + " should not be the same reference as " + this.$ref);
            }
            {
                this.$ref = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<T> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends T> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<T> and(@NotNull Matcher<T> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<T> or(@NotNull Matcher<T> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    private static final <T> Matcher<T> beInstanceOf() {
        Intrinsics.needClassReification();
        return new Matcher<T>(){

            @NotNull
            public Result test(@NotNull T value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                boolean bl = Object.class.isAssignableFrom(value.getClass());
                StringBuilder stringBuilder = new StringBuilder().append("").append(value).append(" is of type ").append(value.getClass()).append(" but expected ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string2 = stringBuilder.append(Object.class.getCanonicalName()).toString();
                StringBuilder stringBuilder2 = new StringBuilder().append("").append(value).append(" should not be an instance of ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Result(bl, string2, stringBuilder2.append(Object.class.getCanonicalName()).toString());
            }

            @NotNull
            public Matcher<T> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends T> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<T> and(@NotNull Matcher<T> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<T> or(@NotNull Matcher<T> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    private static final <T> Matcher<Object> beOfType() {
        Intrinsics.needClassReification();
        return new Matcher<Object>(){
            @Nullable
            private final String className;

            @Nullable
            public final String getClassName() {
                return this.className;
            }

            @NotNull
            public Result test(@NotNull Object value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Class<?> clazz = value.getClass();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Result(Intrinsics.areEqual(clazz, Object.class), "" + value + " should be of type " + this.className, "" + value + " should not be of type " + this.className);
            }
            {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                this.className = Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName();
            }

            @NotNull
            public Matcher<Object> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Object> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<Object> and(@NotNull Matcher<Object> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Object> or(@NotNull Matcher<Object> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }
}

