package io.kotlintest.matchers.doubles

import io.kotlintest.Matcher
import io.kotlintest.Result
import io.kotlintest.matchers.between
import io.kotlintest.matchers.exactly
import io.kotlintest.shouldBe
import io.kotlintest.shouldNotBe

infix fun Double.shouldBeExactly(other: Double) = this shouldBe exactly(other)
infix fun Double.shouldNotBeExactly(other: Double) = this shouldNotBe exactly(other)
fun Double.shouldBeBetween(a: Double, b: Double, tolerance: Double) = this shouldBe between(a, b, tolerance)
fun Double.shouldNotBeBetween(a: Double, b: Double, tolerance: Double) = this shouldNotBe between(a, b, tolerance)

infix fun Double.shouldBeLessThan(x: Double) = this shouldBe lt(x)
infix fun Double.shouldNotBeLessThan(x: Double) = this shouldNotBe lt(x)
fun lt(x: Double) = beLessThan(x)
fun beLessThan(x: Double) = object : Matcher<Double> {
  override fun test(value: Double) = Result(value < x, "$value should be < $x", "$value should not be < $x")
}

fun Double.shouldBePositive() = this shouldBe positive()
fun Double.shouldNotBePositive() = this shouldNotBe positive()
fun positive() = object : Matcher<Double> {
  override fun test(value: Double) = Result(value > 0.0, "$value should be > 0.0", "$value should not be > 0.0")
}

fun Double.shouldBeNegative() = this shouldBe negative()
fun Double.shouldNotBeNegative() = this shouldNotBe negative()
fun negative() = object : Matcher<Double> {
  override fun test(value: Double) = Result(value < 0.0, "$value should be < 0.0", "$value should not be < 0.0")
}

infix fun Double.shouldBeLessThanOrEqual(x: Double) = this shouldBe lte(x)
infix fun Double.shouldNotBeLessThanOrEqual(x: Double) = this shouldNotBe lte(x)
fun lte(x: Double) = beLessThanOrEqualTo(x)
fun beLessThanOrEqualTo(x: Double) = object : Matcher<Double> {
  override fun test(value: Double) = Result(value <= x, "$value should be <= $x", "$value should not be <= $x")
}

infix fun Double.shouldBeGreaterThan(x: Double) = this shouldBe gt(x)
infix fun Double.shouldNotBeGreaterThan(x: Double) = this shouldNotBe gt(x)
fun gt(x: Double) = beGreaterThan(x)
fun beGreaterThan(x: Double) = object : Matcher<Double> {
  override fun test(value: Double) = Result(value > x, "$value should be > $x", "$value should not be > $x")
}

infix fun Double.shouldBeGreaterThanOrEqual(x: Double) = this shouldBe gte(x)
infix fun Double.shouldNotBeGreaterThanOrEqual(x: Double) = this shouldNotBe gte(x)
fun gte(x: Double) = beGreaterThanOrEqualTo(x)
fun beGreaterThanOrEqualTo(x: Double) = object : Matcher<Double> {
  override fun test(value: Double) = Result(value >= x, "$value should be >= $x", "$value should not be >= $x")
}
