/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers.types;

import io.kotlintest.DslKt;
import io.kotlintest.Matcher;
import io.kotlintest.Result;
import io.kotlintest.matchers.TypeMatchersKt;
import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u001a5\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0002H\u0087\b\u001a\u0019\u0010\u0007\u001a\u00020\b\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\t*\u00020\tH\u0086\b\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u001a\u0019\u0010\f\u001a\u00020\b\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\t*\u00020\tH\u0086\b\u001a3\u0010\r\u001a\u00020\b\"\u0004\b\u0000\u0010\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00030\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0002H\u0086\b\u001a\u0019\u0010\u000e\u001a\u00020\b\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\t*\u00020\tH\u0086\b\u001a\u0012\u0010\u000f\u001a\u00020\b*\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u001a\u0019\u0010\u0010\u001a\u00020\b\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\t*\u00020\tH\u0086\b\u00a8\u0006\u0011"}, d2={"haveAnnotation", "Lio/kotlintest/Matcher;", "Ljava/lang/Class;", "A", "T", "", "klass", "shouldBeInstanceOf", "", "", "shouldBeSameInstanceAs", "ref", "shouldBeTypeOf", "shouldHaveAnnotation", "shouldNotBeInstanceOf", "shouldNotBeSameInstanceAs", "shouldNotBeTypeOf", "kotlintest-assertions"})
public final class MatchersKt {
    private static final <T> void shouldBeInstanceOf(@NotNull Object $receiver) {
        Intrinsics.needClassReification();
        Matcher matcher = new Matcher<T>(){

            @NotNull
            public Result test(@NotNull T value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                boolean bl = Object.class.isAssignableFrom(value.getClass());
                StringBuilder stringBuilder = new StringBuilder().append("").append(value).append(" is of type ").append(value.getClass()).append(" but expected ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string2 = stringBuilder.append(Object.class.getCanonicalName()).toString();
                StringBuilder stringBuilder2 = new StringBuilder().append("").append(value).append(" should not be an instance of ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Result(bl, string2, stringBuilder2.append(Object.class.getCanonicalName()).toString());
            }

            @NotNull
            public Matcher<T> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends T> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<T> and(@NotNull Matcher<T> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<T> or(@NotNull Matcher<T> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
        DslKt.shouldBe($receiver, matcher);
    }

    private static final <T> void shouldNotBeInstanceOf(@NotNull Object $receiver) {
        Intrinsics.needClassReification();
        Matcher matcher = new Matcher<T>(){

            @NotNull
            public Result test(@NotNull T value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                boolean bl = Object.class.isAssignableFrom(value.getClass());
                StringBuilder stringBuilder = new StringBuilder().append("").append(value).append(" is of type ").append(value.getClass()).append(" but expected ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string2 = stringBuilder.append(Object.class.getCanonicalName()).toString();
                StringBuilder stringBuilder2 = new StringBuilder().append("").append(value).append(" should not be an instance of ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Result(bl, string2, stringBuilder2.append(Object.class.getCanonicalName()).toString());
            }

            @NotNull
            public Matcher<T> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends T> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<T> and(@NotNull Matcher<T> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<T> or(@NotNull Matcher<T> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
        DslKt.shouldNotBe($receiver, matcher);
    }

    private static final <T> void shouldBeTypeOf(@NotNull Object $receiver) {
        Intrinsics.needClassReification();
        Matcher matcher = new Matcher<Object>(){
            @Nullable
            private final String className;
            {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                this.className = Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName();
            }

            @Nullable
            public final String getClassName() {
                return this.className;
            }

            @NotNull
            public Result test(@NotNull Object value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Class<?> clazz = value.getClass();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Result(Intrinsics.areEqual(clazz, Object.class), "" + value + " should be of type " + this.className, "" + value + " should not be of type " + this.className);
            }

            @NotNull
            public Matcher<Object> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Object> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<Object> and(@NotNull Matcher<Object> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Object> or(@NotNull Matcher<Object> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
        DslKt.shouldBe($receiver, matcher);
    }

    private static final <T> void shouldNotBeTypeOf(@NotNull Object $receiver) {
        Intrinsics.needClassReification();
        Matcher matcher = new Matcher<Object>(){
            @Nullable
            private final String className;
            {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                this.className = Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName();
            }

            @Nullable
            public final String getClassName() {
                return this.className;
            }

            @NotNull
            public Result test(@NotNull Object value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Class<?> clazz = value.getClass();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Result(Intrinsics.areEqual(clazz, Object.class), "" + value + " should be of type " + this.className, "" + value + " should not be of type " + this.className);
            }

            @NotNull
            public Matcher<Object> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Object> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<Object> and(@NotNull Matcher<Object> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Object> or(@NotNull Matcher<Object> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
        DslKt.shouldNotBe($receiver, matcher);
    }

    public static final void shouldBeSameInstanceAs(@NotNull Object $receiver, @NotNull Object ref) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        DslKt.should($receiver, TypeMatchersKt.beTheSameInstanceAs(ref));
    }

    public static final void shouldNotBeSameInstanceAs(@NotNull Object $receiver, @NotNull Object ref) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        DslKt.shouldNotBe($receiver, TypeMatchersKt.beTheSameInstanceAs(ref));
    }

    private static final <A, T extends Annotation> void shouldHaveAnnotation(@NotNull Class<A> $receiver, Class<T> klass) {
        Class<A> clazz = $receiver;
        Intrinsics.needClassReification();
        Matcher matcher = new Matcher<Class<A>>(){
            @Nullable
            private final String className;
            {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                this.className = Reflection.getOrCreateKotlinClass(Annotation.class).getQualifiedName();
            }

            @Nullable
            public final String getClassName() {
                return this.className;
            }

            @NotNull
            public Result test(@NotNull Class<A> value) {
                boolean bl;
                block1: {
                    Intrinsics.checkParameterIsNotNull(value, (String)"value");
                    Annotation[] annotationArray = value.getAnnotations();
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotationArray, (String)"value.annotations");
                    for (Annotation element$iv : annotationArray) {
                        Annotation it = element$iv;
                        if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getAnnotationClass((Annotation)it).getQualifiedName(), (Object)this.className)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                boolean passed2 = bl;
                return new Result(passed2, "Class " + value + " should contain annotation " + this.className, "Class " + value + " should not contain annotation " + this.className);
            }

            @NotNull
            public Matcher<Class<A>> and(@NotNull Matcher<Class<A>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, Class<A>> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<Class<A>> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public Matcher<Class<A>> or(@NotNull Matcher<Class<A>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
        DslKt.should(clazz, matcher);
    }

    private static final <A, T extends Annotation> Matcher<Class<A>> haveAnnotation(Class<T> klass) {
        Intrinsics.needClassReification();
        return new Matcher<Class<A>>(){
            @Nullable
            private final String className;

            @Nullable
            public final String getClassName() {
                return this.className;
            }

            @NotNull
            public Result test(@NotNull Class<A> value) {
                boolean bl;
                block1: {
                    Intrinsics.checkParameterIsNotNull(value, (String)"value");
                    Annotation[] annotationArray = value.getAnnotations();
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotationArray, (String)"value.annotations");
                    for (Annotation element$iv : annotationArray) {
                        Annotation it = element$iv;
                        if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getAnnotationClass((Annotation)it).getQualifiedName(), (Object)this.className)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                boolean passed2 = bl;
                return new Result(passed2, "Class " + value + " should contain annotation " + this.className, "Class " + value + " should not contain annotation " + this.className);
            }
            {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                this.className = Reflection.getOrCreateKotlinClass(Annotation.class).getQualifiedName();
            }

            @NotNull
            public Matcher<Class<A>> and(@NotNull Matcher<Class<A>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, Class<A>> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn);
            }

            @NotNull
            public Matcher<Class<A>> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public Matcher<Class<A>> or(@NotNull Matcher<Class<A>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }
}

