/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

public class ComparisonCompactor {
    private static final int MAX_CONTEXT_LENGTH = 20;
    private static final String ELLIPSIS = "...";
    private static final String DIFF_END = "]";
    private static final String DIFF_START = "[";
    private final int contextLength;
    private final String expected;
    private final String actual;

    public static String getMessage(String expected, String actual) {
        return new ComparisonCompactor(20, expected, actual).compact();
    }

    private static String format(Object expected, Object actual) {
        String actualString;
        String expectedString = String.valueOf(expected);
        if (expectedString.equals(actualString = String.valueOf(actual))) {
            return "expected: " + ComparisonCompactor.formatClassAndValue(expected, expectedString) + " but was: " + ComparisonCompactor.formatClassAndValue(actual, actualString);
        }
        return "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    private ComparisonCompactor(int contextLength, String expected, String actual) {
        this.contextLength = contextLength;
        this.expected = expected;
        this.actual = actual;
    }

    private String compact() {
        if (this.expected == null || this.actual == null || this.expected.equals(this.actual)) {
            return ComparisonCompactor.format(this.expected, this.actual);
        }
        DiffExtractor extractor = new DiffExtractor();
        String compactedPrefix = extractor.compactPrefix();
        String compactedSuffix = extractor.compactSuffix();
        return ComparisonCompactor.format(compactedPrefix + extractor.expectedDiff() + compactedSuffix, compactedPrefix + extractor.actualDiff() + compactedSuffix);
    }

    private String sharedPrefix() {
        int end = Math.min(this.expected.length(), this.actual.length());
        for (int i = 0; i < end; ++i) {
            if (this.expected.charAt(i) == this.actual.charAt(i)) continue;
            return this.expected.substring(0, i);
        }
        return this.expected.substring(0, end);
    }

    private String sharedSuffix(String prefix) {
        int suffixLength;
        int maxSuffixLength = Math.min(this.expected.length() - prefix.length(), this.actual.length() - prefix.length()) - 1;
        for (suffixLength = 0; suffixLength <= maxSuffixLength && this.expected.charAt(this.expected.length() - 1 - suffixLength) == this.actual.charAt(this.actual.length() - 1 - suffixLength); ++suffixLength) {
        }
        return this.expected.substring(this.expected.length() - suffixLength);
    }

    private class DiffExtractor {
        private final String sharedPrefix;
        private final String sharedSuffix;

        private DiffExtractor() {
            this.sharedPrefix = ComparisonCompactor.this.sharedPrefix();
            this.sharedSuffix = ComparisonCompactor.this.sharedSuffix(this.sharedPrefix);
        }

        String expectedDiff() {
            return this.extractDiff(ComparisonCompactor.this.expected);
        }

        String actualDiff() {
            return this.extractDiff(ComparisonCompactor.this.actual);
        }

        String compactPrefix() {
            if (this.sharedPrefix.length() <= ComparisonCompactor.this.contextLength) {
                return this.sharedPrefix;
            }
            return ComparisonCompactor.ELLIPSIS + this.sharedPrefix.substring(this.sharedPrefix.length() - ComparisonCompactor.this.contextLength);
        }

        String compactSuffix() {
            if (this.sharedSuffix.length() <= ComparisonCompactor.this.contextLength) {
                return this.sharedSuffix;
            }
            return this.sharedSuffix.substring(0, ComparisonCompactor.this.contextLength) + ComparisonCompactor.ELLIPSIS;
        }

        private String extractDiff(String source) {
            return ComparisonCompactor.DIFF_START + source.substring(this.sharedPrefix.length(), source.length() - this.sharedSuffix.length()) + ComparisonCompactor.DIFF_END;
        }
    }
}

