/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers.concurrent;

import io.kotlintest.DslKt;
import io.kotlintest.Matcher;
import io.kotlintest.Result;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u001a\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0002\u00a8\u0006\u000f"}, d2={"beAlive", "Lio/kotlintest/Matcher;", "Ljava/lang/Thread;", "beBlocked", "beDaemon", "beTerminated", "shouldBeAlive", "", "shouldBeBlocked", "shouldBeDaemon", "shouldBeTerminated", "shouldNotBeAlive", "shouldNotBeBlocked", "shouldNotBeDaemon", "shouldNotBeTerminated", "kotlintest-assertions"})
public final class ThreadsKt {
    public static final void shouldBeBlocked(@NotNull Thread $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DslKt.should($receiver, ThreadsKt.beBlocked());
    }

    public static final void shouldNotBeBlocked(@NotNull Thread $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DslKt.shouldNot($receiver, ThreadsKt.beBlocked());
    }

    @NotNull
    public static final Matcher<Thread> beBlocked() {
        return new Matcher<Thread>(){

            @NotNull
            public Result test(@NotNull Thread value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Result(value.getState() == Thread.State.BLOCKED, "Thread " + value.getId() + " should be blocked", "Thread " + value.getId() + " should not be blocked");
            }

            @NotNull
            public Matcher<Thread> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Thread> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Thread> and(@NotNull Matcher<Thread> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Thread> or(@NotNull Matcher<Thread> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    public static final void shouldBeTerminated(@NotNull Thread $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DslKt.should($receiver, ThreadsKt.beTerminated());
    }

    public static final void shouldNotBeTerminated(@NotNull Thread $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DslKt.shouldNot($receiver, ThreadsKt.beTerminated());
    }

    @NotNull
    public static final Matcher<Thread> beTerminated() {
        return new Matcher<Thread>(){

            @NotNull
            public Result test(@NotNull Thread value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Result(value.getState() == Thread.State.TERMINATED, "Thread " + value.getId() + " should be terminated", "Thread " + value.getId() + " should not be terminated");
            }

            @NotNull
            public Matcher<Thread> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Thread> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Thread> and(@NotNull Matcher<Thread> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Thread> or(@NotNull Matcher<Thread> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    public static final void shouldBeAlive(@NotNull Thread $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DslKt.should($receiver, ThreadsKt.beAlive());
    }

    public static final void shouldNotBeAlive(@NotNull Thread $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DslKt.shouldNot($receiver, ThreadsKt.beAlive());
    }

    @NotNull
    public static final Matcher<Thread> beAlive() {
        return new Matcher<Thread>(){

            @NotNull
            public Result test(@NotNull Thread value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Result(value.isAlive(), "Thread " + value.getId() + " should be alive", "Thread " + value.getId() + " should not be alive");
            }

            @NotNull
            public Matcher<Thread> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Thread> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Thread> and(@NotNull Matcher<Thread> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Thread> or(@NotNull Matcher<Thread> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    public static final void shouldBeDaemon(@NotNull Thread $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DslKt.should($receiver, ThreadsKt.beDaemon());
    }

    public static final void shouldNotBeDaemon(@NotNull Thread $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DslKt.shouldNot($receiver, ThreadsKt.beDaemon());
    }

    @NotNull
    public static final Matcher<Thread> beDaemon() {
        return new Matcher<Thread>(){

            @NotNull
            public Result test(@NotNull Thread value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new Result(value.isDaemon(), "Thread " + value.getId() + " should be a daemon thread", "Thread " + value.getId() + " should not be a daemon thread");
            }

            @NotNull
            public Matcher<Thread> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Thread> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Thread> and(@NotNull Matcher<Thread> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Thread> or(@NotNull Matcher<Thread> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }
}

