/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers;

import io.kotlintest.DslKt;
import io.kotlintest.Matcher;
import io.kotlintest.NeverNullMatcher;
import io.kotlintest.Result;
import io.kotlintest.matchers.CollectionMatchersKt;
import io.kotlintest.matchers.collections.MatchersKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000f\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u0003\u001a\"\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00050\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0006\u001a'\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\b\u001a\u0002H\u0003H\u0007\u00a2\u0006\u0002\u0010\t\u001a1\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00030\f\"\u0002H\u0003\u00a2\u0006\u0002\u0010\r\u001a&\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0002\u001a3\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00030\f\"\u0002H\u0003H\u0007\u00a2\u0006\u0002\u0010\r\u001a(\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005H\u0007\u001a3\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00030\f\"\u0002H\u0003\u00a2\u0006\u0002\u0010\r\u001a(\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005\u001a \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0012\u001a\u00020\u0013\u001a \u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0012\u001a\u00020\u0013\u001a%\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\b\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\t\u001a\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00050\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0006\u00a8\u0006\u0017"}, d2={"beEmpty", "Lio/kotlintest/Matcher;", "", "T", "beSorted", "", "", "contain", "t", "(Ljava/lang/Object;)Lio/kotlintest/Matcher;", "containAll", "ts", "", "([Ljava/lang/Object;)Lio/kotlintest/Matcher;", "containsAll", "containsInOrder", "subsequence", "haveSize", "size", "", "haveSizeMatcher", "singleElement", "sorted", "kotlintest-assertions"})
public final class CollectionMatchersKt {
    @NotNull
    public static final <T> Matcher<Collection<T>> haveSizeMatcher(int size) {
        return new Matcher<Collection<? extends T>>(size){
            final /* synthetic */ int $size;

            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                return new Result(value.size() == this.$size, "Collection should have size " + this.$size + " but has size " + value.size(), "Collection should not have size " + this.$size);
            }
            {
                this.$size = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Collection<T>> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Collection<? extends T>> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> beEmpty() {
        return new Matcher<Collection<? extends T>>(){

            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                return new Result(value.isEmpty(), "Collection should be empty but contained " + DslKt.stringRepr(value), "Collection should not be empty");
            }

            @NotNull
            public Matcher<Collection<T>> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Collection<? extends T>> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @Deprecated(message="use containAll", replaceWith=@ReplaceWith(imports={}, expression="containsAll(ts.asList())"))
    @NotNull
    public static final <T> Matcher<Collection<T>> containsAll(T ... ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return CollectionMatchersKt.containAll(ArraysKt.asList((Object[])ts));
    }

    @Deprecated(message="use containAll", replaceWith=@ReplaceWith(imports={}, expression="containAll(ts)"))
    @NotNull
    public static final <T> Matcher<Collection<T>> containsAll(@NotNull List<? extends T> ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return CollectionMatchersKt.containAll((Collection)ts);
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> containAll(T ... ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return CollectionMatchersKt.containAll(ArraysKt.asList((Object[])ts));
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> containAll(@NotNull Collection<? extends T> ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return new Matcher<Collection<? extends T>>(ts){
            final /* synthetic */ Collection $ts;

            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull(value, (String)"value");
                    Iterable $receiver$iv = this.$ts;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            T it = element$iv;
                            if (value.contains(it)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                boolean bl2 = bl;
                String string2 = "Collection should not contain all of " + CollectionsKt.joinToString$default((Iterable)this.$ts, (CharSequence)", ", null, null, (int)10, null, (Function1)containAll.test.3.INSTANCE, (int)22, null);
                String string3 = "Collection should contain all of " + CollectionsKt.joinToString$default((Iterable)this.$ts, (CharSequence)", ", null, null, (int)10, null, (Function1)containAll.test.2.INSTANCE, (int)22, null);
                boolean bl3 = bl2;
                return new Result(bl3, string3, string2);
            }
            {
                this.$ts = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Collection<T>> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Collection<? extends T>> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> containsInOrder(T ... ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return CollectionMatchersKt.containsInOrder(ArraysKt.asList((Object[])ts));
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> containsInOrder(@NotNull List<? extends T> subsequence) {
        Intrinsics.checkParameterIsNotNull(subsequence, (String)"subsequence");
        return new NeverNullMatcher<Collection<? extends T>>(subsequence){
            final /* synthetic */ List $subsequence$inlined;
            {
                this.$subsequence$inlined = list2;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @NotNull
            public Result testNotNull(@NotNull Object value) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Collection actual = (Collection)value;
                Collection collection = this.$subsequence$inlined;
                boolean bl2 = bl = !collection.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "expected values must not be empty";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                int subsequenceIndex = 0;
                Iterator<E> actualIterator = actual.iterator();
                while (actualIterator.hasNext() && subsequenceIndex < this.$subsequence$inlined.size()) {
                    if (!Intrinsics.areEqual(actualIterator.next(), this.$subsequence$inlined.get(subsequenceIndex))) continue;
                    ++subsequenceIndex;
                }
                return new Result(subsequenceIndex == this.$subsequence$inlined.size(), DslKt.stringRepr(actual) + " did not contain the elements " + DslKt.stringRepr(this.$subsequence$inlined) + " in order", DslKt.stringRepr(actual) + " should not contain the elements " + DslKt.stringRepr(this.$subsequence$inlined) + " in order");
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> haveSize(int size) {
        return CollectionMatchersKt.haveSizeMatcher(size);
    }

    @Deprecated(message="use io.kotlintest.matchers.collection.contain(t)", replaceWith=@ReplaceWith(imports={}, expression="containsMatcher(t)"))
    @NotNull
    public static final <T> Matcher<Collection<T>> contain(T t2) {
        return MatchersKt.contain(t2);
    }

    @NotNull
    public static final <T> Matcher<Collection<T>> singleElement(T t2) {
        return new Matcher<Collection<? extends T>>(t2){
            final /* synthetic */ Object $t;

            @NotNull
            public Result test(@NotNull Collection<? extends T> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                return new Result(value.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)value), (Object)this.$t), "Collection should be a single element of " + this.$t + " but has " + value.size() + " elements", "Collection should not be a single element of " + this.$t);
            }
            {
                this.$t = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Collection<T>> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Collection<? extends T>> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Collection<T>> and(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Collection<T>> or(@NotNull Matcher<Collection<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<T>> beSorted() {
        return CollectionMatchersKt.sorted();
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<T>> sorted() {
        return new Matcher<List<? extends T>>(){

            @NotNull
            public Result test(@NotNull List<? extends T> value) {
                Object v0;
                block1: {
                    Intrinsics.checkParameterIsNotNull(value, (String)"value");
                    Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)value);
                    for (T element$iv : $receiver$iv) {
                        IndexedValue $i_it = (IndexedValue)element$iv;
                        int i = $i_it.component1();
                        Comparable it = (Comparable)$i_it.component2();
                        if (!(i != CollectionsKt.getLastIndex(value) && it.compareTo(value.get(i + 1)) > 0)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                IndexedValue failure = v0;
                String snippet = CollectionsKt.joinToString$default((Iterable)value, (CharSequence)",", null, null, (int)10, null, null, (int)54, null);
                IndexedValue indexedValue = failure;
                String elementMessage = indexedValue == null ? "" : ". Element " + (Comparable)failure.getValue() + " at index " + failure.getIndex() + " was greater than element " + (Comparable)value.get(failure.getIndex() + 1);
                return new Result(failure == null, "List [" + snippet + "] should be sorted" + elementMessage, "List [" + snippet + "] should not be sorted");
            }

            @NotNull
            public Matcher<List<T>> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends List<? extends T>> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<List<T>> and(@NotNull Matcher<List<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<List<T>> or(@NotNull Matcher<List<T>> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }
}

