/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers.doubles;

import io.kotlintest.Matcher;
import io.kotlintest.Result;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\nR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kotlintest/matchers/doubles/ToleranceMatcher;", "Lio/kotlintest/Matcher;", "", "expected", "tolerance", "(Ljava/lang/Double;D)V", "Ljava/lang/Double;", "test", "Lio/kotlintest/Result;", "value", "(Ljava/lang/Double;)Lio/kotlintest/Result;", "kotlintest-assertions"})
public final class ToleranceMatcher
implements Matcher<Double> {
    private final Double expected;
    private final double tolerance;

    @Override
    @NotNull
    public Result test(@Nullable Double value) {
        Result result;
        if (value == null || this.expected == null) {
            result = new Result(Intrinsics.areEqual((Double)value, (Double)this.expected), value + " should be equal to " + this.expected, value + " should not be equal to " + this.expected);
        } else if (Intrinsics.areEqual((double)DoubleCompanionObject.INSTANCE.getNaN(), (Double)this.expected) && Intrinsics.areEqual((double)DoubleCompanionObject.INSTANCE.getNaN(), (Double)value)) {
            String string2 = "[WARN] By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
            boolean bl = false;
            System.out.println((Object)string2);
            result = new Result(false, "By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776", "By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
        } else {
            double diff2;
            if (this.tolerance == 0.0) {
                String string3 = "[WARN] When comparing doubles consider using tolerance, eg: a shouldBe (b plusOrMinus c)";
                boolean bl = false;
                System.out.println((Object)string3);
            }
            result = new Result((diff2 = Math.abs(value - this.expected)) <= this.tolerance, value + " should be equal to " + this.expected, value + " should not be equal to " + this.expected);
        }
        return result;
    }

    public ToleranceMatcher(@Nullable Double expected, double tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @Override
    @NotNull
    public <U> Matcher<U> contramap(@NotNull Function1<? super U, Double> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return Matcher.DefaultImpls.contramap(this, f);
    }

    @Override
    @NotNull
    public Matcher<Double> invert() {
        return Matcher.DefaultImpls.invert(this);
    }

    @Override
    @NotNull
    public <U> Matcher<U> compose(@NotNull Function1<? super U, Double> fn2) {
        Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
        return Matcher.DefaultImpls.compose(this, fn2);
    }

    @Override
    @NotNull
    public Matcher<Double> and(@NotNull Matcher<Double> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return Matcher.DefaultImpls.and(this, other);
    }

    @Override
    @NotNull
    public Matcher<Double> or(@NotNull Matcher<Double> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return Matcher.DefaultImpls.or(this, other);
    }
}

