/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.until;

import io.kotlintest.Failures;
import io.kotlintest.until.FixedIntervalKt;
import io.kotlintest.until.Interval;
import io.kotlintest.until.UntilListener;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a;\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00010\b\u00a2\u0006\u0002\u0010\t\u001a&\u0010\u0000\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u001aC\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00010\b\u00a2\u0006\u0002\u0010\r\u001aQ\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00010\b\u00a2\u0006\u0002\u0010\u0010\u001a&\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000f\"\u0004\b\u0000\u0010\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\n0\u0005\u00a8\u0006\u0012"}, d2={"until", "T", "duration", "Ljava/time/Duration;", "predicate", "Lkotlin/Function1;", "", "f", "Lkotlin/Function0;", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "", "interval", "Lio/kotlintest/until/Interval;", "(Ljava/time/Duration;Lio/kotlintest/until/Interval;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "listener", "Lio/kotlintest/until/UntilListener;", "(Ljava/time/Duration;Lio/kotlintest/until/Interval;Lkotlin/jvm/functions/Function1;Lio/kotlintest/until/UntilListener;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "untilListener", "kotlintest-assertions"})
public final class UntilKt {
    @NotNull
    public static final <T> UntilListener<T> untilListener(@NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return new UntilListener<T>(f){
            final /* synthetic */ Function1 $f;

            public void onEval(T t2) {
                this.$f.invoke(t2);
            }
            {
                this.$f = $captured_local_variable$0;
            }
        };
    }

    public static final void until(@NotNull Duration duration2, @NotNull Interval interval, @NotNull Function0<Boolean> f) {
        Intrinsics.checkParameterIsNotNull((Object)duration2, (String)"duration");
        Intrinsics.checkParameterIsNotNull((Object)interval, (String)"interval");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        long end = System.nanoTime() + duration2.toNanos();
        int count = 0;
        while (System.nanoTime() < end) {
            boolean result = (Boolean)f.invoke();
            if (result) {
                return;
            }
            Thread.sleep(interval.next(++count).toMillis());
        }
        throw (Throwable)((Object)Failures.failure$default(Failures.INSTANCE, "Test failed after " + duration2.getSeconds() + " seconds; attempted " + count + " times", null, 2, null));
    }

    public static /* synthetic */ void until$default(Duration duration2, Interval interval, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration3 = Duration.ofSeconds(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofSeconds(1)");
            interval = FixedIntervalKt.fixedInterval(duration3);
        }
        UntilKt.until(duration2, interval, (Function0<Boolean>)function0);
    }

    public static final <T> T until(@NotNull Duration duration2, @NotNull Function1<? super T, Boolean> predicate, @NotNull Function0<? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)duration2, (String)"duration");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Duration duration3 = Duration.of(1L, ChronoUnit.SECONDS);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.of(1, ChronoUnit.SECONDS)");
        return UntilKt.until(duration2, FixedIntervalKt.fixedInterval(duration3), predicate, UntilListener.Companion.getNoop(), f);
    }

    public static final <T> T until(@NotNull Duration duration2, @NotNull Interval interval, @NotNull Function1<? super T, Boolean> predicate, @NotNull Function0<? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)duration2, (String)"duration");
        Intrinsics.checkParameterIsNotNull((Object)interval, (String)"interval");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return UntilKt.until(duration2, interval, predicate, UntilListener.Companion.getNoop(), f);
    }

    public static final <T> T until(@NotNull Duration duration2, @NotNull Interval interval, @NotNull Function1<? super T, Boolean> predicate, @NotNull UntilListener<? super T> listener, @NotNull Function0<? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)duration2, (String)"duration");
        Intrinsics.checkParameterIsNotNull((Object)interval, (String)"interval");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        long end = System.nanoTime() + duration2.toNanos();
        int count = 0;
        while (System.nanoTime() < end) {
            Object result = f.invoke();
            if (((Boolean)predicate.invoke(result)).booleanValue()) {
                return (T)result;
            }
            listener.onEval(result);
            Thread.sleep(interval.next(++count).toMillis());
        }
        throw (Throwable)((Object)Failures.failure$default(Failures.INSTANCE, "Test failed after " + duration2.getSeconds() + " seconds; attempted " + count + " times", null, 2, null));
    }
}

