/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest;

import io.kotlintest.Failures;
import io.kotlintest.until.FixedIntervalKt;
import io.kotlintest.until.UntilKt;
import io.kotlintest.until.UntilListener;
import java.time.Duration;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a'\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u001a=\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\n\u001a?\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001\"\b\b\u0001\u0010\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"eventually", "T", "duration", "Ljava/time/Duration;", "f", "Lkotlin/Function0;", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "predicate", "Lkotlin/Function1;", "", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "E", "", "exceptionClass", "Ljava/lang/Class;", "(Ljava/time/Duration;Ljava/lang/Class;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlintest-assertions"})
public final class EventuallyKt {
    public static final <T> T eventually(@NotNull Duration duration2, @NotNull Function0<? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)duration2, (String)"duration");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return EventuallyKt.eventually(duration2, Exception.class, f);
    }

    public static final <T, E extends Throwable> T eventually(@NotNull Duration duration2, @NotNull Class<E> exceptionClass, @NotNull Function0<? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)duration2, (String)"duration");
        Intrinsics.checkParameterIsNotNull(exceptionClass, (String)"exceptionClass");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        long end = System.nanoTime() + duration2.toNanos();
        int times = 0;
        Throwable lastError = null;
        while (System.nanoTime() < end) {
            try {
                return (T)f.invoke();
            }
            catch (Throwable e) {
                if (!exceptionClass.isAssignableFrom(e.getClass()) && !AssertionError.class.isAssignableFrom(e.getClass())) {
                    throw e;
                }
                lastError = e;
                ++times;
            }
        }
        String underlyingCause = lastError == null ? "" : "; underlying cause was " + lastError.getLocalizedMessage();
        throw (Throwable)((Object)Failures.INSTANCE.failure("Test failed after " + duration2.getSeconds() + " seconds; attempted " + times + " times" + underlyingCause, lastError));
    }

    @Deprecated(message="To use eventually with a predicate, use await()", replaceWith=@ReplaceWith(imports={}, expression="await(duration, interval, predicate, f)"))
    public static final <T> T eventually(@NotNull Duration duration2, @NotNull Function1<? super T, Boolean> predicate, @NotNull Function0<? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)duration2, (String)"duration");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Duration duration3 = Duration.ofMillis(500L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMillis(500)");
        Function0<? extends T> function0 = f;
        Function1<? super T, Boolean> function1 = predicate;
        UntilListener<Object> untilListener2 = UntilListener.Companion.getNoop();
        return UntilKt.until(duration2, FixedIntervalKt.fixedInterval(duration3), function1, untilListener2, function0);
    }
}

