/*
 * Decompiled with CFR 0.152.
 */
package io.kowalski.jqb2jooq;

import io.kowalski.jqb2jooq.BooleanOperator;
import io.kowalski.jqb2jooq.Filter;
import io.kowalski.jqb2jooq.FilterPart;
import io.kowalski.jqb2jooq.Rule;
import io.kowalski.jqb2jooq.RuleOperator;
import io.kowalski.jqb2jooq.RuleSet;
import io.kowalski.jqb2jooq.RuleTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.tools.reflect.Reflect;

class FilterParser {
    protected static Filter parseJSON(Class<? extends RuleTarget> targetClass, Map<String, Object> jsonFilter) {
        RuleSet outerRuleSet = new RuleSet();
        outerRuleSet.setOperator(BooleanOperator.valueOf(jsonFilter.get("condition").toString()));
        outerRuleSet.setRules(FilterParser.parseRaw(targetClass, FilterParser.parseRulesList(jsonFilter)));
        return new Filter(outerRuleSet);
    }

    private static Collection<FilterPart> parseRaw(Class<? extends RuleTarget> targetClass, List<Map<String, Object>> rules) {
        ArrayList<FilterPart> filterParts = new ArrayList<FilterPart>();
        rules.forEach(rule -> filterParts.add(rule.containsKey("condition") ? FilterParser.parseRawRuleSet(targetClass, rule) : FilterParser.parseRawRule(targetClass, rule)));
        return filterParts;
    }

    private static RuleSet parseRawRuleSet(Class<? extends RuleTarget> targetClass, Map<String, Object> rawRuleSet) {
        RuleSet ruleSet = new RuleSet();
        ruleSet.setOperator(BooleanOperator.valueOf(rawRuleSet.get("condition").toString()));
        ruleSet.setRules(FilterParser.parseRaw(targetClass, FilterParser.parseRulesList(rawRuleSet)));
        return ruleSet;
    }

    private static Rule parseRawRule(Class<? extends RuleTarget> targetClass, Map<String, Object> rawRule) {
        List<Object> rawValues;
        String rawOperator = rawRule.get("operator").toString().toUpperCase();
        String rawField = rawRule.get("field").toString().toUpperCase();
        if (rawRule.get("value") instanceof Collection) {
            rawValues = (List)rawRule.get("value");
        } else {
            rawValues = new ArrayList();
            rawValues.add(rawRule.get("value"));
        }
        Class enumClass = (Class)Reflect.on(targetClass).get();
        Object enumTarget = Enum.valueOf(enumClass, rawField);
        RuleTarget target = (RuleTarget)Reflect.on(enumTarget).get();
        Rule rule = new Rule();
        rule.setOperator(RuleOperator.valueOf(rawOperator));
        rule.setTarget(target);
        rule.setParameters(rawValues);
        return rule;
    }

    private static List<Map<String, Object>> parseRulesList(Map<String, Object> jsonFilter) {
        return (List)jsonFilter.get("rules");
    }

    private FilterParser() {
    }
}

