/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config.tls;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.kroxylicious.proxy.config.secret.PasswordProvider;
import io.kroxylicious.proxy.config.tls.Tls;
import io.kroxylicious.proxy.config.tls.TrustProvider;
import io.kroxylicious.proxy.config.tls.TrustProviderVisitor;
import java.util.Objects;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The paths provide the location for key material which may exist anywhere on the file-system. Paths are provided by the user in the administrator role via Kroxylicious configuration. ")
public record TrustStore(@JsonProperty(required=true) String storeFile, @JsonProperty(value="storePassword") PasswordProvider storePasswordProvider, String storeType) implements TrustProvider
{
    public TrustStore {
        Objects.requireNonNull(storeFile);
    }

    public String getType() {
        return Tls.getStoreTypeOrPlatformDefault(this.storeType);
    }

    public boolean isPemType() {
        return Objects.equals(this.getType(), "PEM");
    }

    @Override
    public <T> T accept(TrustProviderVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

