/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.krpccodegen.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kroxylicious.krpccodegen.schema.FieldSpec;
import io.kroxylicious.krpccodegen.schema.MessageSpecType;
import io.kroxylicious.krpccodegen.schema.RequestListenerType;
import io.kroxylicious.krpccodegen.schema.StructSpec;
import io.kroxylicious.krpccodegen.schema.Versions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class MessageSpec {
    private final StructSpec struct;
    private final Optional<Short> apiKey;
    private final MessageSpecType type;
    private final List<StructSpec> commonStructs;
    private final Versions flexibleVersions;
    private final List<RequestListenerType> listeners;
    private final Optional<Boolean> latestVersionUnstable;

    @JsonCreator
    public MessageSpec(@JsonProperty(value="name") String name, @JsonProperty(value="validVersions") String validVersions, @JsonProperty(value="fields") List<FieldSpec> fields, @JsonProperty(value="apiKey") Short apiKey, @JsonProperty(value="latestVersionUnstable") Boolean latestVersionUnstable, @JsonProperty(value="type") MessageSpecType type, @JsonProperty(value="commonStructs") List<StructSpec> commonStructs, @JsonProperty(value="flexibleVersions") String flexibleVersions, @JsonProperty(value="listeners") List<RequestListenerType> listeners) {
        this.struct = new StructSpec(name, validVersions, fields);
        this.apiKey = apiKey == null ? Optional.empty() : Optional.of(apiKey);
        this.latestVersionUnstable = latestVersionUnstable == null ? Optional.empty() : Optional.of(latestVersionUnstable);
        this.type = Objects.requireNonNull(type);
        List<Object> list = this.commonStructs = commonStructs == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<StructSpec>(commonStructs));
        if (flexibleVersions == null) {
            throw new RuntimeException("You must specify a value for flexibleVersions. Please use 0+ for all new messages.");
        }
        this.flexibleVersions = Versions.parse(flexibleVersions, Versions.NONE);
        if (!this.flexibleVersions().empty() && this.flexibleVersions.highest() < Short.MAX_VALUE) {
            throw new RuntimeException("Field " + name + " specifies flexibleVersions " + String.valueOf(this.flexibleVersions) + ", which is not open-ended.  flexibleVersions must be either none, or an open-ended range (that ends with a plus sign).");
        }
        if (listeners != null && !listeners.isEmpty() && type != MessageSpecType.REQUEST) {
            throw new RuntimeException("The `requestScope` property is only valid for messages with type `request`");
        }
        this.listeners = listeners;
    }

    public StructSpec struct() {
        return this.struct;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.struct.name();
    }

    public Versions validVersions() {
        return this.struct.versions();
    }

    @JsonProperty(value="validVersions")
    public String validVersionsString() {
        return this.struct.versionsString();
    }

    @JsonProperty(value="fields")
    public List<FieldSpec> fields() {
        return this.struct.fields();
    }

    @JsonProperty(value="apiKey")
    public Optional<Short> apiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="latestVersionUnstable")
    public Optional<Boolean> latestVersionUnstable() {
        return this.latestVersionUnstable;
    }

    @JsonProperty(value="type")
    public MessageSpecType type() {
        return this.type;
    }

    @JsonProperty(value="commonStructs")
    public List<StructSpec> commonStructs() {
        return this.commonStructs;
    }

    public Versions flexibleVersions() {
        return this.flexibleVersions;
    }

    @JsonProperty(value="flexibleVersions")
    public String flexibleVersionsString() {
        return this.flexibleVersions.toString();
    }

    @JsonProperty(value="listeners")
    public List<RequestListenerType> listeners() {
        return this.listeners;
    }

    public String dataClassName() {
        switch (this.type) {
            case HEADER: 
            case REQUEST: 
            case RESPONSE: {
                return this.struct.name() + "Data";
            }
        }
        return this.struct.name();
    }
}

