/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.krpccodegen.maven;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.maven.plugin.logging.Log;

class MavenLogger
implements System.Logger {
    private final String name;
    private final Log mavenLog;

    MavenLogger(String name, Log mavenLog) {
        this.name = name;
        this.mavenLog = mavenLog;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        switch (level) {
            case ALL: {
                return true;
            }
            case TRACE: 
            case DEBUG: {
                return this.mavenLog.isDebugEnabled();
            }
            case INFO: {
                return this.mavenLog.isInfoEnabled();
            }
            case WARNING: {
                return this.mavenLog.isWarnEnabled();
            }
            case ERROR: {
                return this.mavenLog.isErrorEnabled();
            }
        }
        return false;
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        switch (level) {
            case TRACE: 
            case DEBUG: {
                this.mavenLog.debug((CharSequence)msg, thrown);
                break;
            }
            case INFO: {
                this.mavenLog.info((CharSequence)msg, thrown);
                break;
            }
            case WARNING: {
                this.mavenLog.warn((CharSequence)msg, thrown);
                break;
            }
            case ALL: 
            case ERROR: {
                this.mavenLog.error((CharSequence)msg, thrown);
                break;
            }
        }
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        switch (level) {
            case TRACE: 
            case DEBUG: {
                this.mavenLog.debug((CharSequence)new MessageFormat(format).format(params));
                break;
            }
            case INFO: {
                this.mavenLog.info((CharSequence)new MessageFormat(format).format(params));
                break;
            }
            case WARNING: {
                this.mavenLog.warn((CharSequence)new MessageFormat(format).format(params));
                break;
            }
            case ALL: 
            case ERROR: {
                this.mavenLog.error((CharSequence)new MessageFormat(format).format(params));
                break;
            }
        }
    }
}

