/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.krpccodegen.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kroxylicious.krpccodegen.schema.EntityType;
import io.kroxylicious.krpccodegen.schema.FieldType;
import io.kroxylicious.krpccodegen.schema.Versions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public final class FieldSpec {
    private static final Pattern VALID_FIELD_NAMES = Pattern.compile("[A-Za-z]([A-Za-z0-9]*)");
    private final String name;
    private final Versions versions;
    private final List<FieldSpec> fields;
    private final FieldType type;
    private final boolean mapKey;
    private final Versions nullableVersions;
    private final String fieldDefault;
    private final boolean ignorable;
    private final EntityType entityType;
    private final String about;
    private final Versions taggedVersions;
    private final Optional<Versions> flexibleVersions;
    private final Optional<Integer> tag;
    private final boolean zeroCopy;

    @JsonCreator
    public FieldSpec(@JsonProperty(value="name") String name, @JsonProperty(value="versions") String versions, @JsonProperty(value="fields") List<FieldSpec> fields, @JsonProperty(value="type") String type, @JsonProperty(value="mapKey") boolean mapKey, @JsonProperty(value="nullableVersions") String nullableVersions, @JsonProperty(value="default") String fieldDefault, @JsonProperty(value="ignorable") boolean ignorable, @JsonProperty(value="entityType") EntityType entityType, @JsonProperty(value="about") String about, @JsonProperty(value="taggedVersions") String taggedVersions, @JsonProperty(value="flexibleVersions") String flexibleVersions, @JsonProperty(value="tag") Integer tag, @JsonProperty(value="zeroCopy") boolean zeroCopy) {
        this.name = Objects.requireNonNull(name);
        if (!VALID_FIELD_NAMES.matcher(this.name).matches()) {
            throw new RuntimeException("Invalid field name " + this.name);
        }
        this.taggedVersions = Versions.parse(taggedVersions, Versions.NONE);
        this.versions = Versions.parse(versions, this.taggedVersions.empty() ? null : this.taggedVersions);
        if (this.versions == null) {
            throw new RuntimeException("You must specify the version of the " + name + " structure.");
        }
        this.fields = Collections.unmodifiableList(fields == null ? Collections.emptyList() : new ArrayList<FieldSpec>(fields));
        this.type = FieldType.parse(Objects.requireNonNull(type));
        this.mapKey = mapKey;
        this.nullableVersions = Versions.parse(nullableVersions, Versions.NONE);
        if (!this.nullableVersions.empty() && !this.type.canBeNullable()) {
            throw new RuntimeException("Type " + String.valueOf(this.type) + " cannot be nullable.");
        }
        this.fieldDefault = fieldDefault == null ? "" : fieldDefault;
        this.ignorable = ignorable;
        this.entityType = entityType == null ? EntityType.UNKNOWN : entityType;
        this.entityType.verifyTypeMatches(name, this.type);
        String string = this.about = about == null ? "" : about;
        if (!(this.fields().isEmpty() || this.type.isArray() || this.type.isStruct())) {
            throw new RuntimeException("Non-array or Struct field " + name + " cannot have fields");
        }
        if (flexibleVersions == null || flexibleVersions.isEmpty()) {
            this.flexibleVersions = Optional.empty();
        } else {
            this.flexibleVersions = Optional.of(Versions.parse(flexibleVersions, null));
            if (!this.type.isString() && !this.type.isBytes()) {
                throw new RuntimeException("Invalid flexibleVersions override for " + name + ".  Only fields of type string or bytes can specify a flexibleVersions override.");
            }
        }
        this.tag = Optional.ofNullable(tag);
        if (this.tag.isPresent() && mapKey) {
            throw new RuntimeException("Tagged fields cannot be used as keys.");
        }
        this.checkTagInvariants();
        this.zeroCopy = zeroCopy;
        if (this.zeroCopy && !this.type.isBytes()) {
            throw new RuntimeException("Invalid zeroCopy value for " + name + ". Only fields of type bytes can use zeroCopy flag.");
        }
    }

    private void checkTagInvariants() {
        if (this.tag.isPresent()) {
            if (this.tag.get() < 0) {
                throw new RuntimeException("Field " + this.name + " specifies a tag of " + String.valueOf(this.tag.get()) + ".  Tags cannot be negative.");
            }
            if (this.taggedVersions.empty()) {
                throw new RuntimeException("Field " + this.name + " specifies a tag of " + String.valueOf(this.tag.get()) + ", but has no tagged versions.  If a tag is specified, taggedVersions must be specified as well.");
            }
            Versions nullableTaggedVersions = this.nullableVersions.intersect(this.taggedVersions);
            if (!nullableTaggedVersions.empty() && !nullableTaggedVersions.equals(this.taggedVersions)) {
                throw new RuntimeException("Field " + this.name + " specifies nullableVersions " + String.valueOf(this.nullableVersions) + " and taggedVersions " + String.valueOf(this.taggedVersions) + ".  Either all tagged versions must be nullable, or none must be.");
            }
            if (this.taggedVersions.highest() < Short.MAX_VALUE) {
                throw new RuntimeException("Field " + this.name + " specifies taggedVersions " + String.valueOf(this.taggedVersions) + ", which is not open-ended.  taggedVersions must be either none, or an open-ended range (that ends with a plus sign).");
            }
            if (!this.taggedVersions.intersect(this.versions).equals(this.taggedVersions)) {
                throw new RuntimeException("Field " + this.name + " specifies taggedVersions " + String.valueOf(this.taggedVersions) + ", and versions " + String.valueOf(this.versions) + ".  taggedVersions must be a subset of versions.");
            }
        } else if (!this.taggedVersions.empty()) {
            throw new RuntimeException("Field " + this.name + " does not specify a tag, but specifies tagged versions of " + String.valueOf(this.taggedVersions) + ".  Please specify a tag, or remove the taggedVersions.");
        }
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    public Versions versions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    public String versionsString() {
        return this.versions.toString();
    }

    @JsonProperty(value="fields")
    public List<FieldSpec> fields() {
        return this.fields;
    }

    @JsonProperty(value="type")
    public String typeString() {
        return this.type.toString();
    }

    public FieldType type() {
        return this.type;
    }

    @JsonProperty(value="mapKey")
    public boolean mapKey() {
        return this.mapKey;
    }

    public Versions nullableVersions() {
        return this.nullableVersions;
    }

    @JsonProperty(value="nullableVersions")
    public String nullableVersionsString() {
        return this.nullableVersions.toString();
    }

    @JsonProperty(value="default")
    public String defaultString() {
        return this.fieldDefault;
    }

    @JsonProperty(value="ignorable")
    public boolean ignorable() {
        return this.ignorable;
    }

    @JsonProperty(value="entityType")
    public EntityType entityType() {
        return this.entityType;
    }

    @JsonProperty(value="about")
    public String about() {
        return this.about;
    }

    @JsonProperty(value="taggedVersions")
    public String taggedVersionsString() {
        return this.taggedVersions.toString();
    }

    public Versions taggedVersions() {
        return this.taggedVersions;
    }

    @JsonProperty(value="flexibleVersions")
    public String flexibleVersionsString() {
        return this.flexibleVersions.isPresent() ? this.flexibleVersions.get().toString() : null;
    }

    public Optional<Versions> flexibleVersions() {
        return this.flexibleVersions;
    }

    @JsonProperty(value="tag")
    public Integer tagInteger() {
        return this.tag.orElse(null);
    }

    public Optional<Integer> tag() {
        return this.tag;
    }

    @JsonProperty(value="zeroCopy")
    public boolean zeroCopy() {
        return this.zeroCopy;
    }

    private void validateNullDefault() {
        if (!this.nullableVersions().contains(this.versions)) {
            throw new RuntimeException("null cannot be the default for field " + this.name + ", because not all versions of this field are nullable.");
        }
    }

    static String collectionType(String baseType) {
        return baseType + "Collection";
    }
}

