/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.krpccodegen.schema;

import io.kroxylicious.krpccodegen.schema.FieldSpec;
import io.kroxylicious.krpccodegen.schema.FieldType;
import io.kroxylicious.krpccodegen.schema.MessageSpec;
import io.kroxylicious.krpccodegen.schema.StructSpec;
import io.kroxylicious.krpccodegen.schema.Versions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class StructRegistry {
    private final Map<String, StructInfo> structs = new TreeMap<String, StructInfo>();
    private final Set<String> commonStructNames = new TreeSet<String>();

    static boolean firstIsCapitalized(String string) {
        if (string.isEmpty()) {
            return false;
        }
        return Character.isUpperCase(string.charAt(0));
    }

    public void register(MessageSpec message) throws Exception {
        for (StructSpec struct : message.commonStructs()) {
            if (!StructRegistry.firstIsCapitalized(struct.name())) {
                throw new RuntimeException("Can't process structure " + struct.name() + ": the first letter of structure names must be capitalized.");
            }
            if (this.structs.containsKey(struct.name())) {
                throw new RuntimeException("Common struct " + struct.name() + " was specified twice.");
            }
            this.structs.put(struct.name(), new StructInfo(struct, struct.versions()));
            this.commonStructNames.add(struct.name());
        }
        this.addStructSpecs(message.validVersions(), message.fields());
    }

    private void addStructSpecs(Versions parentVersions, List<FieldSpec> fields) {
        for (FieldSpec field : fields) {
            String typeName = null;
            if (field.type().isStructArray()) {
                FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
                typeName = arrayType.elementName();
            } else if (field.type().isStruct()) {
                FieldType.StructType structType = (FieldType.StructType)field.type();
                typeName = structType.typeName();
            }
            if (typeName == null) continue;
            if (this.commonStructNames.contains(typeName)) {
                if (!field.fields().isEmpty()) {
                    throw new RuntimeException("Can't re-specify the common struct " + typeName + " as an inline struct.");
                }
            } else {
                if (this.structs.containsKey(typeName)) {
                    throw new RuntimeException("Struct " + typeName + " was specified twice.");
                }
                StructSpec spec = new StructSpec(typeName, field.versions().toString(), field.fields());
                this.structs.put(typeName, new StructInfo(spec, parentVersions));
            }
            this.addStructSpecs(parentVersions.intersect(field.versions()), field.fields());
        }
    }

    public StructSpec findStruct(FieldSpec field) {
        String structFieldName;
        if (field.type().isArray()) {
            FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
            structFieldName = arrayType.elementName();
        } else if (field.type().isStruct()) {
            FieldType.StructType structType = (FieldType.StructType)field.type();
            structFieldName = structType.typeName();
        } else {
            throw new RuntimeException("Field " + field.name() + " cannot be treated as a structure.");
        }
        StructInfo structInfo = this.structs.get(structFieldName);
        if (structInfo == null) {
            throw new RuntimeException("Unable to locate a specification for the structure " + structFieldName);
        }
        return structInfo.spec;
    }

    public boolean isStructArrayWithKeys(FieldSpec field) {
        if (!field.type().isArray()) {
            return false;
        }
        FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
        if (!arrayType.isStructArray()) {
            return false;
        }
        StructInfo structInfo = this.structs.get(arrayType.elementName());
        if (structInfo == null) {
            throw new RuntimeException("Unable to locate a specification for the structure " + arrayType.elementName());
        }
        return structInfo.spec.hasKeys();
    }

    public Set<String> commonStructNames() {
        return this.commonStructNames;
    }

    public List<StructSpec> commonStructs() {
        return this.commonStructNames.stream().map(name -> this.structs.get((Object)name).spec).collect(Collectors.toList());
    }

    public Collection<StructInfo> structs() {
        return this.structs.values();
    }

    public static class StructInfo {
        private final StructSpec spec;
        private final Versions parentVersions;

        StructInfo(StructSpec spec, Versions parentVersions) {
            this.spec = spec;
            this.parentVersions = parentVersions;
        }

        public StructSpec spec() {
            return this.spec;
        }

        public Versions parentVersions() {
            return this.parentVersions;
        }
    }
}

