/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.krpccodegen.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kroxylicious.krpccodegen.schema.FieldSpec;
import io.kroxylicious.krpccodegen.schema.Versions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class StructSpec {
    private final String name;
    private final Versions versions;
    private final List<FieldSpec> fields;
    private final boolean hasKeys;

    @JsonCreator
    public StructSpec(@JsonProperty(value="name") String name, @JsonProperty(value="versions") String versions, @JsonProperty(value="fields") List<FieldSpec> fields) {
        this.name = Objects.requireNonNull(name);
        this.versions = Versions.parse(versions, null);
        if (this.versions == null) {
            throw new RuntimeException("You must specify the version of the " + name + " structure.");
        }
        ArrayList<FieldSpec> newFields = new ArrayList<FieldSpec>();
        if (fields != null) {
            HashSet<Integer> tags = new HashSet<Integer>();
            for (FieldSpec field : fields) {
                Optional<Integer> fieldTag = field.tag();
                if (fieldTag.isPresent()) {
                    if (tags.contains(fieldTag.get())) {
                        throw new RuntimeException("In " + name + ", field " + field.name() + " has a duplicate tag ID " + String.valueOf(fieldTag.get()) + ".  All tags IDs must be unique.");
                    }
                    tags.add(fieldTag.get());
                }
                newFields.add(field);
            }
            for (int i = 0; i < tags.size(); ++i) {
                if (tags.contains(i)) continue;
                throw new RuntimeException("In " + name + ", the tag IDs are not contiguous.  Make use of tag " + i + " before using any higher tag IDs.");
            }
        }
        this.fields = Collections.unmodifiableList(newFields);
        this.hasKeys = this.fields.stream().anyMatch(f -> f.mapKey());
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    public Versions versions() {
        return this.versions;
    }

    @JsonProperty
    public String versionsString() {
        return this.versions.toString();
    }

    @JsonProperty
    public List<FieldSpec> fields() {
        return this.fields;
    }

    public boolean hasKeys() {
        return this.hasKeys;
    }
}

