/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.krpccodegen.main;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import io.kroxylicious.krpccodegen.model.KrpcSchemaObjectWrapper;
import io.kroxylicious.krpccodegen.model.RetrieveApiKey;
import io.kroxylicious.krpccodegen.schema.MessageSpec;
import io.kroxylicious.krpccodegen.schema.StructRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class KrpcGenerator {
    static final ObjectMapper JSON_SERDE = new ObjectMapper();
    private final System.Logger logger;
    private final GeneratorMode mode;
    private final File messageSpecDir;
    private final String messageSpecFilter;
    private final File templateDir;
    private final Charset templateEncoding = StandardCharsets.UTF_8;
    private final List<String> templateNames;
    private final String outputPackage;
    private final File outputDir;
    private final String outputFilePattern;
    private final Charset outputEncoding = StandardCharsets.UTF_8;

    private KrpcGenerator(System.Logger logger, GeneratorMode mode, File messageSpecDir, String messageSpecFilter, File templateDir, List<String> templateNames, String outputPackage, File outputDir, String outputFilePattern) {
        this.logger = logger != null ? logger : System.getLogger(KrpcGenerator.class.getName());
        this.mode = mode;
        this.messageSpecDir = messageSpecDir != null ? messageSpecDir : new File(".");
        this.messageSpecFilter = messageSpecFilter;
        this.templateDir = templateDir;
        this.templateNames = templateNames;
        this.outputPackage = outputPackage;
        this.outputDir = outputDir.toPath().resolve(outputPackage.replace(".", File.separator)).toFile();
        this.outputFilePattern = outputFilePattern;
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
    }

    public static Builder single() {
        return new Builder(GeneratorMode.SINGLE);
    }

    public static Builder multi() {
        return new Builder(GeneratorMode.MULTI);
    }

    public void generate() throws Exception {
        Configuration cfg = this.buildFmConfiguration();
        Set<MessageSpec> messageSpecs = this.messageSpecs();
        if (this.mode == GeneratorMode.SINGLE) {
            for (MessageSpec messageSpec : messageSpecs) {
                this.renderSingle(cfg, messageSpec);
            }
        } else {
            this.renderMulti(cfg, messageSpecs);
        }
    }

    private void renderSingle(Configuration cfg, MessageSpec messageSpec) {
        this.logger.log(System.Logger.Level.INFO, "Processing message spec {0}", messageSpec.name());
        StructRegistry structRegistry = new StructRegistry();
        try {
            structRegistry.register(messageSpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.templateNames.forEach(templateName -> {
            try {
                this.logger.log(System.Logger.Level.DEBUG, "Parsing template {0}", templateName);
                Template template = cfg.getTemplate(templateName);
                File outputFile = new File(this.outputDir, this.outputFile(this.outputFilePattern, messageSpec.name(), (String)templateName));
                this.logger.log(System.Logger.Level.DEBUG, "Opening output file {0}", outputFile);
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.outputEncoding);){
                    this.logger.log(System.Logger.Level.DEBUG, "Processing message spec {0} with template {1} to {2}", messageSpec.name(), templateName, outputFile);
                    Map<String, MessageSpec> dataModel = Map.of("structRegistry", structRegistry, "messageSpec", messageSpec);
                    template.process(dataModel, (Writer)writer);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (TemplateException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void renderMulti(Configuration cfg, Set<MessageSpec> messageSpecs) {
        this.logger.log(System.Logger.Level.INFO, "Processing message specs");
        this.templateNames.forEach(templateName -> {
            try {
                this.logger.log(System.Logger.Level.DEBUG, "Parsing template {0}", templateName);
                Template template = cfg.getTemplate(templateName);
                File outputFile = new File(this.outputDir, this.outputFile(this.outputFilePattern, null, (String)templateName));
                this.logger.log(System.Logger.Level.DEBUG, "Opening output file {0}", outputFile);
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.outputEncoding);){
                    Map<String, RetrieveApiKey> dataModel = Map.of("outputPackage", this.outputPackage, "messageSpecs", messageSpecs, "retrieveApiKey", new RetrieveApiKey());
                    template.process(dataModel, (Writer)writer);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (TemplateException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Set<MessageSpec> messageSpecs() {
        Set paths;
        this.logger.log(System.Logger.Level.INFO, "Finding message specs in {0}", this.messageSpecDir);
        this.logger.log(System.Logger.Level.DEBUG, "{0}", Arrays.toString(this.messageSpecDir.listFiles()));
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.messageSpecDir.toPath(), this.messageSpecFilter);){
            Spliterator spliterator = directoryStream.spliterator();
            paths = StreamSupport.stream(spliterator, false).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return paths.stream().map(inputPath -> {
            try {
                this.logger.log(System.Logger.Level.DEBUG, "Parsing message spec {0}", inputPath);
                MessageSpec messageSpec = (MessageSpec)JSON_SERDE.readValue(inputPath.toFile(), MessageSpec.class);
                this.logger.log(System.Logger.Level.DEBUG, "Loaded {0} from {1}", messageSpec.name(), inputPath);
                return messageSpec;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while processing " + inputPath.toString(), e);
            }
        }).sorted((m1, m2) -> m1.name().compareTo(m2.name())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Configuration buildFmConfiguration() throws Exception {
        Version version = Configuration.VERSION_2_3_31;
        Configuration cfg = new Configuration(version);
        cfg.setDirectoryForTemplateLoading(this.templateDir);
        cfg.setDefaultEncoding(this.templateEncoding.name());
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setObjectWrapper((ObjectWrapper)new KrpcSchemaObjectWrapper(version));
        cfg.setSharedVariable("outputPackage", (Object)this.outputPackage);
        this.logger.log(System.Logger.Level.DEBUG, "Created FreeMarker config");
        return cfg;
    }

    private String outputFile(String pattern, String messageSpecName, String templateName) {
        if (messageSpecName != null) {
            pattern = pattern.replaceAll("\\$\\{messageSpecName\\}", messageSpecName);
        }
        if (templateName != null) {
            templateName = templateName.substring(Math.max(0, templateName.lastIndexOf(File.separator) + 1), templateName.indexOf(".ftl"));
            pattern = pattern.replaceAll("\\$\\{templateName\\}", templateName);
        }
        return pattern;
    }

    static {
        JSON_SERDE.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JSON_SERDE.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
        JSON_SERDE.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        JSON_SERDE.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    static enum GeneratorMode {
        SINGLE,
        MULTI;

    }

    public static class Builder {
        private final GeneratorMode mode;
        private System.Logger logger;
        private File messageSpecDir;
        private String messageSpecFilter;
        private File templateDir;
        private List<String> templateNames;
        private String outputPackage;
        private File outputDir;
        private String outputFilePattern;

        private Builder(GeneratorMode mode) {
            this.mode = mode;
        }

        public Builder withLogger(System.Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder withMessageSpecDir(File messageSpecDir) {
            this.messageSpecDir = messageSpecDir;
            return this;
        }

        public Builder withMessageSpecFilter(String messageSpecFilter) {
            this.messageSpecFilter = messageSpecFilter;
            return this;
        }

        public Builder withTemplateDir(File templateDir) {
            this.templateDir = templateDir;
            return this;
        }

        public Builder withTemplateNames(List<String> templateNames) {
            this.templateNames = templateNames;
            return this;
        }

        public Builder withOutputPackage(String outputPackage) {
            this.outputPackage = outputPackage;
            return this;
        }

        public Builder withOutputDir(File outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public Builder withOutputFilePattern(String outputFilePattern) {
            this.outputFilePattern = outputFilePattern;
            return this;
        }

        public KrpcGenerator build() {
            return new KrpcGenerator(this.logger, this.mode, this.messageSpecDir, this.messageSpecFilter, this.templateDir, this.templateNames, this.outputPackage, this.outputDir, this.outputFilePattern);
        }
    }
}

