/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.krpccodegen.maven;

import io.kroxylicious.krpccodegen.main.KrpcGenerator;
import io.kroxylicious.krpccodegen.maven.MavenLogger;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.build.BuildContext;

abstract class AbstractKrpcGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private File messageSpecDirectory;
    @Parameter(defaultValue="*.json")
    private String messageSpecFilter;
    @Parameter(required=true)
    private File templateDirectory;
    @Parameter(required=true)
    private String templateNames;
    @Parameter(required=true)
    private String outputPackage;
    @Parameter(defaultValue="${messageSpecName}.java")
    private String outputFilePattern;
    @Parameter(defaultValue="compile")
    private String addToProjectSourceRoots;
    @Parameter(defaultValue="${project.build.directory}${file.separator}generated-sources${file.separator}/krpc")
    private File outputDirectory;
    @Component
    private BuildContext buildContext;

    AbstractKrpcGeneratorMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.buildContext == null || !this.buildContext.isIncremental()) {
            List<String> templates = Stream.of(this.templateNames.split(",")).map(String::trim).collect(Collectors.toList());
            KrpcGenerator gen = this.builder().withLogger(new MavenLogger(KrpcGenerator.class.getName(), this.getLog())).withMessageSpecDir(this.messageSpecDirectory).withMessageSpecFilter(this.messageSpecFilter).withTemplateDir(this.templateDirectory).withTemplateNames(templates).withOutputPackage(this.outputPackage).withOutputDir(this.outputDirectory).withOutputFilePattern(this.outputFilePattern).build();
            try {
                gen.generate();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Couldn't generate messages", e);
            }
            String absolutePath = this.outputDirectory.getAbsolutePath();
            Arrays.stream(this.addToProjectSourceRoots.split(",")).forEach(sourceRoot -> {
                switch (sourceRoot) {
                    case "compile": {
                        this.project.addCompileSourceRoot(absolutePath);
                        break;
                    }
                    case "testCompile": {
                        this.project.addTestCompileSourceRoot(absolutePath);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unexpected source root " + sourceRoot);
                    }
                }
            });
        }
    }

    abstract KrpcGenerator.Builder builder();
}

